<?php
// Exit if accessed directly.
if (!defined('ABSPATH')) {
    exit;
}

include_once ABSPATH . 'wp-admin/includes/plugin.php';

class FTM_ACCORDION
{
    private $block_name = 'ftm-accordion';
    private $block_folder_name = 'ftm-accordion';
    private $block_css_manifest_key = 'ftm_accordion';
    private $block_title = 'FTM Accordion';
    private $block_description = '';
    private $block_icon = 'editor-table';
    private $block_keywords = ['ftm', 'custom', 'accordion', 'list', 'dropndown'];
    private $block_mode = 'preview';
    private $block_category = "ftm-blocks";

    public function init()
    {
        $this->register_block();
        $this->register_fields();
    }

    public function load_assets()
    {
        $ftm_blocks_helper = new Ftm_Blocks_Helpers();
        wp_enqueue_style('ftm_accordion-css', $ftm_blocks_helper->webpack($this->block_css_manifest_key . '.css'));

        wp_enqueue_script('ftm_accordion-js', plugin_dir_url(__FILE__) . 'assets/js/ftm-accordion.js');        
    }

    function add_block_to_blacklist($allowed_blocks)
    {
        // get all the registered blocks
        $blocks = WP_Block_Type_Registry::get_instance()->get_all_registered();

        // then disable some of them
        unset($blocks['acf/ftm-accordion']);

        // return the new list of allowed blocks
        return array_keys($blocks);
    }

    public function get_block_name()
    {
        return $this->block_name;
    }

    private function register_block()
    {
        if (function_exists('acf_register_block_type')) {
            $ftm_blocks_helper = new Ftm_Blocks_Helpers();
            acf_register_block_type([
                'name' => $this->block_name,
                'title' => __($this->block_title),
                'description' => __($this->block_description),
                'category' => $this->block_category,
                'icon' => $this->block_icon,
                'keywords' => $this->block_keywords,
                'mode' => $this->block_mode,
                'render_template' => FTMBLOCKS_PLUGIN_DIR . "/blocks/" . $this->block_folder_name . "/render.php",
                'enqueue_assets' => array($this, 'load_assets'),
                'supports' => [
                    'jsx' => true,
                    'color' => [
                        'background' => true,
                        'gradients'  => false,
                        'text' => false,
                    ],
                ],
                'example'  => array(
                    'attributes' => array(
                        'mode' => 'preview',
                        'data' => array(
                            'preview_image_help' => FTMBLOCKS_PLUGIN_URL . "/blocks/" . $this->block_folder_name . "/preview.jpg",
                        )
                    )
                )
            ]);
        }
    }

    private function register_fields()
    {
        add_action('acf/include_fields', function () {
            if (! function_exists('acf_add_local_field_group')) {
                      return;
            }

            acf_add_local_field_group(array(
            'key' => 'group_66d66ba998832',
            'title' => 'FTM-Accordion',
            'fields' => array(
            array(
            'key' => 'field_66d66ba9e5cf2',
            'label' => 'Title Text Color',
            'name' => 'ftm_accordion_head_text_color',
            'aria-label' => '',
            'type' => 'color_picker',
            'instructions' => '',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '#000000',
            'enable_opacity' => 0,
            'return_format' => 'string',
            ),
            array(
            'key' => 'field_66d69b89e5cf3',
            'label' => 'Title BG Color',
            'name' => 'ftm_accordion_head_bg_color',
            'aria-label' => '',
            'type' => 'color_picker',
            'instructions' => '',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => 1,
            'return_format' => 'string',
            ),
            array(
            'key' => 'field_66d69d5ce5cf9',
            'label' => 'Title Open Text Color',
            'name' => 'ftm_accordion_head_open_text_color',
            'aria-label' => '',
            'type' => 'color_picker',
            'instructions' => '',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '#000000',
            'enable_opacity' => 0,
            'return_format' => 'string',
            ),
            array(
            'key' => 'field_66d69d71e5cfa',
            'label' => 'Title Open BG Color',
            'name' => 'ftm_accordion_head_open_bg_color',
            'aria-label' => '',
            'type' => 'color_picker',
            'instructions' => '',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => 1,
            'return_format' => 'string',
            ),
            array(
            'key' => 'field_66d69bc1e5cf4',
            'label' => 'Title Hover Text Color',
            'name' => 'ftm_accordion_head_hover_text_color',
            'aria-label' => '',
            'type' => 'color_picker',
            'instructions' => '',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => 0,
            'return_format' => 'string',
            ),
            array(
            'key' => 'field_66d69c06e5cf5',
            'label' => 'Title Hover BG Color',
            'name' => 'ftm_accordion_head_hover_bg_color',
            'aria-label' => '',
            'type' => 'color_picker',
            'instructions' => '',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => 1,
            'return_format' => 'string',
            ),
            array(
            'key' => 'field_66d71bfa688eb',
            'label' => 'Title Font Size',
            'name' => 'ftm_accordion_title_font_size',
            'aria-label' => '',
            'type' => 'range',
            'instructions' => '',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 16,
            'min' => 1,
            'max' => 57,
            'step' => '',
            'prepend' => '',
            'append' => '',
            ),
            array(
                'key' => 'field_67a61c26a4ba1',
                'label' => 'Title Font Weight',
                'name' => 'ftm_accordion_title_font_weight',
                'aria-label' => '',
                'type' => 'select',
                'instructions' => '',
                'required' => 0,
                'conditional_logic' => 0,
                'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                ),
                'choices' => array(
                    'normal' => 'Normal',
                    'bold' => 'Bold',
                ),
                'default_value' => 'normal',
                'return_format' => 'value',
                'multiple' => 0,
                'allow_null' => 0,
                'ui' => 0,
                'ajax' => 0,
                'placeholder' => '',
                ),
            array(
            'key' => 'field_66d6aa63cdc1c',
            'label' => 'Title HTML Tag',
            'name' => 'ftm_accordion_title_tag',
            'aria-label' => '',
            'type' => 'select',
            'instructions' => '',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'choices' => array(
                'h2' => 'H2',
                'h3' => 'H3',
                'h4' => 'H4',
                'h5' => 'H5',
                'h6' => 'H6',
                'p' => 'Paragraph',
                'div' => 'Div',
                'span' => 'Span',
            ),
            'default_value' => 'div',
            'return_format' => 'value',
            'multiple' => 0,
            'allow_null' => 0,
            'ui' => 0,
            'ajax' => 0,
            'placeholder' => '',
            ),
            array(
            'key' => 'field_66d69c39e5cf6',
            'label' => 'Open Close Icon',
            'name' => 'ftm_accordion_icon_pair',
            'aria-label' => '',
            'type' => 'select',
            'instructions' => '',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'choices' => array(
                'triangle' => 'Triangle',
                'plusminus' => 'Plus and Minus',
                'arrows' => 'Arrows',
            ),
            'default_value' => 'triangle',
            'return_format' => 'value',
            'multiple' => 0,
            'allow_null' => 0,
            'ui' => 0,
            'ajax' => 0,
            'placeholder' => '',
            ),
            array(
            'key' => 'field_66d6a9ad46c75',
            'label' => 'Open Close Icon Color',
            'name' => 'ftm_accordion_icon_color',
            'aria-label' => '',
            'type' => 'color_picker',
            'instructions' => '',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '#000000',
            'enable_opacity' => 0,
            'return_format' => 'string',
            ),
            array(
            'key' => 'field_66d69cd9e5cf7',
            'label' => 'Content BG Color',
            'name' => 'ftm_accordion_content_bg_color',
            'aria-label' => '',
            'type' => 'color_picker',
            'instructions' => '',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => 1,
            'return_format' => 'string',
            ),
            array(
            'key' => 'field_66d69d1ae5cf8',
            'label' => 'Content Text Color',
            'name' => 'ftm_accordion_content_text_color',
            'aria-label' => '',
            'type' => 'color_picker',
            'instructions' => '',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '#000000',
            'enable_opacity' => 1,
            'return_format' => 'string',
            ),
            array(
            'key' => 'field_66d6b95f3ab55',
            'label' => 'Items',
            'name' => 'ftm_accordion_items',
            'aria-label' => '',
            'type' => 'repeater',
            'instructions' => '',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'layout' => 'block',
            'pagination' => 0,
            'min' => 0,
            'max' => 0,
            'collapsed' => '',
            'button_label' => 'Add Row',
            'rows_per_page' => 20,
            'sub_fields' => array(
                array(
					'key' => 'field_66d6b9893ab56',
					'label' => 'Title',
					'name' => 'ftm_accordion_item_title',
					'aria-label' => '',
					'type' => 'text',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '100',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'maxlength' => '',
					'placeholder' => '',
					'prepend' => '',
					'append' => '',
					'parent_repeater' => 'field_66d6b95f3ab55',
				),
				array(
					'key' => 'field_66d6b9a23ab57',
					'label' => 'Content',
					'name' => 'ftm_accordion_item_content',
					'aria-label' => '',
					'type' => 'wysiwyg',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '100',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'tabs' => 'all',
					'toolbar' => 'full',
					'media_upload' => 0,
					'delay' => 0,
					'parent_repeater' => 'field_66d6b95f3ab55',
				),
            ),
            ),
            ),
            'location' => array(
            array(
            array(
                'param' => 'block',
                'operator' => '==',
                'value' => 'acf/ftm-accordion',
            ),
            ),
            ),
            'menu_order' => 0,
            'position' => 'normal',
            'style' => 'default',
            'label_placement' => 'top',
            'instruction_placement' => 'label',
            'hide_on_screen' => '',
            'active' => true,
            'description' => '',
            'show_in_rest' => 0,
            ));
        });
    }
}

$ftm_blocks_accordion_class = new FTM_ACCORDION();
$ftm_blocks_accordion_class->init();

return $ftm_blocks_accordion_class;
