<?php
if (isset($block['data']['preview_image_help'])) {    /* rendering in inserter preview  */
    echo '<img src="' . $block['data']['preview_image_help'] . '" style="width:100%; height:auto;">';
} else {
    $data = array(
        'title_bg_color'         => (get_field('ftm_accordion_head_bg_color') != '' ? get_field('ftm_accordion_head_bg_color'): '#cccccc'),
        'title_open_bg_color'    => (get_field('ftm_accordion_head_open_bg_color') != '' ? get_field('ftm_accordion_head_open_bg_color'): '#eeeeee'),
        'title_hover_bg_color'   => (get_field('ftm_accordion_head_hover_bg_color') != '' ? get_field('ftm_accordion_head_hover_bg_color'): '#eeeeee'),
        'title_text_color'       => (get_field('ftm_accordion_head_text_color') != '' ? get_field('ftm_accordion_head_text_color'): '#000000'),
        'title_text_open_color'  => (get_field('ftm_accordion_head_open_text_color') != '' ? get_field('ftm_accordion_head_open_text_color'): '#000000'),
        'title_text_hover_color' => (get_field('ftm_accordion_head_hover_text_color') != '' ? get_field('ftm_accordion_head_hover_text_color'): '#007bff'),
        'title_text_font_size'   => (get_field('ftm_accordion_title_font_size') != '' ? get_field('ftm_accordion_title_font_size'): '16').'px',       
        'title_icons_color'      => (get_field('ftm_accordion_icon_color') != '' ? get_field('ftm_accordion_icon_color'): '#000000'),
        'title_text_font_weight' => (get_field('ftm_accordion_title_font_weight') != '' ? get_field('ftm_accordion_title_font_weight'): 'normal'),        
        'content_bg_color'       => (get_field('ftm_accordion_content_bg_color') != '' ? get_field('ftm_accordion_content_bg_color'): '#ffffff'),
        'content_text_color'     => (get_field('ftm_accordion_content_text_color') != '' ? get_field('ftm_accordion_content_text_color'): '#0c0c0c'),        
        'block_name'             => 'ftm-accordion'
    );

    $title_icons_name  = (get_field('ftm_accordion_icon_pair') != '' ? get_field('ftm_accordion_icon_pair'): 'triangle');
    $title_tag         = (get_field('ftm_accordion_title_tag') != '' ? get_field('ftm_accordion_title_tag'): 'div');
    $accordion_items   = get_field('ftm_accordion_items');
    $block_unique_id   = "ftm-hedging-calculator_" . $block["id"];
}
?>
<style>
<?php echo '#'.$block_unique_id;
?> {
    --title-bg-color: <?php echo $data['title_bg_color'];?>;
    --title-open-bg-color: <?php echo $data['title_open_bg_color'];?>;
    --title-hover-bg-color: <?php echo $data['title_hover_bg_color'];?>;
    --title-text-color: <?php echo $data['title_text_color'];?>;
    --title-text-open-color: <?php echo $data['title_text_open_color'];?>;
    --title-text-hover-color: <?php echo $data['title_text_hover_color'];?>;
    --title-text-font-size: <?php echo $data['title_text_font_size'];?>;
    --title-text-font-weight: <?php echo $data['title_text_font_weight']; ?>;
    --title-icons-color: <?php echo $data['title_icons_color'];?>;
    --content-bg-color: <?php echo $data['content_bg_color'];?>;
    --content-text-color: <?php echo $data['content_text_color'];?>;    
}
</style>
<div class="ftm-accordion" id="<?php echo $block_unique_id;?>">
    <?php
    if ($accordion_items) {
        foreach ($accordion_items as $item) {
            $accordion_item_title    = $item['ftm_accordion_item_title'];
            $accordion_item_content  = $item['ftm_accordion_item_content'];
            ?>
            <div class="accordion-item">
                <div class="accordion-title">
                    <span class="icon <?php echo $title_icons_name;?>"></span>
                    <?php echo '<' . $title_tag . ' class="title-text" >';?> <?php echo $accordion_item_title; ?><?php echo '</' . $title_tag . '>';?>                    
                </div>
                <div class="accordion-content">
                    <?php echo $accordion_item_content; ?>
                </div>
            </div>
    <?php }
    } ?>
</div>