// get all tab buttons and tab panels
const tabBtns = document.querySelectorAll('.ftm-td-body-header > div')
const tabPanels = document.querySelectorAll('.ftm-td--sites > div')
const mobileToggle = document.querySelector('.ftm-td--trust-toggle')
const mobileTrust = document.querySelector('.ftm-td--how-rate')
const mobileTrustHide = document.querySelector('.ftm-td--trust-content-hide')

mobileTrustHide.addEventListener('click', function () {
    mobileTrust.classList.remove('active')
})

mobileToggle.addEventListener('click', function () {
    mobileTrust.classList.add('active')
})

// loop through all tab buttons
tabBtns.forEach((btn) => {
    // add click event listener to each button
    btn.addEventListener('click', () => {
        // remove 'active' class from all tab buttons
        tabBtns.forEach((tab) => {
            tab.classList.remove('active')
        })
        // add 'active' class to clicked tab button
        btn.classList.add('active')

        // hide all tab panels
        tabPanels.forEach((panel) => {
            panel.classList.remove('active')
        })
        // show selected tab panel
        const tabId = btn.getAttribute('data-tab')
        const selectedPanel = document.getElementById(tabId)
        selectedPanel.classList.add('active')
    })
})
