<?php
// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

class FTM_Blocks_Informative_CTA
{
    private $block_name = 'informative-cta';
    private $block_folder_name = 'informative-cta';
    private $block_css_manifest_key = 'ftm_informative_cta';
    private $block_title = 'Informative CTA';
    private $block_description = '';
    private $block_icon = 'editor-table';
    private $block_keywords = ['ftm', 'custom', 'cta', 'call to action', 'informative'];
    private $block_mode = 'preview';
    private $block_category = "ftm-blocks";

    public function init()
    {
        $this->register_block();
        $this->register_fields();
    }

    public function get_block_name()
    {
        return $this->block_name;
    }

    public function load_assets()
    {
        $ftm_blocks_helper = new Ftm_Blocks_Helpers();
        wp_enqueue_style('ftm_informative-cta', $ftm_blocks_helper->webpack($this->block_css_manifest_key . '.css'));
        wp_enqueue_style('ftm_blocks_icons');
    }

    private function register_block()
    {
        if (function_exists('acf_register_block_type')) {
            $ftm_blocks_helper = new Ftm_Blocks_Helpers();
            acf_register_block_type([
                'name' => $this->block_name,
                'title' => __($this->block_title),
                'description' => __($this->block_description),
                'category' => $this->block_category,
                'icon' => $this->block_icon,
                'keywords' => $this->block_keywords,
                'mode' => $this->block_mode,
                'render_template' => FTMBLOCKS_PLUGIN_DIR . "/blocks/" . $this->block_folder_name . "/render.php",
                'enqueue_assets' => array($this, 'load_assets'),
                'supports' => [
                    'jsx' => true,
                    'color' => [
                        'background' => true,
                        'gradients'  => false,
                        'text' => false,
                    ],
                ],
                'example'  => array(
                    'attributes' => array(
                        'mode' => 'preview',
                        'data' => array(
                            'preview_image_help' => FTMBLOCKS_PLUGIN_URL . "/blocks/" . $this->block_folder_name . "/preview.jpg",
                        )
                    )
                )
            ]);
        }
    }

    private function register_fields()
    {
        if (function_exists('acf_add_local_field_group')) :

            acf_add_local_field_group(array(
                'key' => 'group_6392692301866',
                'title' => 'Informative CTA',
                'fields' => array(
                    array(
                        'key' => 'field_6392730ede651',
                        'label' => 'Block General Settings',
                        'name' => '',
                        'type' => 'tab',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'placement' => 'top',
                        'endpoint' => 0,
                    ),
                    array(
                        'key' => 'field_63926923de64c',
                        'label' => 'Title',
                        'name' => 'title',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => 'Sample Title Text',
                        'maxlength' => '',
                        'placeholder' => 'Enter a title for the informative CTA Box',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_63926c11de64e',
                        'label' => 'Title Tag',
                        'name' => 'title_tag',
                        'type' => 'select',
                        'instructions' => 'Select the HTML element tag used for the title',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => array(
                            'h1' => 'H1',
                            'h2' => 'H2',
                            'h3' => 'H3',
                            'h4' => 'H4',
                            'label' => 'Label',
                            'div' => 'Div',
                            'span' => 'Span',
                        ),
                        'default_value' => 'h2',
                        'return_format' => 'value',
                        'multiple' => 0,
                        'allow_null' => 0,
                        'ui' => 0,
                        'ajax' => 0,
                        'placeholder' => '',
                    ),
                    array(
                        'key' => 'field_63cf05baf1239',
                        'label' => 'Title Alignment',
                        'name' => 'title_alignment',
                        'type' => 'select',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => array(
                            'center' => 'Center',
                            'left' => 'Left',
                            'right' => 'Right',
                        ),
                        'default_value' => 'center',
                        'return_format' => 'value',
                        'multiple' => 0,
                        'allow_null' => 0,
                        'ui' => 0,
                        'ajax' => 0,
                        'placeholder' => '',
                    ),
                    array(
                        'key' => 'field_63926e88de64f',
                        'label' => 'Title Font Size',
                        'name' => 'title_font_size',
                        'type' => 'number',
                        'instructions' => 'Enter the font size for the title in pixels',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => 16,
                        'min' => 0,
                        'max' => 90,
                        'placeholder' => 'Ex: 12px',
                        'step' => 1,
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_63926994de64d',
                        'label' => 'Title Text Color',
                        'name' => 'title_text_color',
                        'type' => 'color_picker',
                        'instructions' => 'Select the color for the box title',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '#FFFFFF',
                        'enable_opacity' => 1,
                        'return_format' => 'string',
                    ),
                    array(
                        'key' => 'field_63cefc6cd8296',
                        'label' => 'Description',
                        'name' => 'text_description',
                        'type' => 'wysiwyg',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'delay' => 1,
                        'tabs' => 'all',
                        'toolbar' => 'full',
                        'media_upload' => 1,
                    ),
                    array(
                        'key' => 'field_63cefca8d8297',
                        'label' => 'Description Text Color',
                        'name' => 'description_text_color',
                        'type' => 'color_picker',
                        'instructions' => 'Select the color for the box title',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '#000000',
                        'enable_opacity' => 1,
                        'return_format' => 'string',
                    ),
                    array(
                        'key' => 'field_639270b1de650',
                        'label' => 'List Items Icon',
                        'name' => 'list_items_icon',
                        'type' => 'select',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => array(
                            'default' => 'Simple Check',
                            'icon-flag' => 'Flag',
                            'icon-heart-empty' => 'Heart Empty',
                            'icon-heart' => 'Heart',
                        ),
                        'default_value' => 'default',
                        'return_format' => 'value',
                        'multiple' => 0,
                        'allow_null' => 0,
                        'ui' => 0,
                        'ajax' => 0,
                        'placeholder' => '',
                    ),
                    array(
                        'key' => 'field_63cb0b9f08427',
                        'label' => 'Icon Color',
                        'name' => 'icon_color',
                        'type' => 'color_picker',
                        'instructions' => 'Select the color for the box title',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '#000000',
                        'enable_opacity' => 1,
                        'return_format' => 'string',
                    ),
                    array(
                        'key' => 'field_63cb0c8508429',
                        'label' => 'List Items Font Size',
                        'name' => 'list_font_size_items',
                        'type' => 'number',
                        'instructions' => 'Enter the font size for the title in pixels',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => 16,
                        'min' => 0,
                        'max' => 90,
                        'placeholder' => 'Ex: 12px',
                        'step' => 1,
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_63cb0c7c08428',
                        'label' => 'List Items Text Color',
                        'name' => 'list_items_text_color',
                        'type' => 'color_picker',
                        'instructions' => 'Select the color for the box title',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '#000000',
                        'enable_opacity' => 1,
                        'return_format' => 'string',
                    ),
                    array(
                        'key' => 'field_6392736ade652',
                        'label' => 'Box Background',
                        'name' => 'box_background',
                        'type' => 'group',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'layout' => 'block',
                        'sub_fields' => array(
                            array(
                                'key' => 'field_63927395de653',
                                'label' => 'Background Type',
                                'name' => 'box_bacground_type',
                                'type' => 'radio',
                                'instructions' => 'Select between having a solid background color or a background image',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'choices' => array(
                                    'default' => 'Default',
                                    'solid' => 'Solid Color',
                                    'image' => 'Background Image',
                                ),
                                'default_value' => 'default',
                                'return_format' => 'value',
                                'allow_null' => 0,
                                'other_choice' => 0,
                                'layout' => 'horizontal',
                                'save_other_choice' => 0,
                            ),
                            array(
                                'key' => 'field_63927432de654',
                                'label' => 'Background Color',
                                'name' => 'box_background_color',
                                'type' => 'color_picker',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_63927395de653',
                                            'operator' => '==',
                                            'value' => 'solid',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '#36afeb',
                                'enable_opacity' => 1,
                                'return_format' => 'string',
                            ),
                            array(
                                'key' => 'field_639274a5de655',
                                'label' => 'Background Image',
                                'name' => 'box_background_image',
                                'type' => 'image',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_63927395de653',
                                            'operator' => '==',
                                            'value' => 'image',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'return_format' => 'url',
                                'library' => 'all',
                                'min_width' => '',
                                'min_height' => '',
                                'min_size' => '',
                                'max_width' => '',
                                'max_height' => '',
                                'max_size' => '',
                                'mime_types' => '',
                                'preview_size' => 'medium',
                            ),
                        ),
                    ),
                    array(
                        'key' => 'field_63927563dd62b',
                        'label' => 'Box Minimum Width',
                        'name' => 'box_minimum_width',
                        'type' => 'number',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => 300,
                        'min' => '',
                        'max' => '',
                        'placeholder' => '',
                        'step' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_6392760cdd62c',
                        'label' => 'Box Min Width Unit',
                        'name' => 'box_min_width_unit',
                        'type' => 'radio',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => array(
                            'pixels' => 'Pixels',
                            'percentage' => 'Percentage',
                        ),
                        'default_value' => 'pixels',
                        'return_format' => 'value',
                        'allow_null' => 0,
                        'other_choice' => 0,
                        'layout' => 'vertical',
                        'save_other_choice' => 0,
                    ),
                    array(
                        'key' => 'field_63927d90c3bd7',
                        'label' => 'CTA Button Settings',
                        'name' => '',
                        'type' => 'tab',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'placement' => 'top',
                        'endpoint' => 0,
                    ),
                    array(
                        'key' => 'field_63927dc1c3bd8',
                        'label' => 'CTA Button Text',
                        'name' => 'cta_button_text',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => 'VISIT NOW',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_63927df4c3bd9',
                        'label' => 'CTA Button URL',
                        'name' => 'cta_button_url',
                        'type' => 'url',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'placeholder' => '',
                    ),
                    array(
                        'key' => 'field_63927f63c3bda',
                        'label' => 'CTA Button Text Color',
                        'name' => 'cta_button_text_color',
                        'type' => 'color_picker',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '#FFFFFF',
                        'enable_opacity' => 0,
                        'return_format' => 'string',
                    ),
                    array(
                        'key' => 'field_63927fe0c3bdb',
                        'label' => 'CTA Button Background Color',
                        'name' => 'cta_button_background_color',
                        'type' => 'color_picker',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '#4075fc',
                        'enable_opacity' => 0,
                        'return_format' => 'string',
                    ),
                    array(
                        'key' => 'field_63a0d9dded08f',
                        'label' => 'CTA Button Hover Color',
                        'name' => 'cta_button_hover_color',
                        'type' => 'color_picker',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '#4075fc',
                        'enable_opacity' => 0,
                        'return_format' => 'string',
                    ),
                    array(
                        'key' => 'field_63928030c3bdc',
                        'label' => 'Block Information',
                        'name' => '',
                        'type' => 'tab',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'placement' => 'top',
                        'endpoint' => 0,
                    ),
                    array(
                        'key' => 'field_6392807dc3bdd',
                        'label' => 'List Items',
                        'name' => 'list_items',
                        'type' => 'repeater',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'layout' => 'block',
                        'pagination' => 0,
                        'min' => 0,
                        'max' => 0,
                        'collapsed' => '',
                        'button_label' => 'Add Row',
                        'rows_per_page' => 20,
                        'sub_fields' => array(
                            array(
                                'key' => 'field_639280b6c3bde',
                                'label' => 'Item Content',
                                'name' => 'item_content',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => 'Lorem ipsum etc',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_6392807dc3bdd',
                            ),
                        ),
                    ),
                ),
                'location' => array(
                    array(
                        array(
                            'param' => 'block',
                            'operator' => '==',
                            'value' => 'acf/informative-cta',
                        ),
                    ),
                ),
                'menu_order' => 0,
                'position' => 'acf_after_title',
                'style' => 'seamless',
                'label_placement' => 'top',
                'instruction_placement' => 'field',
                'hide_on_screen' => '',
                'active' => true,
                'description' => '',
                'show_in_rest' => 0,
            ));

        endif;
    }
}

$ftm_blocks_informative_cta_class = new FTM_Blocks_Informative_CTA();
$ftm_blocks_informative_cta_class->init();

return $ftm_blocks_informative_cta_class;
