<?php

GLOBAL $wpdb;
GLOBAL $ftm_geo_target_plugin_path;

$sucess_alert = '<div class="alert alert-success alert-dismissible show" role="alert">{MESSAGE}<button type="button" class="btn btn-secondary close" data-bs-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button></div>';
$error_alert = '<div class="alert alert-danger alert-dismissible show" role="alert">{MESSAGE}<button type="button" class="btn btn-secondary close" data-bs-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button></div>';
$result = "";

//NO POSTBACK, GENERAL LOAD
$contentId = null;
$groupCountries = null;
$groupRegions = null;
$countries = null;
$regions = null;


//ON UPDATE
if ( isset($_POST["content_id"]) ){

    $contentId = $_POST["content_id"];

    $gactive = false;
    if($_POST["gactive"] === "on"){
        $gactive = true;
    }


    $update = $wpdb->update($wpdb->prefix . "ftm_geo_content",
        array(
            'name'  => ($_POST["gname"]),
            'description'  => ($_POST["gdesc"]),
            'active'  => ($gactive),
            'value' => ($_POST['value'])
        ),
        array ('ContentId' =>  $contentId),
        array(
            '%s',
            '%s',
            '%s',
        )
    );

    if($update !== false){
        //Delete previous countries, regions and sites to add the current ones and maintain the order of the sites
        ftm_geo_target_deleteContentCountries($contentId);
        ftm_geo_target_deleteContentRegions($contentId);

        if(!empty($_POST["allowed_countries_list"])){
            $arr_countries = explode(",",$_POST["allowed_countries_list"]);
            foreach ($arr_countries as $country){
                $insert = $wpdb->insert($wpdb->prefix . "ftm_geo_content_countries",
                    array(
                        'ContentId'  => ($contentId),
                        'CountryCode'  => ($country)
                    ),
                    array(
                        '%d',
                        '%s'
                    )
                );
            }
        }

        if(!empty($_POST["allowed_regions_list"])){
            $arr_regions = explode(",",$_POST["allowed_regions_list"]);
            foreach ($arr_regions as $region){
                $insert = $wpdb->insert($wpdb->prefix . "ftm_geo_content_regions",
                    array(
                        'ContentId'  => ($contentId),
                        'RegionId'  => ($region)
                    ),
                    array(
                        '%d',
                        '%d'
                    )
                );
            }
        }

        $content = ftm_geo_target_getContentById($contentId);
        do_action("ftm_geo_target_update_content", $content);
        $result = true;
    }
    else
    {
        $result = false;
    }
}


//ON LOAD
if(isset($_POST["gedit"])){
    $contentId = $_POST["gedit"];
}
else
{
    if ( isset($_POST["content_id"]) ) {
        $contentId = $_POST["content_id"];
    }
    else
    {
        echo "<script>window.location = '/wp-admin/admin.php?page=ftm-geo-target-content';</script>";
    }
}


if($contentId != null){
    $content = ftm_geo_target_getContentById($contentId);
    $contentCountries = ftm_geo_target_getContentCountries($contentId);
    $contentRegions = ftm_geo_target_getContentRegions($contentId);
    $countries = ftm_geo_target_getCountries();
    $regions = ftm_geo_target_getRegions();
}


?>
<div class="wrap ftm_geo_target">

    <div id="icon-options-general" class="icon32"></div>
    <h1><?php esc_attr_e( 'Edit Content', 'wp_admin_style' ); ?></h1>

    <div id="poststuff">

        <div id="post-body" class="metabox-holder columns-2">

            <!-- main content -->
            <div id="post-body-content">

                <div class="ftm_geo_target">

                    <?php
                    if($result === true){
                        echo str_replace("{MESSAGE}","<strong>Cool!</strong> The content has been updated. Check out the <a href='/wp-admin/admin.php?page=ftm-geo-target-content/'>content list</a> or <a href='/wp-admin/admin.php?page=ftm-geo-target-content-add'>add a new one</a>.", $sucess_alert);
                    }elseif ($result === false){
                        echo str_replace("{MESSAGE}","<strong>Oops!</strong> The content wasn't updated. Please contact support", $error_alert);
                    }
                    ?>

                    <form id="edit_content_form" method="post" action="">
                        <input type="hidden" id="content_id" name="content_id" value="<?php echo $contentId; ?>">

                        <div class="postbox">
                            <h2 class="hndle"><span><b><?php esc_attr_e( 'Step 1. ', 'wp_admin_style' ); ?></b></span>General content details </h2>
                            <div class="inside">

                                <div>Name: <input type="text" class="ftm_geo_target_big_input" name="gname" id="gname" size="60" value="<?php echo $content->name; ?>"/></div>
                                <hr>
                                <div>Description:&nbsp;<input type="text" class="ftm_geo_target_big_input" name="gdesc" size="100" value="<?php echo $content->description; ?>"/></div>
                                <hr>
                                <div>Active:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<input type="checkbox" <?php echo $content->active=='1'?'checked="checked"':''; ?> name="gactive" size="60"/></div>
                            </div>
                        </div>

                        <!-- .postbox -->

                        <div class="postbox">
                            <h2 class="hndle"><span><b><?php esc_attr_e( 'Step 2. ', 'wp_admin_style' ); ?></b></span>Enter the content to show</h2>
                            <div class="inside">
                                <?php
                                echo ("<div class='field_name'>" . __('Content') . "</div>");
                                //ftm_geo_target_html_content_field('value', "");
                                ftm_geo_target_htmlField('wysiwyg', 'value', $content->value);
                                ?>
                            </div>
                        </div>

                        <!-- .postbox -->
                        <div class="postbox">
                            <h2 class="hndle"><span><b><?php esc_attr_e( 'Step 3. ', 'wp_admin_style' ); ?></b></span>Select allowed countries</h2>
                            <div class="inside">
                                <div>
                                    Country:&nbsp;
                                    <select name="ddl_countries" id="ddl_countries" title="Countries" data-placeholder="Choose a Country..." class="chosen-select">
                                        <option value=""></option>
                                        <?php
                                        foreach ($countries as $country){
                                            echo ("<option value='". $country->iso_3166_2 ."' data-class='flag' data-style='background-image:url(". plugins_url() ."/ftm-geo-target/flags/". $country->iso_3166_2 .".png);' >" . $country->name . "</option>");
                                        }
                                        ?>
                                    </select>
                                    <input class="btn btn-primary" onclick="add_sortable_item_list_wflag('allowed_countries',jQuery('#ddl_countries').val(),jQuery('#ddl_countries option:selected').text(),'allowed_countries_list');" type="button" name="add_coutry" id="add_coutry" value="<?php esc_attr_e( 'Add', 'wp_admin_style' ); ?>">
                                </div>
                                <hr>
                                <div id="allowed_countries" class="sortable_list">
                                    <?php
                                    if($contentCountries) {
                                        $countries_tmp = array();
                                        $cont = 0;
                                        foreach ($contentCountries as $country) {
                                            $countries_tmp[$cont] = $country->iso_3166_2;
                                            $cont++;
                                            echo '<div class="sitem" data-text="' . $country->iso_3166_2 . '"><span><img src="'. plugins_url() .'/ftm-geo-target/flags/'. $country->iso_3166_2 .'.png" />' . $country->name . '</span><div class="btn btn-danger btn-lg" onclick="remove_sitem_output(jQuery(this),' . 'allowed_countries_list' . ');"><span class="glyphicon glyphicon-trash"></span></div></div>';
                                        }
                                    }
                                    ?>
                                </div>
                                <input type="hidden" name="allowed_countries_list" value="<?php if($contentCountries) { echo implode(',',$countries_tmp);}?>" id="allowed_countries_list" />
                            </div>
                        </div>
                        <!-- .postbox -->

                        <div class="postbox">
                            <h2 class="hndle"><span><b><?php esc_attr_e( 'Step 4. ', 'wp_admin_style' ); ?></b></span>Select allowed regions (optional)</h2>
                            <div class="inside">
                                <div>
                                    Region:&nbsp;&nbsp;
                                    <select name="ddl_regions" id="ddl_regions" title="Regions">
                                        <?php
                                        foreach ($regions as $region){
                                            echo ("<option value='". $region->regionid ."' data-countrycode='". $region->countrycode ."' >" . $region->regionname . "</option>");
                                        }
                                        ?>
                                    </select>
                                    <input class="btn btn-primary" onclick="add_sortable_item_list('allowed_regions',jQuery('#ddl_regions').val(),jQuery('#ddl_regions option:selected').text(),'allowed_regions_list');" type="button" name="edits" value="<?php esc_attr_e( 'Add', 'wp_admin_style' ); ?>">
                                </div>
                                <hr>
                                <div id="allowed_regions" class="sortable_list">
                                    <?php
                                    if($contentRegions) {
                                        $regions_tmp = array();
                                        $cont = 0;
                                        foreach ($contentRegions as $region) {
                                            $regions_tmp[$cont] = $region->regionid;
                                            $cont++;
                                            echo '<div class="sitem" data-text="' . $region->regionid . '"><span>' . $region->regionname . '</span><div class="btn btn-danger btn-lg" onclick="remove_sitem_output(jQuery(this),' . 'allowed_regions_list' . ');"><span class="glyphicon glyphicon-trash"></span></div></div>';
                                        }
                                    }
                                    ?>
                                </div>
                                <input type="hidden" name="allowed_regions_list" value="<?php if($contentRegions) { echo implode(',',$regions_tmp);}?>" id="allowed_regions_list" />
                            </div>
                        </div>
                        <!-- .postbox -->
                    </form>
                    <script type="text/javascript">
                        jQuery(document).ready(function ($) {
                            $.validator.addMethod( "alphanumeric", function( value, element ) {
                                return this.optional( element ) || /^[a-zA-Z0-9_ ]+$/i.test( value );
                            }, "Alphanumeric values only please" );

                            if ($.validator) {
                                $("#edit_content_form").validate({
                                    debug: true,
                                    rules: {
                                        gname: {
                                            required: true,
                                            alphanumeric: true
                                        },
                                        gdesc: "required"
                                    },
                                    submitHandler: function (form) {
                                        console.log("Submitted!");
                                        form.submit();
                                    }
                                });
                            }
                        });
                    </script>
                </div>
                <!-- .meta-box-sortables .ui-sortable -->

            </div>
            <!-- post-body-content -->

            <!-- sidebar -->
            <?php
            $sidebar_action = "edit";
            require_once $ftm_geo_target_plugin_path . '/includes/sidebar-content-add.php'
            ?>

        </div>

        <br class="clear">
    </div>

    <!-- #poststuff -->

</div> <!-- .wrap -->
