<?php

$ctas  = ftm_geo_target_currentCtas();

?>
<div id="postbox-container-1" class="postbox-container">

    <div class="meta-box-sortables">

        <div class="postbox">

            <div class="handlediv" title="Click to toggle"><br></div>
            <!-- Toggle -->

            <h2 class="hndle"><span><?php esc_attr_e(
                        'Add CTA', 'wp_admin_style'
                    ); ?></span></h2>

            <div class="inside">
                <form name="ftm_geo_target_site_add" method="post" action="/wp-admin/admin.php?page=ftm-geo-target-ctas-add">
                    <p><?php esc_attr_e( 'Click the button below to add a new cta' ); ?></p>
                    <input class="btn btn-primary" type="submit" name="adds" value="<?php esc_attr_e( 'Add a new cta' ); ?>" />
                </form>
            </div>
            <!-- .inside -->

        </div>
        <!-- .postbox -->

        <?php if(sizeof($ctas) > 0){ ?>
        <div class="postbox">
            <div class="handlediv" title="Click to toggle"><br></div>
            <!-- Toggle -->

            <h2 class="hndle"><span><?php esc_attr_e(
                        'Edit CTA', 'wp_admin_style'
                    ); ?></span></h2>

            <div class="inside">
                <p><?php esc_attr_e( 'Please choose a cta to edit', 'wp_admin_style' ); ?></p>
                <form method="post" action="/wp-admin/admin.php?page=ftm-geo-target-ctas-edit">
                    <select name="gedit">
                        <?php
                        if(!empty($ctas)) {
                            foreach ($ctas as $cta) {
                                ?>
                                <option value="<?php print $cta->CtaId; ?>"><?php print stripcslashes($cta->CtaName); ?></option>
                                <?php
                            }
                        }
                        ?>
                    </select>
                    <input class="btn btn-primary" type="submit" name="edits" value="<?php esc_attr_e( 'Edit' ); ?>" />
                </form>
            </div>
            <!-- .inside -->

        </div>
        <!-- .postbox -->

        <?php } ?>

    </div>
    <!-- .meta-box-sortables -->

</div>
