
<?php
GLOBAL $wpdb;
$status = "";
$sucess_alert = '<div class="alert alert-warning alert-dismissible show" role="alert">{MESSAGE}<button type="button" class="close" data-bs-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button></div>';
$error_alert = '<div class="alert alert-danger alert-dismissible show" role="alert">{MESSAGE}<button type="button" class="close" data-bs-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button></div>';

if(isset($_POST["group_delete_id"])){
    $group_delete_id = $_POST["group_delete_id"];

    ftm_geo_target_deleteGroupCountries($group_delete_id);
    ftm_geo_target_deleteGroupRegions($group_delete_id);
    ftm_geo_target_deleteGroupSites($group_delete_id);


    if(ftm_geo_target_deleteGroup($group_delete_id)){
        $status = true;
    }
    else
    {
        $status = false;
    }
}


$groups  = ftm_geo_target_currentGroups();

?>
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.19/css/jquery.dataTables.css">
<script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/1.10.19/js/jquery.dataTables.js"></script>

<div class="modal fade" id="delete_modal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title" id="myModalLabel">Delete Confirmation</h4>
            </div>
            <div class="modal-body">
                <form id="delete_group_form" name="delete_group_form" action="/wp-admin/admin.php?page=ftm-geo-target-site-groups"  method="post">
                    <fieldset>
                        <div class="form-group">
                            <h4>Are you sure you want to delete this group?</h4>
                        </div>
                        <br>
                        <div class="form-group">
                            <p>By deleting this group, you will also delete it's geo targeting rules and settings. You could also deactivate it if not 100% sure you want to re-enter the data later on.</p>
                        </div>
                        <!-- Allow form submission with keyboard without duplicating the dialog button -->
                        <input type="hidden" name="group_delete_id" id="group_delete_id">
                        <input type="submit" id="diag_form_submit" tabindex="-1" style="position:absolute; top:-1000px">
                    </fieldset>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-bs-dismiss="modal">Close</button>
                <button type="submit" form="delete_group_form" class="btn btn-primary">Delete Group</button>
            </div>
        </div>
    </div>
</div>

<?php
if($status !== "") {
    if ($status === true) {
        echo str_replace("{MESSAGE}", "<strong>Done!</strong> The group has been successfully deleted.", $sucess_alert);
    } elseif ($status === false) {
        echo str_replace("{MESSAGE}", "<strong>Oops!</strong> There was a problem deleting this group, please contact support.", $error_alert);
    }
}
?>

<div class="wrap ftm_geo_target">
	<div id="icon-options-general" class="icon32"></div>
	<h1><?php esc_attr_e( 'Geo-Target Site Groups', 'wp_admin_style' ); ?></h1>
	<div id="poststuff">
		<div id="post-body" class="metabox-holder columns-2">
			<!-- main content -->
			<div id="post-body-content">
				<div class="postbox">
					<h2 class="hndle"><i><?php esc_attr_e('Here you can group sites by sets of geo target restrictions.', 'wp_admin_style'); ?></i></h2>
					<div class="inside">
                        <b>Current Groups</b>
                        <div>
                            <?php if(sizeof($groups) === 0){ ?>
                                <div><i><?php esc_attr_e('-- No groups added yet --', 'wp_admin_style'); ?></i></div>
                            <?php } else {?>
                                <br><br>
                                <table id="site_groups_list" class="sites_list">
                                    <thead>
                                      <tr>
                                          <th>Group Name</th>
                                          <th>Group Description</th>
                                          <th>Group ShortCode</th>
                                          <th>Group Active</th>
                                          <th>Group's Parent</th>
                                          <th>Actions</th>
                                      </tr>
                                    </thead>
                                    <tbody>
                                    <?php
                                    foreach ($groups as $group){?>
                                        <tr class="site_entry">
                                            <td><?php echo $group->GroupName; ?></td>
                                            <td><?php echo $group->GroupDescription; ?></td>
                                            <td><?php echo '[ftm_gt g="' . str_replace(" ", "-", $group->GroupName) . '"]'; ?></td>
                                            <td><?php if($group->GroupActive === "1"){ echo "Yes"; }else{echo "No";} ?></td>
                                            <td>
                                                <?php if(! empty($group->ParentName)){ ?>
                                                    <form method="post" action="/wp-admin/admin.php?page=ftm-geo-target-group-edit"> <input id="gedit" name="gedit" type="hidden" value="<?php echo($group->ParentGroupId);?>"><button class="btn btn-warning" name="edits" type="submit"><?php echo $group->ParentName; ?></button> </form>
                                                <?php } ?>
                                            </td>
                                            <td class="site_actions">
                                                <form method="post" action="/wp-admin/admin.php?page=ftm-geo-target-group-edit"> <input id="gedit" name="gedit" type="hidden" value="<?php echo($group->GroupId);?>"><button class="btn btn-warning" name="edits" type="submit">Edit</button> </form> |
                                                <a href="/wp-admin/admin.php?page=ftm-geo-target-group-customize&group=<?php echo $group->GroupId ?>" class="btn btn-info">Customize Labels</a> |
                                                <button class="btn btn-danger"  data-bs-toggle="modal" data-bs-target="#delete_modal"  onclick="fill_confirm_popup_key_value('delete_group_form','group_delete_id','<?php echo($group->GroupId);?>');" name="delete_group" type="submit">Delete</button>
                                            </td>
                                        </tr>
                                        <?php
                                    }
                                    ?>
                                    </tbody>
                                </table>
                            <?php } ?>
                        </div>
					</div>
				</div>
				<!-- .meta-box-sortables .ui-sortable -->
			</div>
			<!-- post-body-content -->
			<!-- sidebar -->
			<?php
                GLOBAL $ftm_geo_target_plugin_path;
			    require_once $ftm_geo_target_plugin_path . '/includes/sidebar-groups.php';
			?>
			<!-- sidebar -->
			<!-- #postbox-container-1 .postbox-container -->
		</div>
		<!-- #post-body .metabox-holder .columns-2 -->
		<br class="clear">
	</div>
	<!-- #poststuff -->
</div> <!-- .wrap -->

