<?php

$contents  = ftm_geo_target_currentContent();

?>
<div id="postbox-container-1" class="postbox-container">

    <div class="meta-box-sortables">

        <div class="postbox">

            <div class="handlediv" title="Click to toggle"><br></div>
            <!-- Toggle -->

            <h2 class="hndle"><span><?php esc_attr_e(
                        'Add Content', 'wp_admin_style'
                    ); ?></span></h2>

            <div class="inside">
                <form name="ftm_geo_target_content_add" method="post" action="<?php echo FTM_WP_INSTALL_PREFIX; ?>/wp-admin/admin.php?page=ftm-geo-target-content-add">
                    <p><?php esc_attr_e( 'Click the button below to add a new content' ); ?></p>
                    <input class="btn btn-primary" type="submit" name="adds" value="<?php esc_attr_e( 'Add a new content' ); ?>" />
                </form>
            </div>
            <!-- .inside -->

        </div>
        <!-- .postbox -->

        <?php if(sizeof($contents) > 0){ ?>
            <div class="postbox">
                <div class="handlediv" title="Click to toggle"><br></div>
                <!-- Toggle -->

                <h2 class="hndle"><span><?php esc_attr_e(
                            'Edit Content', 'wp_admin_style'
                        ); ?></span></h2>

                <div class="inside">
                    <p><?php esc_attr_e( 'Please choose a content to edit', 'wp_admin_style' ); ?></p>
                    <form method="post" action="<?php echo FTM_WP_INSTALL_PREFIX; ?>/wp-admin/admin.php?page=ftm-geo-target-content-edit">
                        <select name="gedit">
                            <?php
                            if(!empty($contents)) {
                                foreach ($contents as $content) {
                                    ?>
                                    <option value="<?php print $content->ContentId; ?>"><?php print stripcslashes($content->name); ?></option>
                                    <?php
                                }
                            }
                            ?>
                        </select>
                        <input class="btn btn-primary" type="submit" name="edits" value="<?php esc_attr_e( 'Edit' ); ?>" />
                    </form>
                </div>
                <!-- .inside -->

            </div>
            <!-- .postbox -->

        <?php } ?>

    </div>
    <!-- .meta-box-sortables -->

</div>
