<?php

function ftm_geo_target_menu(){

    add_menu_page(
        'FTM Geo Target',
        'FTM Geo Target',
        'manage_options',
        'ftm-geo-target',
        'ftm_geo_target_options_page',
        plugins_url( 'ftm-geo-target/images/icon.png' )
    );

    add_submenu_page('ftm-geo-target', 'FTM Geo Target Sites Option Fields', 'Site Option Fields', 'manage_options', 'ftm-geo-target-site-fields', 'ftm_geo_target_site_fields');
    add_submenu_page('ftm-geo-target', 'FTM Geo Target Sites', 'Sites', 'manage_options', 'ftm-geo-target-sites', 'ftm_geo_target_sites');
    add_submenu_page('ftm-geo-target', 'FTM Geo Target Site Groups', 'Site Groups', 'manage_options', 'ftm-geo-target-site-groups', 'ftm_geo_target_site_groups');
    add_submenu_page('ftm-geo-target', 'FTM Geo Target Banned', 'Global Referral Banned Places', 'manage_options', 'ftm-geo-target-banned', 'ftm_geo_target_banned');
    add_submenu_page('ftm-geo-target', 'FTM Geo Target Banned', 'Report Banned Links', 'manage_options', 'ftm-geo-target-banned-report', 'ftm_geo_target_banned_report');
    add_submenu_page('ftm-geo-target', 'FTM Geo Target Content', 'Content', 'manage_options', 'ftm-geo-target-content', 'ftm_geo_target_content');
    add_submenu_page('ftm-geo-target', 'FTM Geo Target CTAs', 'CTAs', 'manage_options', 'ftm-geo-target-ctas', 'ftm_geo_target_ctas');
    add_submenu_page('ftm-geo-target', 'FTM Geo Target CTAs Auto', 'CTAs Auto', 'manage_options', 'ftm-geo-target-ctas-auto', 'ftm_geo_target_ctas_auto');
    add_submenu_page('ftm-geo-target', 'FTM Geo Target Themes', 'Themes', 'manage_options', 'ftm-geo-target-themes', 'ftm_geo_target_themes_page');
    add_submenu_page('ftm-geo-target', 'FTM Geo Target Settings', 'Settings', 'manage_options', 'ftm-geo-target-settings', 'ftm_geo_target_settings');
    add_submenu_page('ftm-geo-target', 'FTM Geo Target Help', 'Help', 'manage_options', 'ftm-geo-target-help', 'ftm_geo_target_help');



    add_submenu_page('ftm-geo-target-sites', 'Add Site', 'Site Add', 'manage_options', 'ftm-geo-target-site-add', 'ftm_geo_target_sites_add');
    add_submenu_page('ftm-geo-target-sites', 'Edit Site', 'Site Edit', 'manage_options', 'ftm-geo-target-site-edit', 'ftm_geo_target_sites_edit');

    add_submenu_page('ftm-geo-target-groups', 'Add Group', 'Add Group', 'manage_options', 'ftm-geo-target-group-add', 'ftm_geo_target_groups_add');
    add_submenu_page('ftm-geo-target-groups', 'Edit Group', 'Edit Group', 'manage_options', 'ftm-geo-target-group-edit', 'ftm_geo_target_groups_edit');
    add_submenu_page('ftm-geo-target-groups', 'Customize Group', 'Customize Group', 'manage_options', 'ftm-geo-target-group-customize', 'ftm_geo_target_groups_customize');

    add_submenu_page('ftm-geo-target-content', 'Add Content', 'Add Content', 'manage_options', 'ftm-geo-target-content-add', 'ftm_geo_target_content_add');
    add_submenu_page('ftm-geo-target-content', 'Edit Content', 'Edit Content', 'manage_options', 'ftm-geo-target-content-edit', 'ftm_geo_target_content_edit');

    add_submenu_page('ftm-geo-target-groups', 'Add CTA', 'Add CTA', 'manage_options', 'ftm-geo-target-ctas-add', 'ftm_geo_target_ctas_add');
    add_submenu_page('ftm-geo-target-groups', 'Edit CTA', 'Edit CTA', 'manage_options', 'ftm-geo-target-ctas-edit', 'ftm_geo_target_ctas_edit');

    add_submenu_page('ftm-geo-target-ctas-auto', 'CTA Auto Set', 'CTA Auto Set', 'manage_options', 'ftm-geo-target-ctas-auto-set', 'ftm_geo_target_ctas_auto_set');

}

//PLUGIN OWN PAGES
function ftm_geo_target_site_fields(){
    global $ftm_geo_target_plugin_path;
    if(!current_user_can('manage_options')){
        wp_die('You don\'t have enough permissions to access this page.');
    }

    ftm_geo_target_enqueue_admin_styles();
    require($ftm_geo_target_plugin_path . '/includes/options-page-sites-fields.php');
}

function ftm_geo_target_site_groups(){
    global $ftm_geo_target_plugin_path;
    if(!current_user_can('manage_options')){
        wp_die('You don\'t have enough permissions to access this page.');
    }
    ftm_geo_target_enqueue_admin_styles();
    require($ftm_geo_target_plugin_path . '/includes/wizard.php');
}

function ftm_geo_target_content(){
    global $ftm_geo_target_plugin_path;
    if(!current_user_can('manage_options')){
        wp_die('You don\'t have enough permissions to access this page.');
    }
    require($ftm_geo_target_plugin_path . '/includes/content.php');
}

function ftm_geo_target_ctas() {
    global $ftm_geo_target_plugin_path;
    if(!current_user_can('manage_options')){
        wp_die('You don\'t have enough permissions to access this page.');
    }
    ftm_geo_target_enqueue_admin_styles();
    require($ftm_geo_target_plugin_path . '/includes/options-page-ctas.php');
}

function ftm_geo_target_ctas_add(){
    global $ftm_geo_target_plugin_path;
    if(!current_user_can('manage_options')){
        wp_die('You don\'t have enough permissions to access this page.');
    }
    ftm_geo_target_enqueue_admin_styles();
    require($ftm_geo_target_plugin_path . '/includes/options-page-ctas-add.php');
}

function ftm_geo_target_ctas_edit(){
    global $ftm_geo_target_plugin_path;
    if(!current_user_can('manage_options')){
        wp_die('You don\'t have enough permissions to access this page.');
    }
    ftm_geo_target_enqueue_admin_styles();
    require($ftm_geo_target_plugin_path . '/includes/options-page-ctas-edit.php');
}

function ftm_geo_target_ctas_auto() {
    global $ftm_geo_target_plugin_path;
    if(!current_user_can('manage_options')){
        wp_die('You don\'t have enough permissions to access this page.');
    }
    ftm_geo_target_enqueue_admin_styles();
    require($ftm_geo_target_plugin_path . '/includes/options-page-ctas-auto.php');
}

function ftm_geo_target_ctas_auto_set() {
    global $ftm_geo_target_plugin_path;
    if(!current_user_can('manage_options')){
        wp_die('You don\'t have enough permissions to access this page.');
    }
    ftm_geo_target_enqueue_admin_styles();
    require($ftm_geo_target_plugin_path . '/includes/options-page-ctas-auto-set.php');
}

function ftm_geo_target_options_page(){
    global $ftm_geo_target_plugin_path;
    if(!current_user_can('manage_options')){

        wp_die('You don\'t have enough permissions to access this page.');

    }

    $current_ip = $_SERVER["REMOTE_ADDR"];
    $test_ip = null;
    $test_groups = '';
    $country = null;
    $region = null;
    $selected_group = null;

    if (isset($_POST) && isset($_POST['test_groups']) && isset($_POST['test_ip'])) {
        $test_ip = $_POST['test_ip'];
        $test_groups = $_POST['test_groups'];
        // Fix up entry in case they added additional data
        $test_groups = preg_replace('/(\[|\]|ftm_gt|g=|"| |theme="[0-9a-z_]*")/i', '', $test_groups);
        $test_groups = stripslashes($test_groups);
        $groups = explode(',', $test_groups);
        $ftm_geo_target_plugin_url     = WP_PLUGIN_URL . '/ftm-geo-target';
        $ftm_geo_target_plugin_path    = WP_PLUGIN_DIR . '/ftm-geo-target';
        $settings = ftm_geo_target_getSettings();

        $rsGeoData = ftm_gt_getGeoCodesFromIP($test_ip);
        $country = $rsGeoData[0];
        $region = $rsGeoData[1];

        // If no group selected we return empty
        $group_id_selected = ftm_gt_find_match_group($groups, $country, $region);
        $data = ftm_geo_target_getGroupById($group_id_selected);
        $selected_group = count($data) > 0 ? $data[0]:null;
    }
    $test_ip = $test_ip?$test_ip:$current_ip;

    require($ftm_geo_target_plugin_path . '/includes/options-page-wrapper.php');

}

function ftm_geo_target_sites(){
    global $ftm_geo_target_plugin_path;
    if(!current_user_can('manage_options')){
        wp_die('You don\'t have enough permissions to access this page.');
    }
    ftm_geo_target_enqueue_admin_styles();
    require($ftm_geo_target_plugin_path . '/includes/options-page-sites.php');
}

function ftm_geo_target_sites_add(){
    global $ftm_geo_target_plugin_path;
    //die($ftm_geo_target_plugin_path);
    if(!current_user_can('manage_options')){
        wp_die('You don\'t have enough permissions to access this page.');
    }
    ftm_geo_target_enqueue_admin_styles();
    require($ftm_geo_target_plugin_path . '/includes/options-page-sites-add.php');
}

function ftm_geo_target_sites_edit(){
    global $ftm_geo_target_plugin_path;
    if(!current_user_can('manage_options')){
        wp_die('You don\'t have enough permissions to access this page.');
    }
    ftm_geo_target_enqueue_admin_styles();
    require($ftm_geo_target_plugin_path . '/includes/options-page-sites-edit.php');
}

function ftm_geo_target_groups_add(){
    global $ftm_geo_target_plugin_path;
    if(!current_user_can('manage_options')){
        wp_die('You don\'t have enough permissions to access this page.');
    }
    ftm_geo_target_enqueue_admin_styles();
    require($ftm_geo_target_plugin_path . '/includes/options-page-groups-add.php');
}

function ftm_geo_target_groups_edit(){
    global $ftm_geo_target_plugin_path;
    if(!current_user_can('manage_options')){
        wp_die('You don\'t have enough permissions to access this page.');
    }
    ftm_geo_target_enqueue_admin_styles();
    require($ftm_geo_target_plugin_path . '/includes/options-page-groups-edit.php');
}

function ftm_geo_target_groups_customize(){
    global $ftm_geo_target_plugin_path;
    if(!current_user_can('manage_options')){
        wp_die('You don\'t have enough permissions to access this page.');
    }
    ftm_geo_target_enqueue_admin_styles();
    require($ftm_geo_target_plugin_path . '/includes/options-page-groups-customize.php');
}

function ftm_geo_target_content_add(){
    global $ftm_geo_target_plugin_path;
    if(!current_user_can('manage_options')){
        wp_die('You don\'t have enough permissions to access this page.');
    }
    ftm_geo_target_enqueue_admin_styles();
    require($ftm_geo_target_plugin_path . '/includes/options-page-content-add.php');
}

function ftm_geo_target_content_edit(){
    global $ftm_geo_target_plugin_path;
    if(!current_user_can('manage_options')){
        wp_die('You don\'t have enough permissions to access this page.');
    }
    ftm_geo_target_enqueue_admin_styles();
    require($ftm_geo_target_plugin_path . '/includes/options-page-content-edit.php');
}

function ftm_geo_target_themes_page(){
    global $ftm_geo_target_plugin_path;
    if(!current_user_can('manage_options')){
        wp_die('You don\'t have enough permissions to access this page.');
    }
    ftm_geo_target_enqueue_admin_styles();
    require($ftm_geo_target_plugin_path . '/includes/ftm-geo-target-themes.php');
}

function ftm_geo_target_settings(){
    global $ftm_geo_target_plugin_path;
    if(!current_user_can('manage_options')){
        wp_die('You don\'t have enough permissions to access this page.');
    }
    ftm_geo_target_enqueue_admin_styles();
    require($ftm_geo_target_plugin_path . '/includes/ftm-geo-target-settings.php');
}

function ftm_geo_target_help(){
    global $ftm_geo_target_plugin_path;
    if(!current_user_can('manage_options')){
        wp_die('You don\'t have enough permissions to access this page.');
    }
    ftm_geo_target_enqueue_admin_styles();
    require($ftm_geo_target_plugin_path . '/includes/ftm-geo-target-help.php');
}

function ftm_geo_target_banned() {
    if(!current_user_can('manage_options')){
        wp_die('You don\'t have enough permissions to access this page.');
    }

    global $ftm_geo_target_plugin_path, $plugin_url, $plugin_path;
    $default_configuration = ftm_geo_target_get_default_banned_configuration();
    $banned_configuration = get_option( 'ftmgt_banned_configuration', $default_configuration);
    $country = null;
    $region = null;

    if (isset($_POST) && count($_POST) > 0) {
        $ftm_geo_target_plugin_url     = WP_PLUGIN_URL . '/ftm-geo-target';
        $ftm_geo_target_plugin_path    = WP_PLUGIN_DIR . '/ftm-geo-target';

        $banned_configuration = [
            'active' => isset($_POST['banned_active']),
            'countries' => explode(',', $_POST['banned_countries_list']),
            'regions' => explode(',', $_POST['banned_regions_list']),
            'affiliate_folder' => $_POST['banned_affiliate_folder'],
        ];
        update_option('ftmgt_banned_configuration', $banned_configuration);

    }
    ftm_geo_target_enqueue_admin_styles();
    require($ftm_geo_target_plugin_path . '/includes/banned.php');
}

function ftm_geo_target_banned_report() {
    global $ftm_geo_target_plugin_path;
    if(!current_user_can('manage_options')){
        wp_die('You don\'t have enough permissions to access this page.');
    }
    wp_enqueue_script('jquery-ui-datepicker');
    require($ftm_geo_target_plugin_path . '/includes/banned-report.php');
}

