<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.19/css/jquery.dataTables.css">
<div class="wrap ftm_geo_target">

    <div id="icon-options-general" class="icon32"></div>
    <h1><?php esc_attr_e( 'Geo Target Plugin', 'wp_admin_style' ); ?></h1>

    <div id="poststuff">

        <div id="post-body" class="metabox-holder">

            <!-- main content -->
            <div id="post-body-content">

                <div class="meta-box-sortables ui-sortable">

                    <div class="postbox">

                        <!-- Toggle -->

                        <h2 class="hndle"><span><?php esc_attr_e( 'Blocked Clicks', 'wp_admin_style' ); ?></span>
                        </h2>

                        <div class="inside">
                            <p>The report of clicks that were blocked by the functionality.</p>

                            <div id="site_groups_list_wrapper" class="dataTables_wrapper no-footer">
                                <div id="site_groups_list_filter" class="dataTables_filter">
                                    <label>Start Date:<input type="start" class="" placeholder="2020-01-01" id="start-date"></label>
                                    <label>End Date:<input type="end" class="" placeholder="2021-12-31" id="end-date"></label>
                                </div>
                            <table class="sites_list dataTable">
                                <thead>
                                <tr>
                                    <th><?php _e('Date/Time') ?></th>
                                    <th><?php _e('IP') ?></th>
                                    <th><?php _e('Country') ?></th>
                                    <th><?php _e('Region') ?></th>
                                    <th><?php _e('Page') ?></th>
                                    <th><?php _e('Destination') ?></th>
                                    <th><?php _e('Link Text') ?></th>
                                </tr>
                                </thead>
                                <tbody id="report-content">
                                </tbody>
                                <tfoot>
                                <tr>
                                    <td colspan="7">
                                        <div class="dataTables_info" id="site_groups_list_info">Page <span id="info-page"></span> of <span id="info-pages"></span>. <span id="info-total"></span> total entries</div>
                                        <div class="dataTables_paginate paging_simple_numbers" id="site_groups_list_paginate">
                                            <a class="paginate_button previous" id="prev-link">Previous</a>
                                            <a class="paginate_button next" id="next-link">Next</a>
                                        </div>
                                    </td>
                                </tr>
                                </tfoot>
                            </table>
                        </div>
                        </div>

                    </div>
                    <!-- .postbox -->

                </div>
                <!-- .meta-box-sortables .ui-sortable -->

            </div>
            <!-- post-body-content -->


        </div>
        <!-- #post-body .metabox-holder .columns-2 -->

        <br class="clear">
    </div>
    <!-- #poststuff -->

</div> <!-- .wrap -->

<script language="JavaScript">
    (function($){
        const ajax_url = "<?php echo admin_url( 'admin-ajax.php' ); ?>";

        let current_page = 0;
        let current_start = null;
        let current_end = null;
        let total = 0;
        let pages = 0;

        function render_row(element, index, array) {
            let table_content = document.getElementById('report-content');
            table_content.innerHTML = table_content.innerHTML +
                '<tr>'
                + '<td>' + element.clicked + '</td>'
                + '<td>' + element.IP + '</td>'
                + '<td>' + element.Country + '</td>'
                + '<td>' + element.Region + '</td>'
                + '<td><a href="' + element.Origin + '" target="_blank">' + element.Origin + '</a></td>'
                + '<td>' + element.Destination + '</td>'
                + '<td>' + element.LinkText + '</td>'
                + '</tr>';

        }

        function process_data(text) {
            let data = JSON.parse(text);
            total = data['total'];
            current_page = data['page'];
            pages = data['pages'];
            document.getElementById("info-page").innerHTML = current_page+1;
            document.getElementById("info-pages").innerHTML = pages;
            document.getElementById("info-total").innerHTML = total;
            if (data['prev'] >= 0) {
                document.getElementById("prev-link").style.display = 'initial';
            }
            if (data['next'] >= 0) {
                document.getElementById("next-link").style.display = 'initial';
            }
            if (data['data']) {
                data['data'].forEach(render_row);
            } else {
                let table_content = document.getElementById('report-content');
                table_content.innerText = 'No results!';
            }
        }

        function fetch_page(page) {
            let table_content = document.getElementById('report-content');
            table_content.innerText = 'Loading ...';
            document.getElementById("prev-link").style.display = 'none';
            document.getElementById("next-link").style.display = 'none';

            let formData = new FormData();
            formData.append("action", "ftm_geo_report");
            formData.append("page", page);
            formData.append("start", current_start);
            formData.append("end", current_end);
            console.log("Start: "+current_start);
            console.log("end: "+current_end);

            let request = new XMLHttpRequest();
            request.open('POST', ajax_url, true);
            request.onreadystatechange = function() {
                if(request.readyState === 4) {
                    if(request.status === 200) {
                        table_content.innerHTML = '';
                        process_data(request.responseText);
                    } else {
                        table_content.innerHTML = 'An error occurred during your request: ' +  request.status + ' ' + request.statusText;
                    }
                }
            }
            request.send(formData);
        }

        function fetch_prev() {
            fetch_page(current_page - 1);
        }

        function fetch_next() {
            fetch_page(current_page + 1);
        }

        function init() {
            document.getElementById("prev-link").addEventListener("click", function(event){
                fetch_prev();
                event.preventDefault();
            });
            document.getElementById("next-link").addEventListener("click", function(event){
                fetch_next();
                event.preventDefault();
            });
            document.getElementById("start-date").addEventListener("change", function(event){
                current_start = event.target.value;
                current_page = 0;
                fetch_page(current_page);
            });
            document.getElementById("end-date").addEventListener("change", function(event){
                current_end = event.target.value;
                current_page = 0;
                fetch_page(current_page);
            });
            $("#start-date").datepicker({"dateFormat": "yy-mm-dd", "onSelect":function(date){
                current_start = date;
                current_page = 0;
                fetch_page(current_page);
            }});
            $("#end-date").datepicker({"dateFormat": "yy-mm-dd", "onSelect":function(date){
                current_end = date;
                current_page = 0;
                fetch_page(current_page);
            }});
            fetch_page(current_page);
        }

	document.addEventListener("DOMContentLoaded", function() {
            init();
        });
    })(jQuery);
</script>
