<?php
/** @var array $banned_configuration */

/** @var array $groupCountries */
$groupCountries = $banned_configuration['countries'];
/** @var array $groupRegions */
$groupRegions = $banned_configuration['regions'];

$affiliate_folders = explode('/', $banned_configuration['affiliate_folder']);
$affiliate_folders = array_filter($affiliate_folders, function ($folder){return strlen($folder)>0;});

$countries = [];
$regions = [];

$tmp_countries = ftm_geo_target_getCountries();
foreach($tmp_countries as $country) {
    $countries[$country->iso_3166_2] = $country;
}
$tmp_regions = ftm_geo_target_getRegions();
foreach ($tmp_regions as $region) {
    $regions[$region->regioncode.'_'.$region->countrycode] = $region;
}

?>
<div class="wrap ftm_geo_target">

    <div id="icon-options-general" class="icon32"></div>
    <h1><?php esc_attr_e( 'Geo Target Plugin', 'wp_admin_style' ); ?></h1>

    <div id="poststuff">

        <div id="post-body" class="metabox-holder columns-2">

            <!-- main content -->
            <div id="post-body-content">

                <div class="meta-box-sortables ui-sortable">

                    <div class="postbox">

                        <!-- Toggle -->

                        <h2 class="hndle"><span><?php esc_attr_e( 'Global Referral Banned Places', 'wp_admin_style' ); ?></span>
                        </h2>

                        <div class="inside">
                            <p>This functionality allows to define countries OR regions for which the referral links will be disallowed. <br />
                            Any user visiting from any of those countries or regions will not be allowed to click and go there.</p>
                            <form action="admin.php?page=ftm-geo-target-banned" method="POST">
                                <table class="form-table">
                                    <tbody>

                                    <tr>
                                        <th><label for="banned-active">Active <br/><span class="" style="font-size:80%">Is this functionality enabled at all or not</span></label></th>
                                        <td><input type="checkbox" id="banned-active" name="banned_active" <?php echo $banned_configuration['active']?'checked':'' ?>></td>
                                    </tr>
                                    <tr>
                                        <th><label for="banned-affiliate-folder">Affiliate folder <br/><span class="" style="font-size:80%">The URL part of the path of the affiliates which we need to block.</span></label></th>
                                        <td>
                                            <div class="affiliate-input">
                                                <input type="text" id="banned-affiliate-folder-input" autocomplete="off" placeholder="go">
                                                <button id="affiliate-add-button" class="affiliate-add-button btn btn-primary">Add</button>
                                            </div>
                                            <div>Enter the part of the URL that we need to check, ex.:<div class="affiliate-example"><?php echo site_url() ?>/<span class="affiliate-example-path">go</span>/coolcasino/</div></div>
                                            <div><label>Added folders</label></div>
                                            <input type="hidden" id="banned-affiliate-folder" name="banned_affiliate_folder" value="<?php echo implode('/', $affiliate_folders) ?>">
                                            <div id="affiliate_folders-container" class="affiliate_folders">
                                            </div>
                                        </td>
                                    </tr>
                                    </tbody>
                                </table>

                                <div class="postbox">
                                    <h2 class="hndle"><span><b><?php esc_attr_e( 'Countries. ', 'wp_admin_style' ); ?></b></span>Countries in which the referrals are not allowed</h2>
                                    <div class="inside">
                                        <div>
                                            Country:&nbsp;
                                            <select name="ddl_countries" id="ddl_countries" title="Countries" data-placeholder="Choose a Country..." class="chosen-select">
                                                <option value=""></option>
                                                <?php
                                                foreach ($countries as $country){
                                                    echo ("<option value='". $country->iso_3166_2 ."' data-class='flag' data-style='background-image:url(". plugins_url() ."/ftm-geo-target/flags/". $country->iso_3166_2 .".png);' >" . $country->name . "</option>");
                                                }
                                                ?>
                                            </select>
                                            <input class="btn btn-primary" onclick="add_sortable_item_list_wflag('allowed_countries',jQuery('#ddl_countries').val(),jQuery('#ddl_countries option:selected').text(),'banned_countries_list');" type="button" name="add_coutry" id="add_coutry" value="<?php esc_attr_e( 'Add', 'wp_admin_style' ); ?>">
                                        </div>
                                        <hr>
                                        <div id="allowed_countries" class="sortable_list">
                                            <?php
                                            if(count($groupCountries)) {
                                                $countries_tmp = array();
                                                $cont = 0;
                                                foreach ($groupCountries as $country_id) {
                                                    $countries_tmp[$cont] = $country_id;
                                                    $country = $countries[$country_id];
                                                    $cont++;
                                                    echo '<div class="sitem" data-text="' . $country->iso_3166_2 . '"><span><img src="'. plugins_url() .'/ftm-geo-target/flags/'. $country->iso_3166_2 .'.png" />' . $country->name . '</span><div class="btn btn-danger btn-lg" onclick="remove_sitem_output(jQuery(this),' . 'banned_countries_list' . ');"><span class="glyphicon glyphicon-trash"></span></div></div>';
                                                }
                                            }
                                            ?>
                                        </div>
                                        <input type="hidden" name="banned_countries_list" value="<?php if($groupCountries) { echo implode(',',$countries_tmp);}?>" id="banned_countries_list" />
                                    </div>
                                </div>
                                <!-- .postbox -->

                                <div class="postbox">
                                    <h2 class="hndle"><span><b><?php esc_attr_e( 'Regions. ', 'wp_admin_style' ); ?></b></span>Regions in which the referrals are not allowed</h2>
                                    <div class="inside">
                                        <div>
                                            Region:&nbsp;&nbsp;
                                            <select name="ddl_regions" id="ddl_regions" title="Regions">
                                                <?php
                                                foreach ($regions as $region){
                                                    echo ("<option value='". $region->regioncode.'_'.$region->countrycode ."' data-countrycode='". $region->countrycode ."' >" . $region->regionname . "</option>");
                                                }
                                                ?>
                                            </select>
                                            <input class="btn btn-primary" onclick="add_sortable_item_list('allowed_regions',jQuery('#ddl_regions').val(),jQuery('#ddl_regions option:selected').text(),'banned_regions_list');" type="button" name="edits" value="<?php esc_attr_e( 'Add', 'wp_admin_style' ); ?>">
                                        </div>
                                        <hr>
                                        <div id="allowed_regions" class="sortable_list">
                                            <?php
                                            if($groupRegions) {
                                                $regions_tmp = array();
                                                $cont = 0;
                                                foreach ($groupRegions as $regionpair) {
                                                    $region_pair_values = explode('_', $regionpair);
                                                    if (count($region_pair_values) === 2) {
                                                        $region = $regions[$regionpair];
                                                        $regions_tmp[$cont] = $region->regioncode.'_'.$region->countrycode;
                                                        $cont++;
                                                        echo '<div class="sitem" data-text="' . $region->regioncode.'_'.$region->countrycode . '"><span>' . $region->regionname . '</span><div class="btn btn-danger btn-lg" onclick="remove_sitem_output(jQuery(this),' . 'banned_regions_list' . ');"><span class="glyphicon glyphicon-trash"></span></div></div>';
                                                    }
                                                }
                                            }
                                            ?>
                                        </div>
                                        <input type="hidden" name="banned_regions_list" value="<?php if($groupRegions) { echo implode(',',$regions_tmp);}?>" id="banned_regions_list" />
                                    </div>
                                </div>
                                <!-- .postbox -->

                                <p class="submit">
                                    <input type="submit" name="test-button" class="btn btn-primary" value="Save">
                                </p>

                            </form>
                        </div>

                    </div>
                    <!-- .postbox -->

                </div>
                <!-- .meta-box-sortables .ui-sortable -->

            </div>
            <!-- post-body-content -->


        </div>
        <!-- #post-body .metabox-holder .columns-2 -->

        <br class="clear">
    </div>
    <!-- #poststuff -->

</div> <!-- .wrap -->
<script id="affiliate-item-template" type="application/template">
    <div class="affiliate-item"><span>{{path}}</span><button data-path="{{path}}" class="affiliate-remove-button btn btn-danger btn-xs">X</button></div>
</script>
