<?php

GLOBAL $wpdb;
$status = "";
$message = "";
$sucess_alert = '<div class="alert alert-success alert-dismissible show" role="alert">{MESSAGE}<button type="button" class="close" data-bs-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button></div>';
$error_alert = '<div class="alert alert-danger alert-dismissible show" role="alert">{MESSAGE}<button type="button" class="close" data-bs-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button></div>';

$active_themes = null;
$inactive_themes = null;
$theme_folder = WP_PLUGIN_DIR . '/ftm-geo-target/themes/';
// Theme folder in the current theme folder
$folder_in_template = "/geo-target-themes/";
$folder_in_cta_template = "/geo-cta-themes/";

//UPDATE THEMES
if(isset($_POST["install_theme_btn"])){
    $install_theme_name = $_POST["install_theme_btn"];

    if(ftm_geo_target_install_theme($install_theme_name)){
        $status = true;
        $message = "The theme ". $install_theme_name . " was installed successfully";
    }
    else
    {
        $status = false;
        $message = "There was a problem installing the theme ". $install_theme_name . ", contact support.";
    }
}

if(isset($_POST["action"])){
    if(isset($_POST["theme_id"])){
        $themeID = $_POST["theme_id"];
    }
    else
    {
        $themeID = 0;
    }

    if($_POST["action"] == "activate" && $themeID > 0){
        if(ftm_geo_target_activate_theme($themeID)){
            $status = true;
            $message = "The theme was activated successfully";
        }
        else
        {
            $status = false;
            $message = "There was a problem activating the theme";
        }
    }

    if($_POST["action"] == "deactivate" && $themeID > 0){
        if(ftm_geo_target_deactivate_theme($themeID)){
            $status = true;
            $message = "The theme was deactivated successfully";
        }
        else
        {
            $status = false;
            $message = "There was a problem deactivating the theme";
        }
    }
}

//GENERAL LOAD
$active_themes = ftm_geo_target_themes(true, 'all');
$inactive_themes = ftm_geo_target_themes(false, 'all');

$template_path = get_template_directory();
$in_template_themes = $template_path . $folder_in_template;
$in_template_cta_themes = $template_path . $folder_in_cta_template;

$uninstalled_themes = array();
ftm_geo_target_get_uninstalled_themes($uninstalled_themes, $in_template_themes, $active_themes, $inactive_themes);
ftm_geo_target_get_uninstalled_themes($uninstalled_themes, $in_template_cta_themes, $active_themes, $inactive_themes, 'cta');

ftm_geo_target_get_uninstalled_themes($uninstalled_themes, $theme_folder, $active_themes, $inactive_themes);

function ftm_geo_target_get_uninstalled_themes(&$uninstalled_themes, $path, $active_themes, $inactive_themes, $type = 'target') {
    $dir_themes = glob($path . '*' , GLOB_ONLYDIR);
    foreach ($dir_themes as $dtheme){
        $is_installed = false;
        $theme_name = str_replace($path,"", $dtheme);

        foreach ($active_themes as $at){
            if(strtolower($theme_name) === strtolower($at->ThemeName)){
                $is_installed = true;
            }
        }

        foreach ($inactive_themes as $it){
            if(strtolower($theme_name) === strtolower($it->ThemeName)){
                $is_installed = true;
            }
        }

        if(!$is_installed && !in_array($theme_name, $uninstalled_themes)) {
            $uninstalled_themes[] = [
                'name' => $theme_name,
                'type' => $type,
            ];
        }
    }
}

if($status !== "") {
    if ($status === true) {
        echo str_replace("{MESSAGE}", $message, $sucess_alert);
    } elseif ($status === false) {
        echo str_replace("{MESSAGE}", $message, $error_alert);
    }
}
?>
<div class="modal fade" id="delete_modal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title" id="myModalLabel">Deactivate Theme Confirmation</h4>
            </div>
            <div class="modal-body">
                <form id="deactivate_theme_form" name="deactivate_theme_form" action="<?php echo FTM_WP_INSTALL_PREFIX; ?>/wp-admin/admin.php?page=ftm-geo-target-themes"  method="post">
                    <fieldset>
                        <div class="form-group">
                            <h4>Are you sure you want to deactivate this theme?</h4>
                        </div>
                        <br>
                        <div class="form-group">
                            <p>By deactivating this theme, you will hide it from new groups but, the groups that still have it will still use it until they get another theme assigned (we don't wanna break the site right?). So keep that in mind when deactivating a theme.</p>
                        </div>
                        <!-- Allow form submission with keyboard without duplicating the dialog button -->
                        <input type="hidden" name="theme_id" id="theme_id">
                        <input type="hidden" name="action" value="deactivate" />
                        <input type="submit" id="diag_form_submit" tabindex="-1" style="position:absolute; top:-1000px">
                    </fieldset>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-bs-dismiss="modal">Close</button>
                <button type="submit" form="deactivate_theme_form" class="btn btn-primary">Deactivate Theme</button>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="activate_modal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title" id="myModalLabel">Activate Theme Confirmation</h4>
            </div>
            <div class="modal-body">
                <form id="activate_theme_form" name="activate_theme_form" action="<?php echo FTM_WP_INSTALL_PREFIX; ?>/wp-admin/admin.php?page=ftm-geo-target-themes"  method="post">
                    <fieldset>
                        <div class="form-group">
                            <h4>Are you sure you want to activate this theme?</h4>
                        </div>
                        <!-- Allow form submission with keyboard without duplicating the dialog button -->
                        <input type="hidden" name="theme_id" id="theme_id">
                        <input type="hidden" name="action" value="activate" />
                        <input type="submit" id="diag_form_submit" tabindex="-1" style="position:absolute; top:-1000px">
                    </fieldset>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-bs-dismiss="modal">Close</button>
                <button type="submit" form="activate_theme_form" class="btn btn-primary">Sure activate theme</button>
            </div>
        </div>
    </div>
</div>


<div class="wrap ftm_geo_target">
    <div id="icon-options-general" class="icon32"></div>
    <h1><?php esc_attr_e( 'FTM Geo Target Plugin Settings', 'wp_admin_style' ); ?></h1>
    <p><i><?php esc_attr_e('Here you can enable the debug setting and update the Geo Location File.', 'wp_admin_style'); ?></i></p>
    <div id="poststuff">
        <div id="post-body" class="metabox-holder columns-2">
            <!-- main content -->
            <div id="post-body-content">
                <form id="update_themes_form" name="update_settings_form" action="" method="post">
                    <div class="postbox">
                        <h2 class="hndle"><b><?php esc_attr_e('Active Themes', 'wp_admin_style'); ?></b></h2>
                        <div class="inside">
                            <div>
                                <div class="sites_list">
                                    <div class="sites_heading">
                                        <div>Theme Name</div>
                                        <div>Theme Type</div>
                                        <div>Actions</div>
                                    </div>
                                    <?php
                                    if(sizeof($active_themes) > 0) {
                                        foreach ($active_themes as $theme) {
                                            ?>
                                            <div class="site_entry">
                                                <div><?php echo $theme->ThemeName; ?></div>
                                                <div><?php echo ucfirst($theme->type==='target'?'site group':$theme->type); ?></div>
                                                <div class="site_actions">
                                                    <button class="btn btn-warning" data-toggle="modal" <?php if($theme->ThemeName == "Default"){echo "disabled" ;}?> data-target="#delete_modal"
                                                            onclick="fill_confirm_popup_key_value('deactivate_theme_form','theme_id','<?php echo($theme->ThemeId);?>'); return false"
                                                            name="deactivate_theme_btn" value="deactivate" type="submit">Deactivate</button>
                                                </div>
                                            </div>
                                            <?php
                                        }
                                    }
                                    else
                                    {?>
                                        <div class="empty_list">-- No active themes right now --</div>
                                    <?php
                                    }
                                    ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>

                <form id="activate_themes_form_blank" name="activate_themes_form" action="" method="post">
                    <div class="postbox">
                        <h2 class="hndle"><b><?php esc_attr_e('Inactive Themes', 'wp_admin_style'); ?></b></h2>
                        <div class="inside">
                            <div>
                                <div class="sites_list">
                                    <div class="sites_heading">
                                        <div>Theme Name</div>
                                        <div>Theme Type</div>
                                        <div>Actions</div>
                                    </div>
                                    <?php
                                    if(sizeof($inactive_themes) > 0) {
                                        foreach ($inactive_themes as $itheme) {
                                            ?>
                                            <div class="site_entry">
                                                <div><?php echo $itheme->ThemeName; ?></div>
                                                <div><?php echo ucfirst($itheme->type==='target'?'site group':$itheme->type); ?></div>
                                                <div class="site_actions">
                                                    <button class="btn btn-success" data-bs-toggle="modal" data-bs-target="#activate_modal"
                                                            onclick="fill_confirm_popup_key_value('activate_theme_form','theme_id','<?php echo($itheme->ThemeId);?>'); return false;"
                                                            name="activate_theme_btn" value="activate" type="submit">Activate</button>
                                                </div>
                                            </div>
                                            <?php
                                        }
                                    }
                                    else
                                    {?>
                                        <div class="empty_list">-- No inactive themes right now --</div>
                                    <?php
                                    }
                                    ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>


                <form id="install_themes_form" name="install_themes_form" action="" method="post">
                    <div class="postbox">
                        <h2 class="hndle"><b><?php esc_attr_e('New Themes', 'wp_admin_style'); ?></b></h2>
                        <div class="inside">
                            <div>
                                <div class="sites_list">
                                    <div class="sites_heading">
                                        <div>Theme Name</div>
                                        <div>Theme Type</div>
                                        <div>Actions</div>
                                    </div>
                                    <?php
                                    if(sizeof($uninstalled_themes) > 0) {
                                        foreach ($uninstalled_themes as $theme_info) {
                                            ?>
                                            <div class="site_entry">
                                                <div><?php echo $theme_info['name']; ?></div>
                                                <div><?php echo ucfirst($theme_info['type']==='target'?'site group':$theme_info['type']); ?></div>
                                                <div class="site_actions">
                                                    <button class="btn btn-success" name="install_theme_btn" value="<?php echo $theme_info['name'];?>" type="submit">Install</button>
                                                </div>
                                            </div>
                                            <?php
                                        }
                                    }
                                    else
                                    {?>
                                        <div class="empty_list">-- No uninstalled themes right now --</div>
                                        <?php
                                    }
                                    ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>

                <!-- .meta-box-sortables .ui-sortable -->
            </div>
            <!-- post-body-content -->
            <!-- sidebar -->
            <?php
            //GLOBAL $ftm_geo_target_plugin_path;
            //require_once $ftm_geo_target_plugin_path . '/includes/sidebar-themes.php';
            ?>
            <!-- sidebar -->
            <!-- #postbox-container-1 .postbox-container -->
        </div>
        <!-- #post-body .metabox-holder .columns-2 -->
        <br class="clear">
    </div>
    <!-- #poststuff -->
</div> <!-- .wrap -->
