<?php
$nginx_parameters = $_SERVER["COUNTRY_CODE"] || $_SERVER["CITY_CODE"];
?>
<div class="wrap">

    <div id="icon-options-general" class="icon32"></div>
    <h1><?php esc_attr_e( 'Geo Target Plugin', 'wp_admin_style' ); ?></h1>

    <div id="poststuff">

        <div id="post-body" class="metabox-holder columns-2">

            <!-- main content -->
            <div id="post-body-content">

                <div class="meta-box-sortables ui-sortable">

                    <div class="postbox">

                        <!-- Toggle -->

                        <h2 class="hndle"><span><?php esc_attr_e( 'Geo Target Plugin', 'wp_admin_style' ); ?></span>
                        </h2>

                        <div class="inside">
                            <p><?php esc_attr_e( 'The plugin let you gruoup sites by sets of geo targeting rules that need to match in order to display the sites list for that particular group.', 'wp_admin_style' ); ?></p>
                            <p>
                                <b>Current Groups count: </b>
                                <?php
                                $gc = ftm_geo_target_currentGroups();
                                echo "<span>". sizeof($gc) ."</span>"
                                ?>
                            </p>
                        </div>
                        <hr/>

                        <div class="handlediv" title="Click to toggle"><br></div>
                        <h2 class="hndle"><span><?php esc_attr_e( 'Tester', 'wp_admin_style' ); ?></span>
                        </h2>
                        <div class="inside">
                            <p>If you want to verify a configuration, enter the list of groups (same as you entered in the shortcode parameter) and an IP address. The tester will tell what group would be selected.</p>
                            <form action="admin.php?page=ftm-geo-target" method="POST">
                                <table class="form-table">
                                    <tbody>

                                    <?php if($nginx_parameters): ?>
                                    <tr>
                                        <th><label>Nginx Country Parameter</label></th>
                                        <td><?php echo $_SERVER['COUNTRY_CODE'] ?></td>
                                    </tr>
                                    <tr>
                                        <th><label>Nginx Region Parameter</label></th>
                                        <td><?php echo $_SERVER['CITY_CODE'] ?></td>
                                    </tr>
                                    <?php endif; ?>
                                    <tr>
                                        <th><label for="test-groups">Groups <br/><span class="" style="font-size:80%">(the "g" parameter in the shortcode)</span></label></th>
                                        <td><input type="textfield" id="test-groups" name="test_groups" value="<?php echo $test_groups ?>" autocomplete="off"></td>
                                    </tr>
                                    <tr>
                                        <th><label for="test-ip">IP</label></th>
                                        <td><input type="textfield" id="test-ip" name="test_ip" value="<?php echo $test_ip ?>" autocomplete="off"></td>
                                    </tr>
                                    <?php if (isset($_POST)): ?>
                                      <?php if ($selected_group): ?>
                                         <tr>
                                             <th>IP Country</th>
                                             <td><?php echo $country ?></td>
                                         </tr>
                                         <tr>
                                             <th>IP Region</th>
                                             <td><?php echo $region ?></td>
                                         </tr>
                                         <tr>
                                             <th>Matched Group</th>
                                             <td><?php echo $selected_group->GroupName ?>: <?php echo $selected_group->GroupDescription ?></td>
                                         </tr>
                                      <?php else: ?>
                                         <tr>
                                            <td colspan="2"><?php _e('None group matched!') ?></td>
                                         </tr>
                                      <?php endif; ?>
                                    <?php endif; ?>
                                    </tbody>
                                </table>
                                <p class="submit">
                                    <input type="submit" name="test-button" class="btn btn-primary" value="Test">
                                </p>

                            </form>
                        </div>

                        <hr/>

                        <div class="handlediv" title="Click to toggle"><br></div>
                        <h2 class="hndle"><span><?php esc_attr_e( 'Translating', 'wp_admin_style' ); ?></span>
                        </h2>
                        <div class="inside">
                            <p>For guide translating content check this <a href="/wp-content/plugins/ftm-geo-target/docs/translating-ftm-geo-target.pdf" target="_blank">document</a></p>
                            <p>The Geo Target Plugin integrates with WPML for translation of content.</p>
                            <br />
                            <h3>Translation of texts in the templates</h3>
                            <p>If in the HTML templates the pattern “<code>{{some text}}</code>” is used, then “some text” will be translatable using the standard WordPress translation using the context “Site Template”.</p>
                            <p>Example:</p>
<code style="display: block;   white-space: pre-wrap">
&lt;div class="main_ranking_table"&gt;
    [SITES-REPEATER]
        &lt;div class="item flex-between-wrap" &gt;
           &lt;div class="games"&gt;
               <b style="color:#FF0000">{{Text to translate}}</b>
           &lt;/div&gt;
       &lt;/div&gt;
    [/SITES-REPEATER]
&lt;/div&gt;
</code>
                            <p>In this scenario the brackets will be removed and the text translated if there is any translation to apply.</p>
                            <p>Any translatable text in the template can also be customized for each group in the <b>"Customize Labels"</b> button of each site group.</p>
                            <br />
                            <h3>Translating fields content</h3>
                            <p>The fields are also translatable in WPML strings translation option.</p>
                            <p>The domain is a construction of “<code>site-fields-site_</code>” and the <code>site ID</code>, with a name indicating the field name.</p>
                            <br />
                            <h3>Translating common text inside field content</h3>
                            <p>In some cases, you may encounter the need to translate a text over and over in many fields, for these cases you can use a “common translation” text and only translating them once.</p>
                            <p>To do that just include your text between square brackets “<code>[[Common translatable text]]</code>”</p>
                            <p>Example:</p>
                            <p>Having a field for promotions where what changes on every promotion is the price, you could use the common translatable and only translate it once.</p>
<code style="display: block;   white-space: pre-wrap">
[[Sign up and get a bonus of]] $100
</code>
                        </div>
                        <hr/>


                        <h2 class="hndle"><span><?php esc_attr_e( 'How it works?', 'wp_admin_style' ); ?></span>
                        </h2>
                        <div class="inside">
                            <p><b>Step 1:</b> Create or configure the Site Option Fields, those are the fields required for a site creation. Those fields will be dynamically displayed on the website by the selected theme.</p>
                            <p><b>Step 2:</b> Create or configure a site, the site will be the one item you want to show on a list in the first place, set the name, active status and fill the option fields you configured on step 1.</p>
                            <p><b>Step 3:</b> Create or configure a group. This step is the one that sparkled the need for this plugin. A group will contain the geo location rules to follow in order to display the content.</p>
                            <p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; Select the theme, the theme is the way the information will be displayed on the page you add the custom short code created for each group.</p>
                            <p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; Once you added the group name, description, geo rules and theme, add sites to the group, so when the go criteria is a match, it will display every site and it's data by the order every site was added.</p>
                        </div>
                        <hr/>
                        <h2 class="hndle"><span><?php esc_attr_e( 'Anything else?', 'wp_admin_style' ); ?></span>
                        </h2>
                        <div class="inside">
                            <p>Contact Miller Marketing's support team if further information or assistance is needed.</p>
                        </div>
                        <!-- .inside -->

                    </div>
                    <!-- .postbox -->

                </div>
                <!-- .meta-box-sortables .ui-sortable -->

            </div>
            <!-- post-body-content -->

            <!-- sidebar -->
	        <?php
	        GLOBAL $ftm_geo_target_plugin_path;
	        require_once $ftm_geo_target_plugin_path . '/includes/sidebar-sites.php'
	        ?>
            <!-- sidebar -->
            <!-- #postbox-container-1 .postbox-container -->

        </div>
        <!-- #post-body .metabox-holder .columns-2 -->

        <br class="clear">
    </div>
    <!-- #poststuff -->

</div> <!-- .wrap -->
