/**
 * Local Tiny Plugin  TinyMCE plugin
 */


(function(){
    tinymce.create("tinymce.plugins.add_ftm_geo_target_sc", {
        init: function(editor, url) {
            editor.addButton("add_ftm_geo_table", {
                title: "Add FTM Geo Table",
                icon: "icon ltp-mce-icon dashicons-list-view",
                onclick: function(){
                    // Open window
                    var data = {
                        'action': 'get_ftm_gruops_list',
                        'gfilter': 'all'
                    };
                    //Set the array that will be used for the list of the groups on a dropdown
                    var ddl_groups_items = [];

                    // since 2.8 ajaxurl is always defined in the admin header and points to admin-ajax.php
                    jQuery.post(ajaxurl, data, function(response) {

                        var json_translation = JSON.parse(response);

                        var count = 0;
                        jQuery.each(json_translation, function() {
                            if(count == 0){
                                ddl_groups_items.push({text: this.GroupName, value: this.GroupName.replace(/ /g, "-"), selected: true});
                            }
                            else {
                                ddl_groups_items.push({text: this.GroupName, value: this.GroupName.replace(/ /g, "-")});
                            }
                            count++;
                        });
                    });


                    editor.windowManager.open({
                        title: "Add FTM Geo Table",
                        bodyType: "tabpanel",
                        width: 410,
                        height:100,
                        buttons: [{
                            text: 'Insert',
                            classes: 'widget btn primary first abs-layout-item',
                            onclick: 'submit',
                            id: 'insertButton'
                        }, {
                            text: 'Close',
                            onclick: 'close'
                        }],
                        body: [{
                            title: "FTM Group Selection",
                            type: "form",
                            items: [
                                {
                                    type   : 'listbox',
                                    name   : 'ddl_group',
                                    label  : 'Select a FTMGT Group: ',
                                    autofocus : true,
                                    values : ddl_groups_items,
                                    minWidth: 200
                                }
                            ],
                        },
                            {
                                title: "About",
                                type: "panel",
                                items: [
                                    {type: "panel",html:"<h4 style='font-size:24px;font-weight:600;'>FTM Geo Target Plugin  v1.0</h4><p style='font-size:18px;'>Created by <a style='font-size:18px;cursor:pointer;font-weight:600;' href='#'>Miller Marketing</a></p><p><a style='cursor:pointer;font-weight:600;' href='#'>GNU Licence</a></p>"},
                                ]
                            }],
                        onsubmit: function(e) {
                            editor.focus();
                            // Insert content when the window form is submitted
                            if(e.data.ddl_group !== "") {
                                var shortcode = '[ftm_gt g="';
                                shortcode += e.data.ddl_group;
                                shortcode += '" ]';
                                editor.insertContent(shortcode);
                            }
                        }
                    });
                }
            });
        },

        createControl: function(n, cm) {
            return null;
        },

        /**
         * Returns information about the plugin as a name/value array.
         * The current keys are longname, author, authorurl, infourl and version.
         *
         * @return {Object} Name/value array containing information about the plugin.
         */
        getInfo: function() {
            return {
                longname: "Local Tiny Plugin ",
                author: "Rodrigo Ocampo",
                authorurl: "http://wwww.www.www",
                infourl: "http://wwww.www.www",
                version: "1.0"
            };
        }
    });
    // Register plugin
    tinymce.PluginManager.add("add_ftm_geo_target_sc", tinymce.plugins.add_ftm_geo_target_sc);
})();
