<?php

GLOBAL $wpdb;
$ftm_geo_target_plugin_url     = WP_PLUGIN_URL . '/ftm-geo-target';
$ftm_geo_target_plugin_path    = WP_PLUGIN_DIR . '/ftm-geo-target';

if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
    exit;
}

// Uninstallation actions here
$plugin_tables_prefix = "ftm_geo_target_";
$uninstall_sql_data_query = read_sql_file('uninstall.sql');
if(strpos($uninstall_sql_data_query,'Error') === false) {
    $uninstall_sql_data_query = str_replace($plugin_tables_prefix, $wpdb->prefix . $plugin_tables_prefix, $uninstall_sql_data_query);
    my_theme_drop_table($uninstall_sql_data_query); //All good, run the sql statements in the file
    remove_role('ftm_geo_admin');
}
else{
    die($uninstall_sql_data_query);
}


function read_sql_file($filename){
    try {
        $main_sql_data_file = __DIR__ . '/sql_files/' . $filename;
        $sql_file = fopen($main_sql_data_file, "r");
        $main_sql_data_query = fread($sql_file, filesize($main_sql_data_file));
        fclose($sql_file);

        return $main_sql_data_query;
    }
    catch (Exception $e){
        return ("Error: " . $e->getMessage());
    }
}

function my_theme_drop_table ($query_statement){
    global $wpdb;

    $wpdb->query( $query_statement );
}
?>