<?php

GLOBAL $wpdb;

$types = ftm_geo_target_getFieldTypes();
$status = "";

$sucess_alert = '<div class="alert alert-success alert-dismissible show" role="alert">{MESSAGE}<button type="button" class="close" data-bs-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button></div>';
$sucess_delete_alert = '<div class="alert alert-warning alert-dismissible show" role="alert">{MESSAGE}<button type="button" class="close" data-bs-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button></div>';
$error_alert = '<div class="alert alert-danger alert-dismissible show" role="alert">{MESSAGE}<button type="button" class="close" data-bs-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button></div>';

//UPDATE AN OPTION FIELD
if( isset($_POST["uname"])){
    $field_name = $_POST["uname"];
    $field_id = $_POST["optionId"];
    $field_typeid = $_POST["ftmgeo_update_ftype"];

    if(ftm_geo_target_updateSiteOptionField($field_id, $field_name, $field_typeid))
    {
        $status = str_replace("{MESSAGE}", "<strong>Cool!</strong> The Field has been updated.", $sucess_alert);
    }
    else
    {
        $status = str_replace("{MESSAGE}", "<strong>Oops!</strong> The field wasn't updated please contact support.", $error_alert);
    }
}

//ADD A NEW OPTION FIELD
if ( isset($_POST["ftmgeo_add"]) ){

    $insert = $wpdb->insert(FTM_GEO_TARGET_SITE_OPTIONS_TBL,
        array(
            'fieldtypeid'           => ($_POST["ftmgeo_ftype"]),
            'fieldname'             => $_POST["ftmgeo_fname"]
        ),
        array(
            '%s',
            '%s'
        )
    );

    if($wpdb->insert_id != false){
        $status = str_replace("{MESSAGE}","<strong>Cool!</strong> The Field has been added to the Wizard.", $sucess_alert);
    }else{
        $status = str_replace("{MESSAGE}","<strong>Oops!</strong> The field wasn't added please contact support.", $error_alert);
    }

}

//DELETE AN OPTION FIELD AND IT's VALUES
if(isset($_POST["of_delete_id"])){
    $field_delete_id = $_POST["of_delete_id"];

    ftm_geo_target_deleteOptionFieldValues($field_delete_id);

    if(ftm_geo_target_deleteOptionField($field_delete_id)){
        $status = str_replace("{MESSAGE}","<strong>Done!</strong> The Field has been deleted successfully.", $sucess_delete_alert);
    }
    else
    {
        $status = str_replace("{MESSAGE}","<strong>Oops!</strong> The field wasn't deleted, please contact support.", $error_alert);
    }
}

?>

<div class="modal fade" id="delete_modal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title" id="myModalLabel">Delete Confirmation</h4>
            </div>
            <div class="modal-body">
                <form id="delete_field_form" name="delete_field_form" action="<?php echo FTM_WP_INSTALL_PREFIX; ?>/wp-admin/admin.php?page=ftm-geo-target-site-fields"  method="post">
                    <fieldset>
                        <div class="form-group">
                            <h4>Are you sure you want to delete this option field?</h4>
                        </div>
                        <br>
                        <div class="form-group">
                            <p><strong>CAREFUL!!</strong> By deleting this option field, you will also delete <b>EVERY SINGLE VALUE</b> added for <b>EVERY SINGLE SITE</b> already added for this plugin. Oh... and BTW, we might not be able to recover all that hard work... so make sure you are 100% positive you want to delete it.</p>
                        </div>
                        <!-- Allow form submission with keyboard without duplicating the dialog button -->
                        <input type="hidden" name="of_delete_id" id="of_delete_id">
                        <input type="submit" id="diag_form_submit" tabindex="-1" style="position:absolute; top:-1000px">
                    </fieldset>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-bs-dismiss="modal">Close</button>
                <button type="submit" form="delete_field_form" class="btn btn-primary">Delete Option Field</button>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="myModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title" id="myModalLabel">Modal</h4>
            </div>
            <div class="modal-body">
                <form id="update_option_form" name="update_option_form" action="<?php echo FTM_WP_INSTALL_PREFIX; ?>/wp-admin/admin.php?page=ftm-geo-target-site-fields"  method="post">
                    <fieldset>
                        <div class="form-group">
                            <label for="name">Name: </label>
                            <input type="text" name="uname" id="uname" value="" class="text ui-widget-content ui-corner-all">
                        </div>
                        <br>
                        <div class="form-group">
                            <label for="name">Type:&nbsp;&nbsp;</label>
                            <select name="ftmgeo_update_ftype" id="ftmgeo_update_ftype" style="width: 180px;" class="ui-corner-all">
                                <?php
                                foreach ($types as $type){
                                    ?>
                                    <option value="<?php print $type->typeid ?>"><?php print $type->typename; ?></option>
                                    <?php
                                }
                                ?>
                            </select>
                        </div>
                        <!-- Allow form submission with keyboard without duplicating the dialog button -->
                        <input type="hidden" name="optionId" id="optionId">
                        <input type="submit" id="diag_form_submit" tabindex="-1" style="position:absolute; top:-1000px">
                    </fieldset>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-bs-dismiss="modal">Close</button>
                <button type="submit" form="update_option_form" class="btn btn-primary">Update Field</button>
            </div>
        </div>
    </div>
</div>

<script type="text/javascript">
    jQuery(document).ready(function($) {

        $("#update_option_form").validate({
            debug: true,
            rules: {
                uname: {
                    required: true
                }
            },
            submitHandler: function (form) {
                console.log("Submitted!");
                form.submit();
            }
        });

    });
</script>

<?php if($status !== ""){
    echo $status;
}
?>
<div class="wrap ftm_geo_target">
    <div id="icon-options-general" class="icon32"></div>
    <h1><?php esc_attr_e( 'Geo-Target Site Option Fields', 'wp_admin_style' ); ?></h1>
    <div id="poststuff">
        <div id="post-body" class="metabox-holder columns-2">
            <!-- main content -->
            <div id="post-body-content">
                <div class="postbox">
                    <h2 class="hndle"><span><?php esc_attr_e( 'Current Fields', 'wp_admin_style' ); ?></span></h2>
                    <div class="inside">
                        <p><?php esc_attr_e('The following are the current fields users will have to fill whenever they add a new site.', 'wp_admin_style'); ?></p>
                    </div>
                    <hr/>
                    <?php
                    $current = ftm_geo_target_getCurrentFields();
                    ?>
                    <form action="" method="post">
                        <input type="text" placeholder="Field Name" name="ftmgeo_fname" />
                        <select name="ftmgeo_ftype">
                            <?php
                            foreach ($types as $type){
                                ?>
                                <option value="<?php print $type->typeid ?>"><?php print $type->typename; ?></option>
                                <?php
                            }
                            ?>
                        </select>
                        <input type="submit" name="ftmgeo_add" class="btn btn-primary" value="Add">
                    </form>
                    <hr>

                    <div class="sites_list">
                        <div class="sites_heading">
                            <div>Field Name</div>
                            <div>Field Type</div>
                            <div>Actions</div>
                        </div>
                        <?php
                        $sites = ftm_geo_target_currentSites();
                        foreach ($current as $field){?>
                            <div class="site_entry">
                                <div><?php echo $field->fieldname; ?></div>
                                <div><?php echo $field->typename; ?></div>
                                <div class="site_actions">
                                    <button class="btn btn-warning"  data-bs-toggle="modal" data-bs-target="#myModal"  onclick="show_update_field_popup(<?php echo($field->optionid);?>,'<?php echo($field->fieldname);?>','<?php echo($field->fieldtypeid);?>');" name="edits" type="submit">Edit</button> |
                                    <button class="btn btn-danger"  data-bs-toggle="modal" data-bs-target="#delete_modal"  onclick="fill_confirm_popup_key_value('delete_field_form','of_delete_id','<?php echo($field->optionid);?>');" name="delete_group" type="submit">Delete</button>
                                </div>
                            </div>
                            <?php
                        }
                        ?>
                    </div>

                </div>
                <!-- .meta-box-sortables .ui-sortable -->
            </div>
            <!-- post-body-content -->
            <!-- sidebar -->
            <?php
            //require_once $plugin_path . '/includes/sidebar.php'
            ?>
            <!-- sidebar -->
            <!-- #postbox-container-1 .postbox-container -->
        </div>
        <!-- #post-body .metabox-holder .columns-2 -->
        <br class="clear">
    </div>
    <!-- #poststuff -->
</div> <!-- .wrap -->
