<?php

$groups  = ftm_geo_target_currentGroups();

?>
<div id="postbox-container-1" class="postbox-container">

    <div class="meta-box-sortables">

        <div class="postbox">

            <div class="handlediv" title="Click to toggle"><br></div>
            <!-- Toggle -->

            <h2 class="hndle"><span><?php esc_attr_e(
                        'Add Group', 'wp_admin_style'
                    ); ?></span></h2>

            <div class="inside">
                <form name="ftm_geo_target_site_add" method="post" action="<?php echo FTM_WP_INSTALL_PREFIX; ?>/wp-admin/admin.php?page=ftm-geo-target-group-add">
                    <p><?php esc_attr_e( 'Click the button below to add a new group' ); ?></p>
                    <input class="btn btn-primary" type="submit" name="adds" value="<?php esc_attr_e( 'Add a new group' ); ?>" />
                </form>
            </div>
            <!-- .inside -->

        </div>
        <!-- .postbox -->

        <?php if(sizeof($groups) > 0){ ?>
        <div class="postbox">
            <div class="handlediv" title="Click to toggle"><br></div>
            <!-- Toggle -->

            <h2 class="hndle"><span><?php esc_attr_e(
                        'Edit Group', 'wp_admin_style'
                    ); ?></span></h2>

            <div class="inside">
                <p><?php esc_attr_e( 'Please choose a group to edit', 'wp_admin_style' ); ?></p>
                <form method="post" action="<?php echo FTM_WP_INSTALL_PREFIX; ?>/wp-admin/admin.php?page=ftm-geo-target-group-edit">
                    <select name="gedit">
                        <?php
                        if(!empty($groups)) {
                            foreach ($groups as $group) {
                                ?>
                                <option value="<?php print $group->GroupId; ?>"><?php print stripcslashes($group->GroupName); ?></option>
                                <?php
                            }
                        }
                        ?>
                    </select>
                    <input class="btn btn-primary" type="submit" name="edits" value="<?php esc_attr_e( 'Edit' ); ?>" />
                </form>
            </div>
            <!-- .inside -->

        </div>
        <!-- .postbox -->

        <?php } ?>

    </div>
    <!-- .meta-box-sortables -->

</div>
