<div class="wrap ftm_geo_target">
    <div id="icon-options-general" class="icon32"></div>
    <h1><?php esc_attr_e( 'FTM Geo Target User Manual', 'wp_admin_style' ); ?></h1>
    <p><i><?php esc_attr_e('Here you can find a step by step guide of how to use this plugin.', 'wp_admin_style'); ?></i></p>
    <div id="poststuff">
        <div id="post-body" class="metabox-holder columns-2">
            <!-- main content -->
            <div id="post-body-content">
                <div class="postbox">
                    <h2 id="top" class="hndle"><b><?php esc_attr_e('Topics Index', 'wp_admin_style'); ?></b></h2>
                    <div class="inside">
                        <div style="max-width: 500px;">
                            <ul class="list-group">
                                <li class="list-group-item list-group-item-primary"><strong>Site Option Fields</strong></li>
                                <li class="list-group-item list-group-item-primary"> - <a href="#of_what_is">What is this?</a></li>
                                <li class="list-group-item list-group-item-primary"> - <a href="#of_how_to_add">How to add an option field?</a></li>
                                <li class="list-group-item list-group-item-primary"> - <a href="#of_how_to_edit">How to edit an option field?</a></li>
                                <li class="list-group-item list-group-item-primary"> - <a href="#of_how_to_delete">How to delete an option field?</a></li>
                            </ul>
                            <ul class="list-group">
                                <li class="list-group-item list-group-item-primary"><strong>Sites</strong></li>
                                <li class="list-group-item list-group-item-primary"> - <a href="#s_what_is">What is this?</a></li>
                                <li class="list-group-item list-group-item-primary"> - <a href="#s_how_to_add">How to add a site?</a></li>
                                <li class="list-group-item list-group-item-primary"> - <a href="#s_how_to_edit">How to edit a site?</a></li>
                                <li class="list-group-item list-group-item-primary"> - <a href="#s_how_to_delete">How to delete a site?</a></li>
                            </ul>
                            <ul class="list-group">
                                <li class="list-group-item list-group-item-primary"><strong>Site Groups</strong></li>
                                <li class="list-group-item list-group-item-primary"> - <a href="#sg_what_is">What is this?</a></li>
                                <li class="list-group-item list-group-item-primary"> - <a href="#sg_how_to_add">How to add a group?</a></li>
                                <li class="list-group-item list-group-item-primary"> - <a href="#sg_how_to_edit">How to edit a group?</a></li>
                                <li class="list-group-item list-group-item-primary"> - <a href="#sg_how_to_delete">How to delete a group?</a></li>
                            </ul>
                            <ul class="list-group">
                                <li class="list-group-item list-group-item-primary"><strong>Themes</strong></li>
                                <li class="list-group-item list-group-item-primary"> - <a href="#t_what_is">What is a theme?</a></li>
                                <li class="list-group-item list-group-item-primary"> - <a href="#t_how_to_install">How to install a theme?</a></li>
                                <li class="list-group-item list-group-item-primary"> - <a href="#t_how_to_activate">How to activate a theme?</a></li>
                                <li class="list-group-item list-group-item-primary"> - <a href="#t_how_to_deactivate">How to deactivate a theme?</a></li>
                                <li class="list-group-item list-group-item-primary"> - <a href="#t_how_to_delete">Why i can't delete a theme?</a></li>
                            </ul>
                            <ul class="list-group">
                                <li class="list-group-item list-group-item-primary"><strong>Settings</strong></li>
                                <li class="list-group-item list-group-item-primary"> - <a href="#t_what_settings">Settings available and utilities?</a></li>
                            </ul>
                        </div>
                    </div>
                </div>

                <div class="postbox">
                    <h2 class="hndle"><b><?php esc_attr_e('Site Option Fields', 'wp_admin_style'); ?></b></h2>
                    <div class="inside">
                        <div>
                            <h3 id="of_what_is">What is this?</h3>
                            <a href="#top">Top</a><br><br>
                            <div>
                                <p>Site option fields, are the fields you will need to enter information about every site you want to add to the plugin. Ii can be the logo, or a screenshot, a list of features, perhaps a simple text. You can set values that will show up depending of the county you are
                                seeing the content from.</p>
                                <p>Every field will need two values: 1- The field name (that will be used when displaying in on the theme template) and 2- The field type.</p>
                                <br>
                                <p>Right now we have four types:
                                    <ol>
                                        <li>Textbox = simple text</li>
                                        <li>Picture = chose an image from the WP image manager or upload a new one. This field will be used to display any image you want to display on the theme.</li>
                                        <li>WYSIWYG = This is the HTML editor you use on every page on the WP content management, it will work to add advanced HTML content into the theme.</li>
                                        <li>GeoValue = This is a simple text field you can display depending on the country it's loaded from. It can have multiple countries per field. Example: The bonus currency symbol: $ on USA, ₡ on Costa Rica and € on EU.</li>
                                    </ol>
                                </p>
                                <br>
                                <p>The names of this fields can be changed if needed, but remember, if you change the name, it needs to be changed on the theme, otherwise it won't be replaced and displayed correctly.</p>
                            </div>
                        </div>

                        <h3 id="of_how_to_add">How to add an option field?</h3>
                        <a href="#top">Top</a><br><br>
                        <div class="tutorial_post_box">
                            <p>Add an option field is really easy, here is a step by step guide:</p>
                            <p><strong>1- </strong> Click on the FTM Geo Target menu option "Site Option Fields"</p>
                            <p><strong>2- </strong> Enter the field name</p>
                            <p><strong>3- </strong> Select the field type.</p>
                            <p><strong>4- </strong> Click "Add".</p>
                        </div>

                        <h3 id="of_how_to_edit">How to edit an option field?</h3>
                        <a href="#top">Top</a><br><br>
                        <div class="tutorial_post_box">
                            <p>To edit an option field:</p>
                            <p><strong>1- </strong> Click on the "Edit" button of the desired field to edit.</p>
                            <p><strong>2- </strong> On the edit popup change the name of the field.</p>
                            <p><strong>3- </strong> Select the new field type if you need to change it.</p>
                            <p><strong>4- </strong> Click on update and you are done.</p>
                        </div>

                        <h3 id="of_how_to_delete">How to delete an option field?</h3>
                        <a href="#top">Top</a><br><br>
                        <div class="tutorial_post_box">
                            <p>To delete an option field:</p>
                            <p><strong>1- </strong> Click on the "Delete" button of the desired field to edit.</p>
                            <p><strong>2- </strong> On the delete popup read the disclaimer carefully.</p>
                            <p><strong>3- </strong> Select "Delete Option Field" if you are fine with he consequences of doing it, or click "Close" if you wish to cancel the delete.</p>
                        </div>

                    </div>
                </div>

                <div class="postbox">
                    <h2 class="hndle"><b><?php esc_attr_e('Geo Target Sites', 'wp_admin_style'); ?></b></h2>
                    <div class="inside">
                        <div>
                            <h3 id="s_what_is">What is this?</h3>
                            <a href="#top">Top</a><br><br>
                            <div>
                                <p>The Geo Target Sites page, is the place where you create, edit and delete the sites you will show later on your website, based on geo location.</p>
                                <p>Once you have the list of sites you want to have on your web site, you will have to group them and then assign a set of geo target rules to the group, in order to display this sites inside a themed template.</p>
                                <br>
                                <p>On this page you can see the options to:
                                <ol>
                                    <li>Add a site</li>
                                    <li>Edit an existing one.</li>
                                    <li>Delete a site individually.</li>
                                </ol>
                                </p>
                                <br>
                                <p>Every site will need to have the site name filled at minimum in order to add it. Also every option field available for the sites Add and Edit pages.</p>
                            </div>
                        </div>

                        <h3 id="s_how_to_add">How to add a Site?</h3>
                        <a href="#top">Top</a><br><br>
                        <div class="tutorial_post_box">
                            <p>Add an option field is really easy, here is a step by step guide:</p>
                            <p><strong>1- </strong> Click on the FTM Geo Target menu option "Sites"</p>
                            <p><strong>2- </strong> On the far right side of the page, inside the sidebar, click on "Add a new site"</p>
                            <p><strong>3- </strong> Now on the "Add New Site" page, you can fill up the site name and all the option field previously added on the "Site Option Fields" maintenance.</p>
                            <p><strong>4- </strong> Once all the data was entered, on the right hand sidebar click on "Add Site".</p>
                            <br>
                            <p>Once the site is added, the confirmation message will show up at the top and the form will be ready to add another one.</p>
                        </div>

                        <h3 id="s_how_to_edit">How to edit a Site?</h3>
                        <a href="#top">Top</a><br><br>
                        <div class="tutorial_post_box">
                            <p>In order to edit a Geo Target Site:</p>
                            <p><strong>1- </strong> On the "Sites" admin page, click on "Edit" on the "Actions" column on the desired "to edit" site.</p>
                            <p><strong>2- </strong> Once on the "Site Edit Page" you can change the name of the site and every one of the "Option Fields" values available at the moment of editing the site.</p>
                            <p><strong>3- </strong> Once you have the new iformation you can click "Update Site" on the right hand side bar of the page.</p>
                            <p><strong>4- </strong> Once received the success message, you can click on the sidebar's "Back to sites" button or update any information again.</p>
                            <br>
                            <p><b>NOTE: </b> you can edit the site name as long as it doesn't collide with any existing site.</p>
                        </div>

                        <h3 id="s_how_to_delete">How to delete a Site?</h3>
                        <a href="#top">Top</a><br><br>
                        <div class="tutorial_post_box">
                            <p>In order to delete a Geo Target Site:</p>
                            <p><strong>1- </strong> On the "Sites" admin page, click on "Delete" on the "Actions" column on the desired "to delete" site.</p>
                            <p><strong>2- </strong> On the delete popup read the disclaimer carefully.</p>
                            <p><strong>3- </strong> Select "Delete Site" if you are fine with he consequences of doing it, or click "Close" if you wish to cancel the delete.</p>
                        </div>

                    </div>
                </div>

                <div class="postbox">
                    <h2 class="hndle"><b><?php esc_attr_e('Geo Target Groups', 'wp_admin_style'); ?></b></h2>
                    <div class="inside">
                        <div>
                            <h3 id="sg_what_is">What is this?</h3>
                            <a href="#top">Top</a><br><br>
                            <div>
                                <p>The Geo Target Site Groups, is the place where most of the magic happens, here you can create, edit and delete the groups that will conain a set of sites and display them based on a set of geo target rules using a selected themed template.</p>
                                <p>Once you create the group, on the groups list page, you will see five columns with different information:</p>
                                <ol>
                                    <li>The group's name.</li>
                                    <li>The group's description so you can know exatcly what this group contains.</li>
                                    <li>The group's shortcode. This is a WP feature that allows you to display this particular group anywhere you want on your content. Simple copy the group's shortcode as is, and paste it anywhere you want on the content editor.</li>
                                    <li>The group's active status. You can deactivate a group in order to hide it anywhere in your site where the shortcode is used without the need to delete the shortcode on every single page and post it's used. Very convinient.</li>
                                    <li>The actions colum, as previously used on this plugin, here are the buttons to edit or delete a group.</li>
                                </ol>
                                </p>

                            </div>
                        </div>

                        <h3 id="sg_how_to_add">How to add a group?</h3>
                        <a href="#top">Top</a><br><br>
                        <div class="tutorial_post_box">
                            <p>Adding a Geo Target Grop field is really easy, here is a step by step guide:</p>
                            <p><strong>1- </strong> Click on the FTM Geo Target menu option "Site Groups"</p>
                            <p><strong>2- </strong> On the far right side of the page, inside the sidebar, click on "Add a new group"</p>
                            <p><strong>3- </strong> Now on the "Add New Group" page, you can fill up the group name, the description, the active status, select the display theme and all the geo target rules that need to check in order to dipslay this group.</p>
                            <p><strong>4- </strong> Lastly, you select and add eny website you want to this group and at the right side bar you click on "Add group."</p>
                            <br>
                            <p>Once the group is added, the confirmation message will show up at the top and the form will be ready to add another one.</p>
                        </div>

                        <h3 id="sg_how_to_edit">How to edit a group?</h3>
                        <a href="#top">Top</a><br><br>
                        <div class="tutorial_post_box">
                            <p>In order to edit a Geo Target Group:</p>
                            <p><strong>1- </strong> On the "Site Groups" admin page, click on "Edit" on the "Actions" column on the desired "to edit" group.</p>
                            <p><strong>2- </strong> Once on the "Group Edit Page" you can change the name, description, active status and theme of the group, as well as the allowed countries, regions and sites for this particular group.</p>
                            <p><strong>3- </strong> Once you have the new iformation you can click "Update group" on the right hand side bar of the page.</p>
                            <p><strong>4- </strong> Once received the success message, you can click on the sidebar's "Back to groups" button or update any information again.</p>
                            <br>
                            <p><b>NOTE: </b> you can edit the group's name as long as it doesn't collide with any existing group.</p>
                            <p><b>NOTE: </b> If you change the group's name, every shortcode added with the previous name will not work, and will show the message: "Please check group's name."</p>
                        </div>

                        <h3 id="sg_how_to_delete">How to delete a group?</h3>
                        <a href="#top">Top</a><br><br>
                        <div class="tutorial_post_box">
                            <p>In order to delete a Geo Target Group:</p>
                            <p><strong>1- </strong> On the "Site Groups" admin page, click on "Delete" on the "Actions" column on the desired "to delete" group.</p>
                            <p><strong>2- </strong> On the delete popup read the disclaimer carefully.</p>
                            <p><strong>3- </strong> Select "Delete Group" if you are fine with he consequences of doing it, or click "Close" if you wish to cancel the delete.</p>
                        </div>

                    </div>
                </div>

                <div class="postbox">
                    <h2 class="hndle"><b><?php esc_attr_e('Geo Target Group Themes', 'wp_admin_style'); ?></b></h2>
                    <div class="inside">
                        <div>
                            <h3 id="t_what_is">What is a theme?</h3>
                            <a href="#top">Top</a><br><br>
                            <div>
                                <p>The Geo Target Site Groups are created to display different kinds of tables on a website, the way this tables are displayed is coded into the themes.</p>
                                <p>Every group needs to have a theme selected in order to display the site's data in a way or another. The themes need to be developed specifically for this plugin, and must follow certain rules.</p>
                                <ol>
                                    <li>The theme's name can't be duplicated, it must be unique and descriptive.</li>
                                    <li>The theme must be uploaded into the themes folder of the FTM Geo Target plugin and the folder where it's added must be named the same as the theme.</li>
                                    <li>It must be uploaded and removed using the site's FTP. </li>
                                    <li>The theme must have two required files:  themename/preview.png that has a preview of how it looks on the site when populated with data. And the render file, this file must be named the same as the theme name, replacing the spaces with "-"(dashes), followed by -render.php. Ex: default/default-render.php </li>
                                    <li>The render file is an HTML file that will be rendered with the corresponding data when the shortcode is added on a page or post.</li>
                                    <li>The render file will have two permanent fields [SITE_NAME], this will be used to display every site's name on every iteration of the sites added to that group, and [COUNT], used to display the site display index, placed there for discretional use.</li>
                                    <li>The portion of the HTML that needs to be repeated by site iteration, must be enclosed in the [SITES-REPEATER]HTML[/SITES-REPEATER] brackets.</li>
                                    <li>In order to display any Site's Option Field, simply surround the field's name in brackets. Ex: [VISIT_LINK].</li>
                                </ol>
                                </p>
                            </div>
                        </div>

                        <h3 id="t_how_to_install">How to install a theme?</h3>
                        <a href="#top">Top</a><br><br>
                        <div class="tutorial_post_box">
                            <p>Adding a Geo Target Grop Theme is really easy, here is a step by step guide:</p>
                            <p><strong>1- </strong> Each theme needs to have it's own directory inside the current WordPress theme directory under /geo-target-themes/ directory .</p>
                            <p>For example ./wp-content/themes/customtheme/geo-target-themes/my-geo-theme/</p>
                            <p><strong>2- </strong> Inside that directory you need the following 2 files: </p>
                            <p><ul>
                                <li>my-geo-theme-render.php (this file name needs to match the folder name and "-render.php")</li>
                                <li>preview.png (this is an image with the previou of how the theme looks like)</li>
                            </ul></p>
                            <p><strong>3- </strong> Once the theme is uploaded, it will show up on the "New Themes" section at the bottom of the page. </p>
                            <p><strong>4- </strong> In order to install the new theme, simply click on the "Install" button on the "Actions" column of the table right on the theme's row.</p>
                            <br>
                            <p>Once the theme is installed, it will show up on the "Inactive Themes" table just in case it shouldn't be elegible right away.</p>
                        </div>

                        <h3 id="t_how_to_activate">How to activate a theme?</h3>
                        <a href="#top">Top</a><br><br>
                        <div class="tutorial_post_box">
                            <p>If you installed a new theme, it will show up on the "Inactive Themes" section of the page, in order to install the theme:</p>
                            <p><strong>1- </strong> Just one step, on the Inactive Themes table look for the theme you wish to activate and click on "Activate" on the Actions column and you are done.</p>
                        </div>

                        <h3 id="t_how_to_deactivate">How to deactivate a theme?</h3>
                        <a href="#top">Top</a><br><br>
                        <div class="tutorial_post_box">
                            <p>In order to deactivate a Geo Target Group Theme all you need to do is follow one step:</p>
                            <p><strong>1- </strong> Just one step, on the Active Themes table look for the theme you wish to deactivate and click on "Deactivate" on the Actions column and you are done.</p>
                        </div>
                        <br>
                        <p><b>NOTE: </b> if you deactivate a theme, it won't show up anymore on the options for new groups or to edit a group, but it will still work on the group until you assign a new theme to it.</p>


                        <h3 id="t_how_to_delete">Why i can't delete a theme??</h3>
                        <a href="#top">Top</a><br><br>
                        <div class="tutorial_post_box">
                            <p>A theme should only be deleted if there is 100% security it's not being used by any shortcode on the site,  that's why it should be just deactivated or manually removed.</p>
                        </div>


                    </div>
                </div>

                <div class="postbox">
                    <h2 class="hndle"><b><?php esc_attr_e('Geo Target Settings', 'wp_admin_style'); ?></b></h2>
                    <div class="inside">
                        <div>
                            <h3 id="t_what_settings">What can I change and what can I do here?</h3>
                            <a href="#top">Top</a><br><br>
                            <div>
                                <p>Right now the settings page only works for two functions: activate the debug data for developers and update the Geo Target File capable of returning a country and region(if available) by just sending it the user's IP Address.</p>
                                <p>The Debug status is very obvious and pretty much is self explanatory but the main function of this page is to be able to update the Get Target File by just upluading it using this utility.</p>
                                <p>If a new version of the Get Target File is available all you have to do is follow this simple steps: </p>
                                <p>
                                <ol>
                                    <li>We only need the GeoIPRegion.dat file, but for security reasons i can't be uploaded as a .dat file so it needs to be added into a .zip file.</li>
                                    <li><b>The GeoIPRegion.dat file must be named that way and only that way.</b></li>
                                    <li>On the "Update geo location .dat file" section, click on "Choose File" and navigate to your .zip file containing the GeoIPRegion.dat file.</li>
                                    <li>Click on "Upload geo .Zip file" and wait until the process is done and the success message is displayed.</li>
                                    <li>If you see the success message, the file was updated and you are good to go. Otherwise, please contact the FTM Geo Target Plugin support team.</li>
                                </ol>
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- .meta-box-sortables .ui-sortable -->
            </div>
            <!-- post-body-content -->
            <!-- sidebar -->
            <?php
            //GLOBAL $ftm_geo_target_plugin_path;
            //require_once $ftm_geo_target_plugin_path . '/includes/sidebar-settings.php';
            ?>
            <!-- sidebar -->
            <!-- #postbox-container-1 .postbox-container -->
        </div>
        <!-- #post-body .metabox-holder .columns-2 -->
        <br class="clear">
    </div>
    <!-- #poststuff -->
</div> <!-- .wrap -->

<script type="text/javascript">
    jQuery(document).ready(function($){
        $('a[href*="#"]')
        // Remove links that don't actually link to anything
            .not('[href="#"]')
            .not('[href="#0"]')
            .click(function(event) {
                // On-page links
                if (
                    location.pathname.replace(/^\//, '') == this.pathname.replace(/^\//, '')
                    &&
                    location.hostname == this.hostname
                ) {
                    // Figure out element to scroll to
                    var target = $(this.hash);
                    target = target.length ? target : $('[name=' + this.hash.slice(1) + ']');
                    // Does a scroll target exist?
                    if (target.length) {
                        // Only prevent default if animation is actually gonna happen
                        event.preventDefault();
                        $('html, body').animate({
                            scrollTop: target.offset().top - 40
                        }, 1000, function() {
                            // Callback after animation
                            // Must change focus!
                            var $target = $(target);
                            $target.focus();
                            if ($target.is(":focus")) { // Checking if the target was focused
                                return false;
                            } else {
                                $target.attr('tabindex','-1'); // Adding tabindex for elements not focusable
                                $target.focus(); // Set focus again
                            };
                        });
                    }
                }
            });
    });
</script>
