<?php
global $wpdb;

if (isset($_POST['cta_delete_id'])) {
    $set_id = $_POST['cta_delete_id'];
    $wpdb->delete($wpdb->prefix . 'ftm_geo_auto_ctas', ['CtaSetId' => $set_id]);
}

if (isset($_POST['save'])) {
    $is_auto_active = ($_POST['is_active'] ?? 'false') !== 'false';
    update_option('ftmgt_cta_active', $is_auto_active?'1':'0');
    $use_shortcode = (isset($_POST['shortcode']) && $_POST['shortcode']==='shortcode')?'shortcode':'auto-include';
    update_option('ftmgt_cta_use_shortcode', $use_shortcode);
    $top_bottom = (isset($_POST['top_bottom']) && $_POST['top_bottom']==='top')?'top':'bottom';
    update_option('ftmgt_cta_top_bottom', $top_bottom);
    $paths = $_POST['paths'] ?? '';
    update_option('ftmgt_cta_paths', $paths);
    $auto_ctas_ids = explode(',', $_POST['ctas_ordered_list']??'');

    $wpdb->query("UPDATE {$wpdb->prefix}ftm_geo_cta SET UseAuto = 0");
    $order = 0;
    foreach ($auto_ctas_ids as $cta_id) {
        $wpdb->update($wpdb->prefix . "ftm_geo_cta",['UseAuto' => 1, 'CtaOrder' => $order], ['CtaId' => $cta_id]);
        $order++;
    }
}


$ctas = ftm_geo_target_currentCtas();
$auto_ctas = ftm_geo_target_currentCtasAuto();
$auto_sets = ftm_geo_target_getCtaSets();
$is_auto_active = boolval(get_option( 'ftmgt_cta_active', '0' ));
$top_bottom = get_option( 'ftmgt_cta_top_bottom', 'bottom' );
$use_shortcode = get_option( 'ftmgt_cta_use_shortcode', 'auto-include' );
$paths = get_option( 'ftmgt_cta_paths', '' );
?>
<div class="modal fade" id="delete_modal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title" id="myModalLabel">Delete Confirmation</h4>
            </div>
            <div class="modal-body">
                <form id="delete_cta_form" name="delete_cta_form" action="<?php echo FTM_WP_INSTALL_PREFIX; ?>/wp-admin/admin.php?page=ftm-geo-target-ctas-auto"  method="post">
                    <fieldset>
                        <div class="form-group">
                            <h4>Are you sure you want to delete this CTA Set?</h4>
                        </div>
                        <br>
                        <!-- Allow form submission with keyboard without duplicating the dialog button -->
                        <input type="hidden" name="cta_delete_id" id="cta_delete_id">
                        <input type="submit" id="diag_form_submit" tabindex="-1" style="position:absolute; top:-1000px">
                    </fieldset>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-bs-dismiss="modal">Close</button>
                <button type="submit" form="delete_cta_form" class="btn btn-primary">Delete CTA</button>
            </div>
        </div>
    </div>
</div>


<div class="wrap ftm_geo_target">

    <div id="icon-options-general" class="icon32"></div>
    <h1><?php esc_attr_e( 'Auto Include CTA', 'wp_admin_style' ); ?></h1>

    <div id="poststuff">

        <div id="post-body" class="metabox-holder columns-2">

            <!-- main content -->
            <div id="post-body-content">

                <div class="ftm_geo_target">

                    <form id="auto_cta_form" method="post" action="">
                        <div class="postbox">
                            <h2 class="hndle"><span><b>Auto show the CTA in the site </b></span></h2>
                            <div class="inside">
                                <div>Active:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<input type="checkbox" <?php if( $is_auto_active ){ print 'checked="checked"';}?> name="is_active" id="is_active" value="1" /></div>
                                <hr>

                                <div>Auto include/Use Shortcode:
                                    <br/>
                                    <label> Auto Include in every page <input type="radio" class="ftm_geo_target_big_input" name="shortcode" size="60" value="auto-include" <?php if( $use_shortcode === 'auto-include' ){ print 'checked="checked"';}?>/></label> <br />
                                    <label> Use shortcode "[ftm_cta_auto]" <input type="radio" class="ftm_geo_target_big_input" name="shortcode"  size="60" value="shortcode" <?php if( $use_shortcode === 'shortcode' ){ print 'checked="checked"';}?>/></label>
                                    <br/><br/>
                                    You can choose to auto include in the footer of every page or instead add the shortcode to the template of the page or any other place and still manage it from this page.
                                    This functionality allows you to have one or many automated sets of CTAs handled here, instead of having to specify the CTAs in the shortcode in the template or specific pages, you could define CTA sets that will be displayed in the routes that you specifiy.
                                </div>
                            </div>
                        </div>

                        <div class="postbox">
                            <div class="inside">
                                <div>
                                    <input class="btn btn-primary" type="submit" name="save" value="<?php esc_attr_e( 'Save', 'wp_admin_style' ); ?>">
                                </div>
                            </div>
                        </div>
                    </form>

                    <div class="meta-box-sortables ui-sortable">
                        <div class="postbox">
                            <div class="handlediv" title="Click to toggle"><br></div>
                            <!-- Toggle -->
                            <h2 class="hndle"><span><?php esc_attr_e( 'Current CTA Sets', 'wp_admin_style' ); ?></span>
                            </h2>
                            <div class="inside">
                                <p><?php esc_attr_e( 'Here you can create, edit and update CTA automatic sets. You can create many so you can assign a specific set of paths for each site to be able to handle different CTAs for different routes.', 'wp_admin_style' ); ?></p>
                                <a href="<?php echo FTM_WP_INSTALL_PREFIX; ?>/wp-admin/admin.php?page=ftm-geo-target-ctas-auto-set" class="btn btn-primary">Add New CTA Set</a>
                                <hr>
                                <table id="site_groups_list" class="sites_list">
                                    <thead>
                                    <tr class="sites_heading">
                                        <th>Active</th>
                                        <th>Paths</th>
                                        <th>Actions</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php
                                    foreach ($auto_sets as $set){?>
                                        <tr class="site_entry">
                                            <td><?php echo ($set->CtaActive)?'Active':'Inactive'; ?></td>
                                            <td><?php echo preg_replace('/\r/', '<br />', $set->Paths); ?></td>
                                            <td class="site_actions">
                                                <a href="<?php echo FTM_WP_INSTALL_PREFIX; ?>/wp-admin/admin.php?page=ftm-geo-target-ctas-auto-set&cta_set_id=<?php echo($set->CtaSetId);?>" class="btn btn-warning">Edit</a> |
                                                <button class="btn btn-danger"  data-bs-toggle="modal" data-bs-target="#delete_modal"  onclick="fill_confirm_popup_key_value('delete_cta_form','cta_delete_id','<?php echo($set->CtaSetId);?>');" name="delete_cta" type="submit">Delete</button>
                                            </td>
                                        </tr>
                                        <?php
                                    }
                                    ?>
                                    </tbody>
                                </table>
                            </div>
                            <!-- .inside -->
                        </div>
                        <!-- .postbox -->
                    </div>
                    <!-- .meta-box-sortables .ui-sortable -->
                </div>
            </div>
        </div>
    </div>
</div>
