<?php

$sites  = ftm_geo_target_currentSites();

?>
<div id="postbox-container-1" class="postbox-container">

    <div class="meta-box-sortables">

        <div class="postbox">

            <div class="handlediv" title="Click to toggle"><br></div>
            <!-- Toggle -->

            <h2 class="hndle"><span><?php esc_attr_e(
                        'Add Site', 'wp_admin_style'
                    ); ?></span></h2>

            <div class="inside">
                <form name="ftm_geo_target_site_add" method="post" action="<?php echo FTM_WP_INSTALL_PREFIX; ?>/wp-admin/admin.php?page=ftm-geo-target-site-add">
                    <p><?php esc_attr_e( 'Click the button below to add a new site' ); ?></p>
                    <input class="btn btn-primary" type="submit" name="adds" value="<?php esc_attr_e( 'Add a new site' ); ?>" />
                </form>
            </div>
            <!-- .inside -->

        </div>
        <!-- .postbox -->

        <div class="postbox">

            <div class="handlediv" title="Click to toggle"><br></div>
            <!-- Toggle -->

            <h2 class="hndle"><span><?php esc_attr_e(
                        'Edit Site', 'wp_admin_style'
                    ); ?></span></h2>

            <div class="inside">
                <p><?php esc_attr_e( 'Please choose a site to edit', 'wp_admin_style' ); ?></p>
                <form method="post" action="<?php echo FTM_WP_INSTALL_PREFIX; ?>/wp-admin/admin.php?page=ftm-geo-target-site-edit">
                    <select name="sedit">
                        <?php
                        if(!empty($sites)) {
                            foreach ($sites as $site) {
                                ?>
                                <option value="<?php print $site->id; ?>"><?php print stripcslashes($site->name); ?></option>
                                <?php
                            }
                        }
                        ?>
                    </select>
                    <input class="btn btn-primary" type="submit" name="edits" value="<?php esc_attr_e( 'Edit' ); ?>" />
                </form>
            </div>
            <!-- .inside -->

        </div>
        <!-- .postbox -->

        <div class="postbox">

            <div class="handlediv" title="Click to toggle"><br></div>
            <!-- Toggle -->

            <h2 class="hndle"><span><?php esc_attr_e(
                        'Delete site', 'wp_admin_style'
                    ); ?></span></h2>

            <div class="inside">
                <p><?php esc_attr_e( 'Choose the site you would like to delete', 'wp_admin_style' ); ?></p>
                <form method="post" action="<?php echo FTM_WP_INSTALL_PREFIX; ?>/wp-admin/admin.php?page=ftm-geo-target-site-delete">
                    <select name="sdelete">
                        <?php
                        if(!empty($sites)) {
                            foreach ($sites as $site) {
                                ?>
                                <option value="<?php print $site->id; ?>"><?php print stripcslashes($site->name);?></option>
                                <?php
                            }
                        }
                        ?>
                    </select>
                    <input class="btn btn-primary gs_slots_games_red" type="submit" name="deletes" value="<?php esc_attr_e( 'Delete' ); ?>" />
                </form>
            </div>
            <!-- .inside -->
        </div>

    </div>
    <!-- .meta-box-sortables -->

</div>
