SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET AUTOCOMMIT = 0;
START TRANSACTION;
SET time_zone = "+00:00";

--
-- Database: `wpcostar_wordpress`
--

-- --------------------------------------------------------

--
-- Table structure for table `ftm_geo_target_field_types`
--

CREATE TABLE `ftm_geo_target_field_types` (
  `typeid` int(11) NOT NULL AUTO_INCREMENT,
  `typename` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`typeid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- ftm_geo_target_countries_group
-- Dumping data for table `ftm_geo_target_field_types`
--

INSERT INTO `ftm_geo_target_field_types` (`typename`) VALUES
('textbox'),
('picture'),
('wysiwyg'),
('geoValue');

-- --------------------------------------------------------

--
-- Table structure for table `ftm_geo_target_sites`
--

CREATE TABLE IF NOT EXISTS `ftm_geo_target_sites` (
  `siteid` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`siteid`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;


-- --------------------------------------------------------

--
-- Table structure for table `ftm_geo_target_site_options`
--

CREATE TABLE `ftm_geo_target_site_options` (
  `optionid` int(11) NOT NULL AUTO_INCREMENT,
  `fieldtypeid` int(11) NOT NULL,
  `fieldname` varchar(255) NOT NULL,
  `fieldvalue` text,
  `fieldorder` int(11),
  PRIMARY KEY (`optionid`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



CREATE TABLE `ftm_geo_target_site_values` (
  `siteid` int(11) NOT NULL,
  `siteoptionid` int(11) NOT NULL,
  `siteoptionvalue` text NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;


--
-- Indexes for table `ftm_geo_target_field_types`
--

--ALTER TABLE `ftm_geo_target_field_types`


--
-- Indexes for table `ftm_geo_target_sites`
--
ALTER TABLE `ftm_geo_target_sites`
  ADD UNIQUE KEY (`name`);

--
-- Indexes for table `ftm_geo_target_site_values`
--
ALTER TABLE `ftm_geo_target_site_values`
  ADD PRIMARY KEY (`siteid`,`siteoptionid`);

--
-- AUTO_INCREMENT for table `ftm_geo_target_field_types`
--
ALTER TABLE `ftm_geo_target_field_types`
  MODIFY `typeid` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT for table `ftm_geo_target_sites`
--
ALTER TABLE `ftm_geo_target_sites`
  MODIFY `siteid` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT for table `ftm_geo_target_site_options`
--
ALTER TABLE `ftm_geo_target_site_options`
  MODIFY `optionid` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;
COMMIT;

-- THEMES TABLE CREATION
CREATE TABLE `ftm_geo_target_themes` (
    `ThemeId` INT NOT NULL AUTO_INCREMENT ,
    `ThemeName` VARCHAR(100) NOT NULL ,
    `ThemeActive` BOOLEAN NOT NULL ,
    PRIMARY KEY (`ThemeId`)) ENGINE = MyISAM;

INSERT INTO `ftm_geo_target_themes` (`ThemeName`, `ThemeActive`) VALUES ('Default', '1');


-- GROUPS TABLE CREATION
CREATE TABLE `ftm_geo_target_groups` (
    `GroupId` INT NOT NULL AUTO_INCREMENT ,
    `GroupName` VARCHAR(200) NOT NULL ,
    `GroupDescription` VARCHAR(600) NOT NULL ,
    `GroupActive` BOOLEAN NOT NULL ,
    `GroupThemeId` INT NOT NULL ,
    PRIMARY KEY (`GroupId`)) ENGINE = MyISAM;

-- SITES BY GROUP TABLE
CREATE TABLE `ftm_geo_target_sites_group` ( `GroupId` INT NOT NULL , `SiteId` INT NOT NULL, `SiteOrder` INT NOT NULL ) ENGINE = MyISAM;

-- REGIONS BY GROUP TABLE
CREATE TABLE `ftm_geo_target_regions_group` ( `GroupId` INT NOT NULL , `RegionId` INT NOT NULL) ENGINE = MyISAM;

-- COUNTRIES BY GROUP
CREATE TABLE `ftm_geo_target_countries_group` ( `GroupId` INT NOT NULL , `CountryCode` VARCHAR(3) NOT NULL ) ENGINE = MyISAM;

CREATE TABLE `ftm_geo_target_settings` (
  `DebugStatus` tinyint(1) NOT NULL DEFAULT '0',
  `GeoFileLastUpdated` DATETIME  NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO `ftm_geo_target_settings` (`DebugStatus`) VALUES ('0');