<?php

/**
 * Register Custom Post Type
 */
add_action('init', function () {
    register_taxonomy(
        'pick-category',
        array(
            0 => 'pick',
        ),
        array(
            'labels' => array(
                'name' => 'Pick Category',
                'singular_name' => 'Pick Category',
                'menu_name' => 'Pick Category',
                'all_items' => 'All Pick Category',
                'edit_item' => 'Edit Pick Category',
                'view_item' => 'View Pick Category',
                'update_item' => 'Update Pick Category',
                'add_new_item' => 'Add New Pick Category',
                'new_item_name' => 'New Pick Category Name',
                'parent_item' => 'Parent Pick Category',
                'parent_item_colon' => 'Parent Pick Category:',
                'search_items' => 'Search Pick Category',
                'not_found' => 'No pick category found',
                'no_terms' => 'No pick category',
                'filter_by_item' => 'Filter by pick category',
                'items_list_navigation' => 'Pick Category list navigation',
                'items_list' => 'Pick Category list',
                'back_to_items' => '← Go to pick category',
                'item_link' => 'Pick Category Link',
                'item_link_description' => 'A link to a pick category',
            ),
            'public' => true,
            'hierarchical' => true,
            'show_in_menu' => true,
            'show_in_rest' => true,
            'rewrite' => array(
                'hierarchical' => true,
            ),
        )
    );
});

add_action('init', function () {
    register_post_type('pick', array(
        'labels' => array(
            'name' => 'Picks',
            'singular_name' => 'Pick',
            'menu_name' => 'Picks',
            'all_items' => 'All Picks',
            'edit_item' => 'Edit Pick',
            'view_item' => 'View Pick',
            'view_items' => 'View Picks',
            'add_new_item' => 'Add New Pick',
            'add_new' => 'Add New Pick',
            'new_item' => 'New Pick',
            'parent_item_colon' => 'Parent Pick:',
            'search_items' => 'Search Picks',
            'not_found' => 'No picks found',
            'not_found_in_trash' => 'No picks found in Trash',
            'archives' => 'Pick Archives',
            'attributes' => 'Pick Attributes',
            'insert_into_item' => 'Insert into pick',
            'uploaded_to_this_item' => 'Uploaded to this pick',
            'filter_items_list' => 'Filter picks list',
            'filter_by_date' => 'Filter picks by date',
            'items_list_navigation' => 'Picks list navigation',
            'items_list' => 'Picks list',
            'item_published' => 'Pick published.',
            'item_published_privately' => 'Pick published privately.',
            'item_reverted_to_draft' => 'Pick reverted to draft.',
            'item_scheduled' => 'Pick scheduled.',
            'item_updated' => 'Pick updated.',
            'item_link' => 'Pick Link',
            'item_link_description' => 'A link to a pick.',
        ),
        'description' => 'Pick Posts',
        'public' => true,
        'hierarchical' => true,
        'show_in_rest' => true,
        'menu_icon' => 'dashicons-admin-post',
        'supports' => array(
            0 => 'title',
            1 => 'author',
            2 => 'editor',
            3 => 'excerpt',
            4 => 'revisions',
            5 => 'page-attributes',
            6 => 'thumbnail',
            7 => 'custom-fields',
        ),
        'rewrite' => array(
            'slug' => 'picks',
        ),
        'delete_with_user' => false,
    ));
});
