<?php

function ftm_gs_child_customize_register($wp_customize)
{
    // Add the setting
    $wp_customize->add_setting('ftm_general_picks_hub_post_type', array(
        'default' => false,
        'transport' => 'refresh',
    ));

    // Add the control
    $wp_customize->add_control('ftm_general_picks_hub_post_type_control', array(
        'type'     => 'select',
        'label'    => __('Picks Hub - Post Type', 'custom-theme'),
        'section'  => 'ftm_general_section',
        'settings' => 'ftm_general_picks_hub_post_type',
        'choices'  => get_public_post_types(),
        'priority' => 101 // Set priority to slot in
    ));

    // Reorder existing controls to accommodate the new one
    $blog_hub_control = $wp_customize->get_control('ftm_general_blog_hub_post_type_control');
    if ($blog_hub_control) {
        $blog_hub_control->priority = 100;
    }

    $author_related_control = $wp_customize->get_control('ftm_general_author_related_post_type_control');
    if ($author_related_control) {
        $author_related_control->priority = 102;
    }
    
    $state_filter_control = $wp_customize->get_control('ftm_general_state_filter_display_control');
    if ($state_filter_control) {
        $state_filter_control->priority = 103;
    }
}
add_action('customize_register', 'ftm_gs_child_customize_register', 20);

// Add function to display pick posts on pick-category archive pages
function add_picks_to_pick_category_archive($query)
{
    // Only modify the main query on pick-category taxonomy archives
    if (is_tax('pick-category') && $query->is_main_query() && !is_admin()) {
        $query->set('post_type', 'pick');
    }
}
add_action('pre_get_posts', 'add_picks_to_pick_category_archive');

// Extend Rank Math breadcrumb filter to handle /picks/ the same way as /blog/
add_filter('rank_math/frontend/breadcrumb/items', function ($crumbs, $class) {
    $current_url = home_url($_SERVER['REQUEST_URI']);

    $firstPart      = array_slice($crumbs, 0, 1);
    $secondPart     = array_slice($crumbs, 1);

    // Handle picks category URLs - replace taxonomy slug with /picks/
    for ($i = 0; $i < count($secondPart); $i++) {
        for ($j = 0; $j < count($secondPart[$i]); $j++) {
            if (!empty($secondPart[$i][$j])) {
                // Replace /pick-category/ with /picks/
                $secondPart[$i][$j] = preg_replace('/\/pick-category\//', '/picks/', $secondPart[$i][$j]);
            }
        }
    }

    // Handle picks taxonomy and single pick posts
    if (preg_match('/\/picks\//', $current_url) && is_tax('pick-category')) {
        // For pick category archives, skip the "Pick Category" taxonomy name
        // Only include Home » Picks » [Category Name]
        $picksElement[]  = ["Picks", home_url() . "/picks/", "hide_in_schema" => false];
        // Get only the last element (the actual category name), skip the taxonomy name
        $categoryPart = array_slice($secondPart, -1);
        $crumbs = array_merge($firstPart, $picksElement, $categoryPart);
    }
    // Add "Picks" breadcrumb element for single pick posts
    elseif (is_singular('pick')) {
        $picksElement[]  = ["Picks", home_url() . "/picks/", "hide_in_schema" => false];
        $crumbs = array_merge($firstPart, $picksElement, $secondPart);
    }

    return $crumbs;
}, 20, 2);