<?php

/**
 * Register Custom Post Type
 */
add_action('init', function () {
    register_taxonomy(
        'pick-category',
        array(
            0 => 'pick',
        ),
        array(
            'labels' => array(
                'name' => 'Pick Category',
                'singular_name' => 'Pick Category',
                'menu_name' => 'Pick Category',
                'all_items' => 'All Pick Category',
                'edit_item' => 'Edit Pick Category',
                'view_item' => 'View Pick Category',
                'update_item' => 'Update Pick Category',
                'add_new_item' => 'Add New Pick Category',
                'new_item_name' => 'New Pick Category Name',
                'parent_item' => 'Parent Pick Category',
                'parent_item_colon' => 'Parent Pick Category:',
                'search_items' => 'Search Pick Category',
                'not_found' => 'No pick category found',
                'no_terms' => 'No pick category',
                'filter_by_item' => 'Filter by pick category',
                'items_list_navigation' => 'Pick Category list navigation',
                'items_list' => 'Pick Category list',
                'back_to_items' => '← Go to pick category',
                'item_link' => 'Pick Category Link',
                'item_link_description' => 'A link to a pick category',
            ),
            'public' => true,
            'hierarchical' => true,
            'show_in_menu' => true,
            'show_in_rest' => true,
            'rewrite' => array(
                'hierarchical' => true,
            ),
        )
    );
});

add_action('init', function () {
    register_post_type('pick', array(
        'labels' => array(
            'name' => 'Picks',
            'singular_name' => 'Pick',
            'menu_name' => 'Picks',
            'all_items' => 'All Picks',
            'edit_item' => 'Edit Pick',
            'view_item' => 'View Pick',
            'view_items' => 'View Picks',
            'add_new_item' => 'Add New Pick',
            'add_new' => 'Add New Pick',
            'new_item' => 'New Pick',
            'parent_item_colon' => 'Parent Pick:',
            'search_items' => 'Search Picks',
            'not_found' => 'No picks found',
            'not_found_in_trash' => 'No picks found in Trash',
            'archives' => 'Pick Archives',
            'attributes' => 'Pick Attributes',
            'insert_into_item' => 'Insert into pick',
            'uploaded_to_this_item' => 'Uploaded to this pick',
            'filter_items_list' => 'Filter picks list',
            'filter_by_date' => 'Filter picks by date',
            'items_list_navigation' => 'Picks list navigation',
            'items_list' => 'Picks list',
            'item_published' => 'Pick published.',
            'item_published_privately' => 'Pick published privately.',
            'item_reverted_to_draft' => 'Pick reverted to draft.',
            'item_scheduled' => 'Pick scheduled.',
            'item_updated' => 'Pick updated.',
            'item_link' => 'Pick Link',
            'item_link_description' => 'A link to a pick.',
        ),
        'description' => 'Pick Posts',
        'public' => true,
        'hierarchical' => true,
        'show_in_rest' => true,
        'menu_icon' => 'dashicons-admin-post',
        'supports' => array(
            0 => 'title',
            1 => 'author',
            2 => 'editor',
            3 => 'excerpt',
            4 => 'revisions',
            5 => 'page-attributes',
            6 => 'thumbnail',
            7 => 'custom-fields',
        ),
        'rewrite' => array(
            'slug' => 'picks',
        ),
        'delete_with_user' => false,
    ));
});

// Add ACF Fields for Picks Hub Settings
if (function_exists('acf_add_local_field_group')) :

    acf_add_local_field_group(array(
        'key' => 'group_6511de1e3c7a9', // Unique key (changed last digit from original)
        'title' => 'FTM Picks Hub Settings',
        'fields' => array(
            array(
                'key' => 'field_659dae10774fb', // Unique key
                'label' => 'Show Most Popular Section',
                'name' => 'show_most_popular_section',
                'aria-label' => '',
                'type' => 'true_false',
                'instructions' => 'Check the box if you would like the most popular section to show up',
                'required' => 0,
                'conditional_logic' => 0,
                'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                ),
                'message' => '',
                'default_value' => 1,
                'ui' => 0,
                'ui_on_text' => '',
                'ui_off_text' => '',
            ),
            array(
                'key' => 'field_6511de1e18e2b', // Unique key
                'label' => 'Most Popular Title',
                'name' => 'most_popular_title',
                'type' => 'text',
                'instructions' => '',
                'required' => 0,
                'conditional_logic' => 0,
                'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                ),
                'default_value' => 'Most popular',
                'maxlength' => '',
                'placeholder' => '',
                'prepend' => '',
                'append' => '',
            ),
            array(
                'key' => 'field_6511de5818e2c', // Unique key
                'label' => 'Latest Picks Title',
                'name' => 'latest_blogs_title', // Keeping same name for compatibility with template
                'type' => 'text',
                'instructions' => '',
                'required' => 0,
                'conditional_logic' => 0,
                'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                ),
                'default_value' => 'Latest',
                'maxlength' => '',
                'placeholder' => '',
                'prepend' => '',
                'append' => '',
            ),
        ),
        'location' => array(
            array(
                array(
                    'param' => 'page_template',
                    'operator' => '==',
                    'value' => 'templates/picks-home.php',
                ),
            ),
        ),
        'menu_order' => 0,
        'position' => 'normal',
        'style' => 'default',
        'label_placement' => 'top',
        'instruction_placement' => 'label',
        'hide_on_screen' => '',
        'active' => true,
        'description' => '',
        'show_in_rest' => 0,
    ));
    
    // Add "Most Popular" field to 'pick' post type
    acf_add_local_field_group(array(
        'key' => 'group_650121c094d8c', // Unique key
        'title' => 'FTM Base Pick Posts',
        'fields' => array(
            array(
                'key' => 'field_650121c246477', // Unique key
                'label' => 'Most Popular',
                'name' => 'most_popular',
                'type' => 'true_false',
                'instructions' => '',
                'required' => 0,
                'conditional_logic' => 0,
                'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                ),
                'message' => 'If selected, this post might show up on the top 3 most popular posts on the picks hub template',
                'default_value' => 0,
                'ui_on_text' => '',
                'ui_off_text' => '',
                'ui' => 0,
            ),
        ),
        'location' => array(
            array(
                array(
                    'param' => 'post_type',
                    'operator' => '==',
                    'value' => 'pick',
                ),
            ),
        ),
        'menu_order' => 0,
        'position' => 'normal',
        'style' => 'default',
        'label_placement' => 'top',
        'instruction_placement' => 'label',
        'hide_on_screen' => '',
        'active' => true,
        'description' => '',
        'show_in_rest' => 0,
    ));

endif;
