<?php

//This function returns every single custom field as an array for a specific site
function get_site_site_data($site_id)
{
    $custom_fields = array();

    // Retrieve the ACF field values for the given site post
    $site_name          = get_field('site_name', $site_id);
    $affiliate_url      = get_field('affiliate_url', $site_id);
    $site_logo          = get_field('site_logo', $site_id);
    $total_members      = get_field('total_members', $site_id);
    $active_members     = get_field('active_members', $site_id);
    $monthly_visitors   = get_field('monthly_visitors', $site_id);
    $gender_ratio       = get_field('gender_ratio', $site_id);
    $best_for           = get_field('best_for', $site_id);
    $rating_value       = get_field('rating_value', $site_id);
    $rating_top         = get_field('rating_top', $site_id);
    $free_trial         = get_field('free_trial', $site_id);
    $site_memberships   = get_field('site_memberships', $site_id);

    // Add the field values to the custom_fields array
    $custom_fields['site_name']          = $site_name;
    $custom_fields['affiliate_url']      = $affiliate_url;
    $custom_fields['site_logo']          = $site_logo;
    $custom_fields['total_members']      = $total_members;
    $custom_fields['active_members']     = $active_members;
    $custom_fields['free_trial']         = $free_trial;
    $custom_fields['rating_top']         = $rating_top;
    $custom_fields['rating_value']       = $rating_value;
    $custom_fields['gender_ratio']       = $gender_ratio;
    $custom_fields['monthly_visitors']   = $monthly_visitors;
    $custom_fields['free_trial']         = $free_trial;

    $custom_fields['site_memberships'] = $site_memberships;


    // Add more fields as needed following the same pattern

    return $custom_fields;
}


function site_fields_shortcode($atts)
{
    $atts = shortcode_atts(array(
        'site_id' => '',
        'field' => '',
        'membership_name' => '',
        'membership_field' => '',
    ), $atts);

    $site_id          = $atts['site_id'];
    $field            = $atts['field'];
    $membership_name  = strtolower($atts['membership_name']);
    $membership_field = $atts['membership_field']; //Should be price or features

    // Retrieve the ACF field values for the given site post
    $custom_fields = get_site_site_data($site_id);

    // If a specific field is specified, return only that field's value
    if (!empty($field)) {
        //check if the requested field is a membership value
        if ($field == "membership") {            
            // Check if the memberships repeater field exists and has rows            
            if (isset($custom_fields['site_memberships'])) {                                
                foreach ($custom_fields['site_memberships'] as $membership) :                    
                    // Check if a specific membership index is provided
                    if (strtolower($membership['membership_name']) == $membership_name) {
                        // If a specific field is specified, return only that field's value
                        $return_value = '';

                        switch ($membership_field) {
                            case 'price':
                                $return_value = $membership['membership_price'];
                                break;
                            case 'features':
                                $return_value = $membership['membership_features'];
                                break;
                        }

                        // display a sub field value
                        return $return_value;
                    }
                endforeach;
            }
        } else { //Any other field requested

            if($field == "site_logo"){
                if(isset( $custom_fields[$field]['sizes']['medium'])){
                    $image_output = '<img src="'. $custom_fields[$field]['sizes']['medium'] .'" alt="'. $custom_fields[$field]['alt'] .'" />';
                    return $image_output;
                }      
                else
                {
                    return "";
                }                          
            }
            else
            {
                if($field == "free_trial"){
                    if(isset($custom_fields[$field])){
                        if($custom_fields[$field] == 1){
                            return "Free Trial";
                        }
                        else
                        {
                            return "";
                        }
                    }               
                    else
                    {
                        return "";
                    }                         
                }
                else
                {
                    return $custom_fields[$field];
                }                
            }            
        }
    } else {
        // If no specific field is specified, return an empty string
        return '';
    }
}
add_shortcode('site_fields', 'site_fields_shortcode');