<?php

/*
* Plugin Name:    FTM Sites tracker
 * Plugin URI:    https://www.ftmedia.com
 * Description:   FTM Sites Database
 * Version:       1.0.3
 * Author:        IT
 * Author URI:    https://www.ftmedia.com
 * Text Domain:   ftm-sites-tracker
 * Domain Path:   /languages
*/

// Plugin name
define('FTMST_NAME', 'FTM Sites Tracker');

// Plugin Slug
define('FTMST_SLUG', 'ftm-sites-tracker');

// Plugin version
define('FTMST_VERSION', '1.0.3');

// Plugin Root File
define('FTMST_PLUGIN_FILE', __FILE__);

// Plugin base
define('FTMST_PLUGIN_BASE', plugin_basename(FTMST_PLUGIN_FILE));

// Plugin Folder Path
define('FTMST_PLUGIN_DIR', plugin_dir_path(FTMST_PLUGIN_FILE));

// Plugin Folder URL
define('FTMST_PLUGIN_URL', plugin_dir_url(FTMST_PLUGIN_FILE));

// Plugin CSS Folder
define('FTMST_CSS_FOLDER', 'ftm-st');


/**
 * Load the main core functionality
 */
require_once FTMST_PLUGIN_DIR . 'core/ftm-sites-tracker-core.php';

/**
 * Load the custom ACF Field core class logic
 */
require_once FTMST_PLUGIN_DIR . 'core/classes/ftm-sites-tracker-class.php';


$FTM_sitesTracker =  new FTMsitesTracker();
$FTM_sitesTracker->init();

function init_custom_display_columns(){    
    /* Check conditional tags */
    if ( ! ( is_post_type_archive('site') || is_singular('site') )) {
        add_action('manage_posts_custom_column', array( new FTMsitesTracker(),'column_content'), 5, 2);
        add_filter('manage_posts_columns', array( new FTMsitesTracker(),'add_column'), 5);
    }   
}

add_action( 'init', function () {
    init_custom_display_columns();
} );

// Activation function
function ftm_sites_tracker_activate()
{
}
register_activation_hook(__FILE__, 'ftm_sites_tracker_activate');

// Deactivation function
function ftm_sites_tracker_deactivate()
{

    $FTM_sitesTracker =  new FTMsitesTracker();
    $FTM_sitesTracker->ftm_sites_tracker_deactivate_all_groups();

    // Flush the rewrite rules to ensure the custom post type is correctly handled by WordPress
    flush_rewrite_rules();
}
register_deactivation_hook(__FILE__, 'ftm_sites_tracker_deactivate');

// Installation function
function ftm_sites_tracker_install()
{
}
register_activation_hook(__FILE__, 'ftm_sites_tracker_install');

// Uninstallation function
function ftm_sites_tracker_uninstall()
{
}
register_deactivation_hook(__FILE__, 'ftm_sites_tracker_uninstall');