<?php
class FTMsitesTracker
{

    protected function addCustomPostType()
    {
        if (!post_type_exists('site')) {
            add_action('init', function () {
                $args = array(
                'public' => true,
                'label' => 'Sites',
                'supports' => array( 'title', 'editor', 'thumbnail', 'custom-fields' ),
                'hierarchical'        => false,
                'public'              => true,
                'show_ui'             => true,
                'show_in_menu'        => true,
                'show_in_nav_menus'   => true,
                'show_in_admin_bar'   => true,
                'menu_position'       => 5,
                'menu_icon'           => 'dashicons-admin-multisite',
                'can_export'          => true,
                'has_archive'         => false,
                'exclude_from_search' => false,
                'publicly_queryable'  => true,
                'capability_type'     => 'post',
                'show_in_rest' => true,
                );
                register_post_type('site', $args);
            });
        }
    }

    private function ftm_sites_tracker_field_groups()
    {
        if (function_exists('acf_add_local_field_group')) :
            acf_add_local_field_group(array(
            'key' => 'group_64599173bd15a',
            'title' => 'FTM Site Tracker',
            'fields' => array(
                array(
                    'key' => 'field_6459917398c36',
                    'label' => 'Site Name',
                    'name' => 'site_name',
                    'aria-label' => '',
                    'type' => 'text',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => '',
                    'maxlength' => '',
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                ),
                array(
                    'key' => 'field_658011a798c21',
                    'label' => 'Website Name',
                    'name' => 'website_name',
                    'aria-label' => '',
                    'type' => 'text',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => '',
                    'maxlength' => '',
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                ),
                array(
                    'key' => 'field_260125d598a65',
                    'label' => 'Review Url',
                    'name' => 'review_url',
                    'aria-label' => '',
                    'type' => 'text',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => '',
                    'maxlength' => '',
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                ),
                array(
                    'key' => 'field_163013c798a17',
                    'label' => 'Website Url',
                    'name' => 'website_url',
                    'aria-label' => '',
                    'type' => 'text',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => '',
                    'maxlength' => '',
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                ),
                array(
                    'key' => 'field_645991c898c37',
                    'label' => 'Affiliate Url',
                    'name' => 'affiliate_url',
                    'aria-label' => '',
                    'type' => 'text',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => '',
                    'maxlength' => '',
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                ),
                array(
                    'key' => 'field_645991e998c38',
                    'label' => 'Site Logo',
                    'name' => 'site_logo',
                    'aria-label' => '',
                    'type' => 'image',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'return_format' => 'array',
                    'library' => 'all',
                    'min_width' => '',
                    'min_height' => '',
                    'min_size' => '',
                    'max_width' => '',
                    'max_height' => '',
                    'max_size' => '',
                    'mime_types' => '',
                    'preview_size' => 'medium',
                ),
                array(
                    'key' => 'field_6459924998c39',
                    'label' => 'Total members',
                    'name' => 'total_members',
                    'aria-label' => '',
                    'type' => 'text',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => '',
                    'maxlength' => '',
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                ),
                array(
                    'key' => 'field_6453925998z39',
                    'label' => 'Monthly Visitors',
                    'name' => 'monthly_visitors',
                    'aria-label' => '',
                    'type' => 'text',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => '',
                    'maxlength' => '',
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                ),
                array(
                    'key' => 'field_4457925938d39',
                    'label' => 'Gender Ratio',
                    'name' => 'gender_ratio',
                    'aria-label' => '',
                    'type' => 'text',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => '',
                    'maxlength' => '',
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                ),
                array(
                    'key' => 'field_9457925968f32',
                    'label' => 'Best For',
                    'name' => 'best_for',
                    'aria-label' => '',
                    'type' => 'text',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => '',
                    'maxlength' => '',
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                ),
                array(
                    'key' => 'field_6459928698c3a',
                    'label' => 'Active Members',
                    'name' => 'active_members',
                    'aria-label' => '',
                    'type' => 'text',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => '',
                    'maxlength' => '',
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                ),
                array(
                    'key' => 'field_6459929b98c3b',
                    'label' => 'Free Trial Text',
                    'name' => 'free_trial',
                    'aria-label' => '',
                    'type' => 'text',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => '',
                    'maxlength' => '',
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                ),
                array(
                    'key' => 'field_5477925938a75',
                    'label' => 'Rating Value',
                    'name' => 'rating_value',
                    'aria-label' => '',
                    'type' => 'text',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => '',
                    'maxlength' => '',
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                ),
                array(
                    'key' => 'field_2457625838b42',
                    'label' => 'Rating Top',
                    'name' => 'rating_top',
                    'aria-label' => '',
                    'type' => 'text',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => '',
                    'maxlength' => '',
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                ),
                array(
                    'key' => 'field_645992ca98c3c',
                    'label' => 'Site Memberships',
                    'name' => 'site_memberships',
                    'aria-label' => '',
                    'type' => 'repeater',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'layout' => 'row',
                    'pagination' => 1,
                    'rows_per_page' => 20,
                    'min' => 0,
                    'max' => 0,
                    'collapsed' => '',
                    'button_label' => 'Add Row',
                    'sub_fields' => array(
                        array(
                            'key' => 'field_645a0e9198c3d',
                            'label' => 'Membership Name',
                            'name' => 'membership_name',
                            'aria-label' => '',
                            'type' => 'text',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => '',
                            'maxlength' => '',
                            'placeholder' => '',
                            'prepend' => '',
                            'append' => '',
                            'parent_repeater' => 'field_645992ca98c3c',
                        ),
                        array(
                            'key' => 'field_645a0eb398c3e',
                            'label' => 'Membership Features',
                            'name' => 'membership_features',
                            'aria-label' => '',
                            'type' => 'wysiwyg',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => '',
                            'tabs' => 'all',
                            'toolbar' => 'full',
                            'media_upload' => 1,
                            'delay' => 0,
                            'parent_repeater' => 'field_645992ca98c3c',
                        ),
                        array(
                            'key' => 'field_645a0fcb98c3f',
                            'label' => 'Membership Price',
                            'name' => 'membership_price',
                            'aria-label' => '',
                            'type' => 'number',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => '',
                            'min' => '',
                            'max' => '',
                            'placeholder' => '',
                            'step' => '',
                            'prepend' => '',
                            'append' => '',
                            'parent_repeater' => 'field_645992ca98c3c',
                        ),
                        array(
                            'key' => 'field_645b0fac98c3a',
                            'label' => 'Membership Cicle',
                            'name' => 'membership_cicle',
                            'aria-label' => '',
                            'type' => 'text',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => '',
                            'maxlength' => '',
                            'placeholder' => '',
                            'prepend' => '',
                            'append' => '',
                            'parent_repeater' => 'field_645992ca98c3c',
                        ),
                    ),
                ),
            ),
            'location' => array(
                array(
                    array(
                        'param' => 'post_type',
                        'operator' => '==',
                        'value' => 'site',
                    ),
                ),
            ),
            'menu_order' => 0,
            'position' => 'normal',
            'style' => 'default',
            'label_placement' => 'top',
            'instruction_placement' => 'label',
            'hide_on_screen' => '',
            'active' => true,
            'description' => '',
            'show_in_rest' => 1,
            ));
        endif;
    }

    // Enable Custom Fields Support For Custom Post Type
    protected function ftm_sites_tracker_field_groups_support()
    {
        // Replace 'events' with your custom post type name
        add_post_type_support('site', 'custom-fields');
    }

    function ftm_sites_tracker_deactivate_all_groups()
    {
        acf_remove_local_field_group('group_64599173bd15a');
    }

    protected function addAcfGroups()
    {
        $this->ftm_sites_tracker_field_groups();
    }

    //Add custom column to a specific custom post type
    function add_column($columns)
    {
        global $post;

        if( get_post_type( $post->ID ) == 'site'){
            $columns['post_id_clmn'] = 'Shortcode'; 
            $columns['shortcode_options'] = 'Field Options';
        }
        return $columns;
    }

    function column_content($column, $id)
    {
        if ($column === 'post_id_clmn') {
            echo '[site_fields site_id=' . $id . ' field=site_name]';
        }
        
        if ($column === 'shortcode_options') {
            $output  = 'site_name, affiliate_url, site_logo, total_members, active_members, free_trial, membership';
            $output .= '<br> <b>NOTE:</b> When  using the field "membership", you need to provide both extra parameters:';
            $output .= '<br>membership_name and membership_field( price or features)';
            echo $output;
        }        
    }

    function init()
    {
        $this->AddCustomPostType();
        $this->AddAcfGroups();        
    }
}