<?php

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) exit;
/**
 * Class FTMDSC_DYNAMIC_FIELD
 *
 *
 * @package		FTMDSC
 * @subpackage	Classes/Ftm_Dating_Center_Fields
 * @author		FTMedia
 * @since		1.0.0
 */

class FTMDSC_FIELD
{
	private $fieldID;
	private $fieldName;
	private $fieldGroupID;
	private $fieldRestrictions;
    private $fieldType;
    private $fieldDefaultvalue;
    private $tableName = "ftmdc_field";    

	public function __construct()
	{
	}

	public function setFieldID($fieldID)
	{
		$this->fieldID = $fieldID;
	}

	public function getFieldID()
	{
		return $this->fieldID;
	}

	public function setFieldName($fieldName)
	{
		$this->fieldName = $fieldName;
	}

	public function getFieldName()
	{
		return $this->fieldName;
	}

    public function setFieldType($fieldType)
	{
		$this->fieldType = $fieldType;
	}

	public function getFieldType()
	{
		return $this->fieldType;
	}

    public function setFieldDefaultValue($fieldDefaultvalue)
	{
		$this->fieldDefaultvalue = $fieldDefaultvalue;
	}

	public function getFieldDefaultValue()
	{
		return $this->fieldDefaultvalue;
	}

	public function setFieldGroupID($fieldGroupID)
	{
		$this->fieldGroupID = $fieldGroupID;
	}

	public function getFieldGroupID()
	{
		return $this->fieldGroupID;
	}

	public function setFieldRestrictions($fieldRestrictions)
	{
		$this->fieldRestrictions = $fieldRestrictions;
	}

	public function getFieldRestrictions()
	{
		return $this->fieldRestrictions;
	}


	public function read()
	{
		try
		{
            $fieldID = $this->getFieldID();

            if( $fieldID > 0 ){
                GLOBAL $wpdb;

                $ftmdc_fields = $wpdb->prefix . $this->tableName;
            
                $field_info = $wpdb->get_results("SELECT * FROM " . $ftmdc_fields . " WHERE fieldID = " . $fieldID );         
                            
                if( sizeof( $field_info ) > 0 ){
                    $this->setFieldName( $field_info[0]->fieldName );                    
                    $this->setFieldType( $field_info[0]->fieldType );
                    $this->setFieldDefaultValue( $field_info[0]->fieldDefaultValue );
                    $this->setFieldRestrictions( $field_info[0]->fieldRestrictions );
                    $this->setFieldGroupID( $field_info[0]->fieldGroupID );                    
                    return true;
                }               
                else
                {
                    return false;
                } 
            }  
            else
            {
                return null;
            }          
		}
		catch(Exception $exception)
		{
			return $exception->getMessage();
		}
	}

	public function update()
	{
		try
		{
            global $wpdb;
            $ftmdc_fields = $wpdb->prefix . $this->tableName;

            $update = $wpdb->update($ftmdc_fields,
            array(
                'fieldName'         => ( $this->getFieldName() ),
                'fieldType'         => ( $this->getFieldType() ),
                'fieldDefaultValue' => ( $this->getFieldDefaultValue() ),
                'fieldRestrictions' => ( $this->getFieldRestrictions() ),
                'fieldGroupID'      => ( $this->getFieldGroupID() )        
            ),
            array ('fieldID' =>  $this->getFieldID()),
            array(
                '%s',
                '%s',
                '%s',
                '%s',
                '%d'
            )
        );

            if($update !== false){
                $result = true;
            }else{
                $result = false;            
            }

            return $result;

		}
		catch(Exception $exception)
		{
            return $exception->getMessage();
		}
	}

	public function delete()
	{
        global $wpdb;
        $ftmdc_fields = $wpdb->prefix . $this->tableName;
        $ftmdc_site_fields = $wpdb->prefix . "ftmdc_site_fields";
        $result = false;

		try
		{	
            
            $delete_result = $wpdb->delete(
                $ftmdc_site_fields, 
                ['fieldID' => $this->getFieldID()],  	
                ['%d'], 						
            );

            if($delete_result !== false){
                if( $delete_result > 0 ){
                    $result = true;
                }                
            }else{
                $result = false;            
            }            

            if( $result ){
                $delete_result = $wpdb->delete(
                    $ftmdc_fields, 
                    ['fieldID' => $this->getFieldID()],  	
                    ['%d'], 						
                );
    
                if($delete_result !== false){
                    $result = true;
                }else{
                    $result = false;            
                }  
            }             

            return $result;            
        }
		catch(Exception $exception)
		{
			echo $exception->getMessage();
		}
	}

    public function save(){
        global $wpdb;
        $result = 0;

        try{
            $wpdb->insert($wpdb->prefix . $this->tableName,
                array(
                    'fieldName'         => ( $this->getFieldName() ),
                    'fieldType'         => ( $this->getFieldType() ),
                    'fieldDefaultValue' => ( $this->getFieldDefaultValue() ),
                    'fieldRestrictions' => ( $this->getFieldRestrictions() ),
                    'fieldGroupID'      => ( $this->getFieldGroupID() )                
                ),
                array(
                    '%s',
                    '%s',
                    '%s',
                    '%s',
                    '%d'
                )
            );


            if($wpdb->insert_id != false){
                if($wpdb->insert_id > 0){
                    $this->setFieldID( $wpdb->insert_id ); 
                    $result = $this->getFieldID();                    
                }
            }
            else
            {
                $result = -1;
            }
        }
		catch(Exception $exception)
		{
            return $exception->getMessage();
		}

        return $result;
    }
    
    public function list($list_type = null){
		GLOBAL $wpdb;

		$ftmdc_fields = $wpdb->prefix . $this->tableName;
        $db_query = "SELECT *, 
                    (SELECT `fieldGroupName` FROM `".$wpdb->prefix."ftmdc_field_group` WHERE `".$wpdb->prefix."ftmdc_field_group`.`fieldGroupID` = `".$ftmdc_fields."`.`fieldGroupID`) AS GroupName
                     FROM " . $ftmdc_fields . ";";

        if( $list_type ){
            switch( $list_type ){
                case "detailed" : 
                    $db_query = "SELECT *,
                                (SELECT COUNT(*) FROM `". $wpdb->prefix ."ftmdc_site_fields` WHERE `".$wpdb->prefix."ftmdc_site_fields`.`fieldID` = ".$ftmdc_fields.".`fieldID`) AS UsedOn,
                                (SELECT `fieldGroupName` FROM `".$wpdb->prefix."ftmdc_field_group` WHERE `".$wpdb->prefix."ftmdc_field_group`.`fieldGroupID` = `".$ftmdc_fields."`.`fieldGroupID`) AS GroupName
                                FROM " . $ftmdc_fields .";";
                    break;
            }
        }

		$ftmdc_fields_list = $wpdb->get_results($db_query);
					
		if( sizeof( $ftmdc_fields_list ) > 0 ){
		return $ftmdc_fields_list;
		}               
		else
		{
			return nulll;
		}
	}

}