<?php 
 global $wpdb;

 $output_message = "";
 $output_message_type = null;
 $siteID = 0;
 $siteName = null;
 $site = new FTMDSC_SITE();
 $active_tab = "home";

 if( isset( $_REQUEST["siteID"] ) ){
    $siteID = intval( $_REQUEST["siteID"] );

    if( $siteID <= 0 ){
        $output_message = "No Site ID provided, please go back to the Sites List";
        $output_message_type = "error";
    }
 }

 if( isset( $_REQUEST["activeTab"] ) ){
    $active_tab = $_REQUEST["activeTab"];
 }

 if( $siteID > 0 ){    
    $site->setSiteID($siteID);
    $site_data_loaded = $site->read();
    if( is_null( $site_data_loaded ) || ($site_data_loaded == false) ){
        $output_message = "The Site ID was provided, but no data was loaded, please contact support";
        $output_message_type = "error";
    }
}


$tab_links_base = "admin.php?page=ftm-dating-center-sites-edit&siteID=" . $siteID;

 //POSTBACK
 if( sizeof( $_POST ) > 0 ){         


    //var_dump( $_POST );
    //die();

    if( $_POST["btn-update-basic"] || $_POST["btn-update-memberships"] || $_POST["btn-update-fields"] ){ //Basic Site data or Memberships triggered the POSTBACK

        if ( isset( $_POST["site_name"] ) && strlen( $_POST['site_name'] ) > 0 
        && isset( $_POST['affiliate_url'] ) && strlen( $_POST['affiliate_url'] ) > 0
        && isset( $_POST['image_url'] ) && strlen( $_POST['image_url'] ) > 0 ){        
  
          $free_trial = 0;
          
          if( isset( $_POST['free_trial'] ) ){
              if( $_POST['free_trial'] == "on" ){
                  $free_trial = 1;
              }
          }
  
  
          $site->setSitename( $_POST["site_name"] );
          $site->setSiteAffiliateUrl( $_POST["affiliate_url"] );
          $site->setSiteLogo( isset( $_POST['image_url'] )?$_POST[ 'image_url']:'' );
          $site->setSiteTotalMembers( isset( $_POST['total_members'] )?$_POST['total_members']:'' );
          $site->setSiteActiveMembers( isset( $_POST['active_members'] )?$_POST['active_members']:'' );
          $site->setSiteFreeTrial( $free_trial );
          $site->setSiteMemberships( $_POST["site_memberships_list"] );
          $update_result = $site->update();


          //UPDATE OR ADD CUSTOM FIELDS
          $available_fields = list_all_fields();   

          if( $update_result == true ){
            foreach ($available_fields as $field){
                
                $fieldname_id = strtolower( str_replace( " ", "_", $field->fieldName ) );
    
                if( isset( $_POST[$fieldname_id] ) ){
                    $save_result = $site->save_field( $field->fieldID, $_POST[$fieldname_id] );
                    
                    if( $save_result != true ){
                        $update_result = false;
                    }
                }

                if( $field->fieldType == "boolean" ){
                    if( ! isset( $_POST[$fieldname_id] ) ){
                        $save_result = $site->save_field( $field->fieldID, "off" );
                    }
                    
                    if( $save_result != true ){
                        $update_result = false;
                    }
                }
             }  
          }          
  
          if( $update_result == true ){            
              $output_message_type = "success";
              $output_message = "The Site was succesfully updated!";
              $site->read(); //Reload updated site values
          }
          else
          {
              $output_message_type = "error";
              $output_message = "There was an error updating the site, please contact support";
          }
      }
      else
      {
          $output_message_type = "error";
          $output_message = "Invalid field(s) input value, please check the data before submitting.";
      }
    }
}


?>



<?php render_admin_message( $output_message_type, $output_message );?>

<?php  if( is_null( $site_data_loaded ) || ($site_data_loaded == false) ){ exit(); } ?>

<div id="ftmdc-wrapper">
    <div class="ftmdc-top">        
        <div style="text-align:left;">
            <h1>Edit FTmedia's Dating Center Site</h1>
            <a href="admin.php?page=ftm-dating-center-sites" class="btn btn-success">Back to Sites List</a>
        </div>
        <div style="text-align:right;">            
        </div>
    </div>    
    <br/>
    <div>       
        <form id="site_edit_form" method="post" action="" name="site_edit_form">
            <div id="tabs" class="c-tabs">
                <div class="c-tabs-nav">
                    <a href="<?php echo $tab_links_base . "&activeTab=home" ?>" class="c-tabs-nav__link <?php echo ( $active_tab == "home"? "is-active":"" ); ?>">
                        <i class="fa fa-home"></i>
                        <span>Basic Site Info</span>
                    </a>
                    <a href="<?php echo $tab_links_base . "&activeTab=memberships" ?>" class="c-tabs-nav__link <?php echo ( $active_tab == "memberships"? "is-active":"" ); ?>">
                        <i class="fa fa-book"></i>
                        <span>Site Memberships</span>
                    </a> 
                    <a href="<?php echo $tab_links_base . "&activeTab=fields" ?>" class="c-tabs-nav__link <?php echo ( $active_tab == "fields"? "is-active":"" ); ?>">
                        <i class="fa fa-tasks"></i>
                        <span>Custom Fields</span>
                    </a>               
                </div>
                <div class="c-tab <?php echo ( $active_tab == "home"? "is-active":"" ); ?>">                
                    <div class="c-tab__content">
                        <?php require_once FTMDSC_PLUGIN_DIR . '/views/sub-views/ftm-dating-center-sites-edit-basic-info.php'; ?>
                    </div>                               
                </div>
                <div class="c-tab <?php echo ( $active_tab == "memberships"? "is-active":"" ); ?>">
                    <div class="c-tab__content">
                        <?php require_once FTMDSC_PLUGIN_DIR . '/views/sub-views/ftm-dating-center-sites-edit-memberships.php'; ?>
                    </div>
                </div>          
                <div class="c-tab <?php echo ( $active_tab == "fields"? "is-active":"" ); ?>">
                    <div class="c-tab__content">
                        <?php require_once FTMDSC_PLUGIN_DIR . '/views/sub-views/ftm-dating-center-sites-edit-fields.php'; ?>
                    </div>
                </div>          
            </div>
        </form> 
    </div>
</div>

<script>
  var myTabs = tabs({
    el: '#tabs',
    tabNavigationLinks: '.c-tabs-nav__link',
    tabContentContainers: '.c-tab'
  });

  myTabs.init();
</script>