<?php

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) exit;

/**
 * Class Ftm_Dating_Sites_Center_Run
 *
 * Thats where we bring the plugin to life
 *
 * @package		FTMDSC
 * @subpackage	Classes/Ftm_Dating_Sites_Center_Run
 * @author		FTMedia
 * @since		1.0.0
 */
class Ftm_Dating_Sites_Center_Run{

	/**
	 * Our Ftm_Dating_Sites_Center_Run constructor 
	 * to run the plugin logic.
	 *
	 * @since 1.0.0
	 */
	function __construct(){
		$this->add_hooks();
	}

	/**
	 * ######################
	 * ###
	 * #### WORDPRESS HOOKS
	 * ###
	 * ######################
	 */

	/**
	 * Registers all WordPress and plugin related hooks
	 *
	 * @access	private
	 * @since	1.0.0
	 * @return	void
	 */
	private function add_hooks(){
	
		//add_action( 'plugin_action_links_' . FTMDSC_PLUGIN_BASE, array( $this, 'add_plugin_action_link' ), 20 );
		add_shortcode( 'datinginfo', array( $this, 'datinginfo_callback' ) );
		add_action( 'admin_enqueue_scripts', array( $this, 'enqueue_backend_scripts_and_styles' ), 20 );
		add_action( 'admin_menu', array( $this, 'register_custom_admin_menu_pages' ), 20 );
		add_action( 'plugins_loaded', array( $this, 'add_wp_webhooks_integrations' ), 9 );
		add_action( 'plugins_loaded', array( $this, 'ftm_dating_sites_center_update_db_check'), 9 );
		register_activation_hook( FTMDSC_PLUGIN_FILE, array( $this, 'activation_hook_callback' ) );
	
	}

	/**
	 * ######################
	 * ###
	 * #### WORDPRESS HOOK CALLBACKS
	 * ###
	 * ######################
	 */

	/**
	* Adds action links to the plugin list table
	*
	* @access	public
	* @since	1.0.0
	*
	* @param	array	$links An array of plugin action links.
	*
	* @return	array	An array of plugin action links.
	*/
	public function add_plugin_action_link( $links ) {

		$links['our_shop'] = sprintf( '<a href="%s" title="Custom Link" style="font-weight:700;">%s</a>', 'https://test.test', __( 'Custom Link', 'ftm-dating-sites-center' ) );

		return $links;
	}

	/**
	 * Add the shortcode callback for [datinginfo]
	 *
	 * @access	public
	 * @since	1.0.0
	 *
	 * @param	array	$attr		Additional attributes you have added within the shortcode tag.
	 * @param	string	$content	The content you added between an opening and closing shortcode tag.
	 *
	 * @return	string	The customized content by the shortcode.
	 */
	public function datinginfo_callback( $atts = array(), $content = '' ) {

		extract( shortcode_atts( array(
			'site' => null,
			'get' => null			
		), $atts ) );

		$return_value = "";
		$site_data =  new FTMDSC_SITE();

		//clean the input
		$get =  str_replace( '"', '', $get ); 

		if( !is_null( $site ) ){		
			if( $site_data->read( $site ) ){

				if( !is_null( $get ) ){
					//Basic Site Settings
					if( in_array( $get, ['name','logo','affiliateUrl', 'totalMembers', 'activeMembers', 'freeTrial'] ) ){
						switch( $get ){
							case "name" : 
								$return_value = $site_data->getSiteName();
								break;
							case "logo" : 
								$return_value = $site_data->getSiteLogo();
								break;
							case "affiliateUrl" : 
								$return_value = $site_data->getSiteAffiliateUrl();
								break;
							case "totalMembers" : 
								$return_value = $site_data->getSiteTotalmembers();
								break;
							case "activeMembers" : 
								$return_value = $site_data->getSiteActiveMembers();
								break;
							case "freeTrial" : 
								if( $site_data->getSiteFreeTrial() == "true" ){
									$return_value = "yes";
								}
								else
								{
									$return_value = "no";
								}							
								break;								
						}
					}

					//Memberships
					$pos = strpos( $get, "memberships" );				

					if( $pos !== false ){

						$membership_criteria = explode( ':', str_replace( ')', '' , str_replace( '(', '' , str_replace( 'memberships', '' , $get ) ) )  );
						$memberships_data = json_decode( $site_data->getSiteMemberships() );											

						if( sizeof( $membership_criteria  > 0 ) ){
							$membership_name = 	trim( strtolower( $membership_criteria[0] ) );
							$membership_field = trim( strtolower( $membership_criteria[1] ) );

							foreach( $memberships_data->memberships as $membership){
								if( strtolower( $membership->membership_name ) == $membership_name ){
									switch( $membership_field ){
										case "price":
											$return_value = $membership->membership_price;
											break;
										case "features":
											$return_value = $membership->membership_features;
											break;
									}
								}
							}
						}
					}

					//Dynamic fields
					$dynamic_fields_list = $site_data->getSiteFields();
					if( sizeof( $dynamic_fields_list  > 0  &&  $return_value == "" ) ){						
						foreach( $dynamic_fields_list as $dynamic_field){
							if( $dynamic_field->fieldName ==  $get ){
								if( $dynamic_field->fieldType == "boolean" ){
									if( $dynamic_field->sfValue == "on" ){
										$return_value = "yes";
									}
									else
									{
										$return_value = "no";
									}
								}
								else
								{
									$return_value = $dynamic_field->sfValue;
								}								
								break;
							}
						}
					}
				}				
			}
		}

		return $return_value;
	}

	/**
	 * Enqueue the backend related scripts and styles for this plugin.
	 * All of the added scripts andstyles will be available on every page within the backend.
	 *
	 * @access	public
	 * @since	1.0.0
	 *
	 * @return	void
	 */
	public function enqueue_backend_scripts_and_styles() {

		// jQuery
		wp_enqueue_script('jquery');
		// This will enqueue the Media Uploader script
		wp_enqueue_media();

		//Styles
		wp_enqueue_style( 'ftmdsc-backend-styles', FTMDSC_PLUGIN_URL . 'core/includes/assets/css/backend-styles.css', array(), FTMDSC_VERSION, 'all' );
		wp_enqueue_style( 'ftmdsc-tabs-styles', FTMDSC_PLUGIN_URL . 'core/includes/assets/css/tabs-style.css', array(), FTMDSC_VERSION, 'all' );
		wp_enqueue_style( 'ftmdsc-font-awesome-styles', FTMDSC_PLUGIN_URL . 'core/includes/assets/css/font-awesome.min.css', array(), FTMDSC_VERSION, 'all' );
		wp_enqueue_style( 'ftmdsc-jquery-datatables-styles', 'https://cdn.datatables.net/1.10.19/css/jquery.dataTables.css', array(), FTMDSC_VERSION, 'all' );

		//Scripts			
		wp_enqueue_script( 'ftmdsc-tabs', FTMDSC_PLUGIN_URL . 'core/includes/assets/js/tabs.js', array(), FTMDSC_VERSION, false );
		wp_enqueue_script( 'jquery-ui', 'https://code.jquery.com/ui/1.12.1/jquery-ui.min.js', array('jquery'), FTMDSC_VERSION, false );		
		wp_enqueue_script( 'jquery-datatables', 'https://cdn.datatables.net/1.10.19/js/jquery.dataTables.js', array('jquery'), FTMDSC_VERSION, false );				
		wp_enqueue_script( 'ftmdsc-pristine', FTMDSC_PLUGIN_URL . 'core/includes/assets/js/pristine.min.js', array(), FTMDSC_VERSION, false );
		wp_enqueue_script( 'ftmdsc-backend-scripts', FTMDSC_PLUGIN_URL . 'core/includes/assets/js/backend-scripts.js', array(), FTMDSC_VERSION, true );

		wp_localize_script( 'ftmdsc-backend-scripts', 'ftmdsc', array(
			'plugin_name'  => __( FTMDSC_NAME, 'ftm-dating-sites-center' ),
		));
	}

	/**
	 * Add custom menu pages
	 *
	 * @access	public
	 * @since	1.0.0
	 *
	 * @return	void
	 */
	public function register_custom_admin_menu_pages(){

		add_menu_page( 'FTM Dating Center', 'FTM Dating Center', FTMDSC()->settings->get_capability( 'default' ), 'ftm-dating-center', array( $this, 'custom_admin_menu_page_callback' ), 'dashicons-networking', 5 );
		
		//Add all the sub-pages
		add_submenu_page( 'ftm-dating-center', 'FTM Dating Center Sites', 'Sites', FTMDSC()->settings->get_capability( 'default' ), 'ftm-dating-center-sites', array( $this, 'ftm_dating_center_sites_callback' ) );
		add_submenu_page( null, 'FTM DC Add Site', 'Add Sites', FTMDSC()->settings->get_capability( 'default' ), 'ftm-dating-center-sites-add', array( $this, 'ftm_dating_center_sites_add_callback' ) );
		add_submenu_page( null, 'FTM DC Edit Site', 'Site Edit', FTMDSC()->settings->get_capability( 'default' ), 'ftm-dating-center-sites-edit', array( $this, 'ftm_dating_center_sites_edit_callback' ) );
		add_submenu_page( null, 'FTM DC Delete Site', 'Site Delete', FTMDSC()->settings->get_capability( 'default' ), 'ftm-dating-center-sites-delete', array( $this, 'ftm_dating_center_sites_delete_callback' ) );
		add_submenu_page( 'ftm-dating-center', 'FTM DC Dynamic Fields', 'Dynamic Fields', FTMDSC()->settings->get_capability( 'default' ), 'ftm-dating-center-dynamic-fields', array( $this, 'ftm_dating_center_sites_dynamic_fields_callback' ) );
		add_submenu_page( null, 'FTM DC Add Fields', 'Add Fields', FTMDSC()->settings->get_capability( 'default' ), 'ftm-dating-center-fields-add', array( $this, 'ftm_dating_center_fields_add_callback' ) );		
		add_submenu_page( null, 'FTM DC Edit Field', 'Field Edit', FTMDSC()->settings->get_capability( 'default' ), 'ftm-dating-center-fields-edit', array( $this, 'ftm_dating_center_fields_edit_callback' ) );
		add_submenu_page( null, 'FTM DC Delete Field', 'Field Delete', FTMDSC()->settings->get_capability( 'default' ), 'ftm-dating-center-fields-delete', array( $this, 'ftm_dating_center_fields_delete_callback' ) );

	}

	/**
	 * Add custom menu page content for the following
	 * menu item: custom-menu-slug
	 *
	 * @access	public
	 * @since	1.0.0
	 *
	 * @return	void
	 */
	public function custom_admin_menu_page_callback(){
		require_once FTMDSC_PLUGIN_DIR . '/views/plugin-home.php';
	}

	public function ftm_dating_center_sites_callback(){
		require_once FTMDSC_PLUGIN_DIR . '/views/ftm-dating-center-sites.php';
	}

	public function ftm_dating_center_sites_add_callback(){
		require_once FTMDSC_PLUGIN_DIR . '/views/ftm-dating-center-sites-add.php';
	}

	public function ftm_dating_center_sites_edit_callback(){
		require_once FTMDSC_PLUGIN_DIR . '/views/ftm-dating-center-sites-edit.php';
	}

	public function ftm_dating_center_sites_delete_callback(){
		require_once FTMDSC_PLUGIN_DIR . '/views/ftm-dating-center-sites-delete.php';
	}	

	public function ftm_dating_center_sites_dynamic_fields_callback(){
		require_once FTMDSC_PLUGIN_DIR . '/views/ftm-dating-center-dynamic-fields.php';
	}

	public function ftm_dating_center_fields_add_callback(){
		require_once FTMDSC_PLUGIN_DIR . '/views/ftm-dating-center-dynamic-fields-add.php';
	}

	public function ftm_dating_center_fields_edit_callback(){
		require_once FTMDSC_PLUGIN_DIR . '/views/ftm-dating-center-dynamic-fields-edit.php';
	}

	public function ftm_dating_center_fields_delete_callback(){
		require_once FTMDSC_PLUGIN_DIR . '/views/ftm-dating-center-dynamic-fields-delete.php';
	}

	


	/**
	 * ####################
	 * ### WP Webhooks 
	 * ####################
	 */

	/*
	 * Register dynamically all integrations
	 * The integrations are available within core/includes/integrations.
	 * A new folder is considered a new integration.
	 *
	 * @access	public
	 * @since	1.0.0
	 *
	 * @return	void
	 */
	public function add_wp_webhooks_integrations(){

		// Abort if WP Webhooks is not active
		if( ! function_exists('WPWHPRO') ){
			return;
		}

		$custom_integrations = array();
		$folder = FTMDSC_PLUGIN_DIR . 'core' . DIRECTORY_SEPARATOR . 'includes' . DIRECTORY_SEPARATOR . 'integrations';

		try {
			$custom_integrations = WPWHPRO()->helpers->get_folders( $folder );
		} catch ( Exception $e ) {
			WPWHPRO()->helpers->log_issue( $e->getTraceAsString() );
		}

		if( ! empty( $custom_integrations ) ){
			foreach( $custom_integrations as $integration ){
				$file_path = $folder . DIRECTORY_SEPARATOR . $integration . DIRECTORY_SEPARATOR . $integration . '.php';
				WPWHPRO()->integrations->register_integration( array(
					'slug' => $integration,
					'path' => $file_path,
				) );
			}
		}
	}

	/**
	 * ####################
	 * ### Activation/Deactivation hooks
	 * ####################
	 */
	 
	/*
	 * This function is called on activation of the plugin
	 *
	 * @access	public
	 * @since	1.0.0
	 *
	 * @return	void
	 */
	public function activation_hook_callback(){

		//Your code
		$this->FTMDSC_install();
	}

	function FTMDSC_install() {
		
		global $wpdb;

		require_once(ABSPATH . 'wp-admin/includes/upgrade.php');

		$plugin_tables_prefix = "ftmdc_";
		$install_sql_data_query = read_sql_file( 'plugin_install.sql' );		
	
		if( strpos( $install_sql_data_query, 'Error' ) === false ) {
			$install_sql_data_query = str_replace( $plugin_tables_prefix, $wpdb->prefix . $plugin_tables_prefix, $install_sql_data_query );			
			$dbexecution = dbDelta( $install_sql_data_query ); //All good, run the sql statements in the file		

			//var_dump( $install_sql_data_query );
			//var_dump( $dbexecution );
			//die();
		}
		else{
			die( $install_sql_data_query );
		}
	
		add_option( 'FTMDSC_db_version', FTMDSC_DB_VERSION );
	}

	function FTMDSC_db_update() {
		
		global $wpdb;
		$installed_ver = get_option( "FTMDSC_db_version" );

		if ( $installed_ver != FTMDSC_DB_VERSION ) {
			require_once(ABSPATH . 'wp-admin/includes/upgrade.php');

			$plugin_tables_prefix = "ftmdc_";
			$updates_sql_data_query = read_sql_file('db_updates.sql');
			if(strpos($updates_sql_data_query,'Error') === false) {
				$updates_sql_data_query = str_replace($plugin_tables_prefix, $wpdb->prefix . $plugin_tables_prefix, $updates_sql_data_query);
				dbDelta($updates_sql_data_query); //All good, run the sql statements in the file		
			}
			else{
				die($updates_sql_data_query);
			}
		
			update_option( 'FTMDSC_db_version', FTMDSC_DB_VERSION );	
		}		
	}

	function ftm_dating_sites_center_update_db_check() {
		
		if ( get_site_option( 'FTMDSC_db_version' ) != FTMDSC_DB_VERSION ) {
			$this->FTMDSC_db_update();
		}
	}	

}
