<?php
/**
 * Dating Sites Center
 *
 * @package       FTMDSC
 * @author        FTMedia
 * @version       1.0.3
 *
 * @wordpress-plugin
 * Plugin Name:   Dating Sites Center
 * Plugin URI:    https://www.ftmedia.com
 * Description:   Dating Sites Information Center
 * Version:       1.0.3
 * Author:        FTMedia
 * Author URI:    https://www.ftmedia.com
 * Text Domain:   ftm-dating-sites-center
 * Domain Path:   /languages
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) exit;
// Plugin name
define( 'FTMDSC_NAME',			'Dating Sites Center' );

// Plugin version
define( 'FTMDSC_VERSION',		'1.0.3' );

// Plugin DB version
define( 'FTMDSC_DB_VERSION',	'1.0.0' );

// Plugin Root File
define( 'FTMDSC_PLUGIN_FILE',	__FILE__ );

// Plugin base
define( 'FTMDSC_PLUGIN_BASE',	plugin_basename( FTMDSC_PLUGIN_FILE ) );

// Plugin Folder Path
define( 'FTMDSC_PLUGIN_DIR',	plugin_dir_path( FTMDSC_PLUGIN_FILE ) );

// Plugin Folder URL
define( 'FTMDSC_PLUGIN_URL',	plugin_dir_url( FTMDSC_PLUGIN_FILE ) );

/**
 * Load the main class for the core functionality
 */
require_once FTMDSC_PLUGIN_DIR . 'core/class-ftm-dating-sites-center.php';

/**
 * The main function to load the only instance
 * of our master class.
 *
 * @author  FTMedia
 * @since   1.0.0
 * @return  object|Ftm_Dating_Sites_Center
 */
function FTMDSC() {
	return Ftm_Dating_Sites_Center::instance();
}

FTMDSC();


//PLUGIN UTILITY METHODS
function read_sql_file($filename){
    try {
        $main_sql_data_file = FTMDSC_PLUGIN_DIR . '/sql_files/' . $filename;
        $sql_file = fopen($main_sql_data_file, "r");
        $main_sql_data_query = fread($sql_file, filesize($main_sql_data_file));
        fclose($sql_file);

        return $main_sql_data_query;
    }
    catch (Exception $e){
        return ("Error: " . $e->getMessage());
    }
}

function render_admin_message( $output_message_type, $output_message ){
    if( !is_null( $output_message_type ) ){
        switch ( $output_message_type ) {
            case "success" : 
                printf( '<div class="notice notice-success is-dismissible"><p>Success: %s</p></div>', esc_html( $output_message ) );
                break;
            case "warning" : 
                printf( '<div class="notice notice-warning is-dismissible"><p>Warning: %s</p></div>', esc_html( $output_message ) );
                break;
            case "error" : 
                printf( '<div class="notice notice-error is-dismissible"><p>Error: %s</p></div>', esc_html( $output_message ) );
                break;
        }
    }
}

function get_current_total_sites(){

    $sitesCount = -1;

    GLOBAL $wpdb;

    $ftmdc_sites = $wpdb->prefix . "ftmdc_site";

    $site_info = $wpdb->get_results("SELECT COUNT(*) AS sitesCount FROM " . $ftmdc_sites . ";" );   

    if( sizeof( $site_info ) > 0 ){
        $sitesCount = $site_info[0]->sitesCount;        
    }              

    return $sitesCount;
}

function get_current_total_fields(){

    $fieldsCount = -1;

    GLOBAL $wpdb;

    $ftmdc_fields = $wpdb->prefix . "ftmdc_field";

    $fields_info = $wpdb->get_results("SELECT COUNT(*) AS fieldsCount FROM " . $ftmdc_fields . ";" );   

    if( sizeof( $fields_info ) > 0 ){
        $fieldsCount = $fields_info[0]->fieldsCount;        
    }              

    return $fieldsCount;
}

function get_all_sites(){
    GLOBAL $wpdb;

    $ftmdc_sites = $wpdb->prefix . "ftmdc_site";

    $sites_list = $wpdb->get_results("SELECT * FROM " . $ftmdc_sites . ";");         
                
    if( sizeof( $sites_list ) > 0 ){
       return $sites_list;
    }               
    else
    {
        return nulll;
    }
}

function list_all_field_groups(){
    $fg = new FTMDSC_FIELD_GROUP();
    return $fg->list();
}

function list_all_fields($list_type = null){
    $f = new FTMDSC_FIELD();

    if( $list_type ){
        return $f->list($list_type);
    }
    else
    {
        return $f->list();
    }
    
}

function render_custom_field($fieldType, $fieldname, $oldValue=""){
    //Remove spaces for naming
    $fieldname_id = strtolower( str_replace( " ", "_", $fieldname ) );

    if(strtolower($fieldType) == "text"){
        $html = '';
        $html .= '<div class="row">';
        $html .= '<div class="form_field">';
        $html .= '<label for="'.$fieldname_id.'">'.$fieldname.':</label>';
        //$html .= '<input id="'.$fieldname_id.'" name="'.$fieldname_id.'" type="text" value="'.  $oldValue . '"  required data-pristine-required-message="The '.$fieldname.' Required"/>';
        $html .= '<input id="'.$fieldname_id.'" name="'.$fieldname_id.'" type="text" value="'.  $oldValue . '"/>';
        $html .= '</div>';
        $html .= '</div>';
        echo $html;
        
    }elseif(strtolower($fieldType) == "number"){
        $html = '';
        $html .= '<div class="row">';
        $html .= '<div class="form_field">';
        $html .= '<label for="'.$fieldname_id.'">'.$fieldname.':</label>';
        $html .= '<input id="'.$fieldname_id.'" name="'.$fieldname_id.'" type="number" value="'.  $oldValue . '"  data-pristine-required-message="The '.$fieldname.' must be a number"/>';
        $html .= '</div>';
        $html .= '</div>';
        echo $html;
        
    }elseif (strtolower($fieldType) == "media"){
        $control_id = rand();
        $html = '';
        $html .= '<div class="row">';
        $html .= '<div class="form_field">';
        $html .= '<label for="">'.$fieldname.':</label>';
        $html .= '<div>';
        $html .= '<input id="'. $fieldname_id .'" type="text" size="70" class="upload_image" name="' . $fieldname_id . '" value="' . $oldValue .'" />';
        $html .= '<input id="upload_'. $control_id .'_image_button" data-upload-field="'.$fieldname_id.'" class="upload_image_button" type="button" value="Upload Image" />';
        $html .= '</div>';
        $html .= '</div>'; 
        $html .= '</div>';
        
        echo $html;

    }elseif (strtolower($fieldType) == "wysiwyg"){
        $html = '';
        $html .= '<div class="row">';
        $html .= '<div class="form_field">';
        $html .= '<label for="'.$fieldname_id.'">'.$fieldname.':</label>';        
        echo $html;
        $content = $oldValue;//$content = get_option($oldValue);
        wp_editor( stripslashes($content), $fieldname_id, array( 'theme_advanced_buttons1' => 'bold, italic, ul, pH, pH_min', "media_buttons" => true, "textarea_rows" => 8, "tabindex" => 4 ) ); 
        $html =  '</div>';
        $html .= '</div>';
        echo $html;
    }elseif (strtolower($fieldType) == "boolean"){

        $check_value = "";
        if( $oldValue == "on" ){
            $check_value = "checked";
        }

        $html = '';
        $html .= '<div class="row">';
        $html .= '<div class="form_field">';
        $html .= '<label for="'.$fieldname_id.'">'.$fieldname.':</label>';
        $html .= '<input id="'.$fieldname_id.'" name="'.$fieldname_id.'" type="checkbox" '.$check_value.' />';
        $html .= '</div>';
        $html .= '</div>';
        echo $html;               
    }

}