CREATE TABLE ftmdc_site (
	siteID INT NOT NULL AUTO_INCREMENT UNIQUE,
	siteName VARCHAR(255) NOT NULL,
	siteAffiliateUrl VARCHAR(255) NOT NULL,
	siteLogo VARCHAR(255) NULL,
	siteMemberships VARCHAR(500) NULL,
	siteTotalMembers INT NULL,
	siteActiveMembers INT NULL,
	siteFreeTrial INT NULL,
	PRIMARY KEY(siteID)
);

CREATE TABLE ftmdc_field_group (
	fieldGroupID INT NOT NULL AUTO_INCREMENT,
	fieldGroupName VARCHAR(255) NOT NULL,	
	PRIMARY KEY(fieldGroupID)
);

INSERT INTO ftmdc_field_group (fieldGroupName)
VALUES('General');

CREATE TABLE ftmdc_field (
	fieldID INT NOT NULL AUTO_INCREMENT UNIQUE,
	fieldGroupID INT NOT NULL,
	fieldName VARCHAR(255) NOT NULL,	
	fieldType VARCHAR(255) NOT NULL,	
	fieldDefaultValue VARCHAR(255) NULL,	
	fieldRestrictions VARCHAR(500) NULL,
	PRIMARY KEY(fieldID),
	FOREIGN KEY (fieldGroupID) REFERENCES ftmdc_field_group (fieldGroupID)
);

CREATE TABLE ftmdc_site_fields (
	siteID INT NOT NULL,
	fieldID INT NOT NULL,
	sfValue NVARCHAR(255) NOT NULL
);


ALTER TABLE IF EXISTS ftmdc_site_fields 
  	ADD CONSTRAINT ftmdc_site_sf_fk
    FOREIGN KEY (siteID) REFERENCES ftmdc_site (siteID)	
    ON DELETE CASCADE
    ON UPDATE RESTRICT,
	ADD CONSTRAINT ftmdc_field_sf_fk
    FOREIGN KEY (fieldID) REFERENCES ftmdc_field (fieldID)
    ON DELETE CASCADE
    ON UPDATE RESTRICT;
    
    