<?php

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) exit;
/**
 * Class FTMDSC_FIELD_GROUP
 *
 *
 *
 * @package		FTMDSC
 * @subpackage	Classes/Ftm_Dating_Center_Field_Group
 * @author		FTMedia
 * @since		1.0.0
 */

class FTMDSC_FIELD_GROUP
{
	private $groupID;
	private $groupName;
	private $tableName = "ftmdc_field_group";

	public function __construct()
	{
	}

	public function setGroupID($groupID)
	{
		$this->groupID = $groupID;
	}

	public function getGroupID()
	{
		return $this->groupID;
	}

	public function setGroupName($groupName)
	{
		$this->groupName = $groupName;
	}

	public function getGroupName()
	{
		return $this->groupName;
	}

	public function read()
	{
		try
		{
            $groupID = $this->getGroupID();

            if( $groupID > 0 ){
                GLOBAL $wpdb;

                $ftmdc_groups = $wpdb->prefix . $this->tableName;
            
                $group_info = $wpdb->get_results("SELECT * FROM " . $ftmdc_groups . " WHERE fieldGroupID = " . $groupID );         
                            
                if( sizeof( $group_info ) > 0 ){
                    $this->setGroupName( $group_info[0]->groupName );
                    return true;
                }               
                else
                {
                    return false;
                } 
            }  
            else
            {
                return null;
            }          
		}
		catch(Exception $exception)
		{
			return $exception->getMessage();
		}
	}

	public function update()
	{
		try
		{
            global $wpdb;
            $ftmdc_groups = $wpdb->prefix . $this->tableName;

            $update = $wpdb->update($ftmdc_groups,
            array(
                'fieldGroupName'  => $this->getGroupName()
            ),
            array ('fieldGroupID' =>  $this->getGroupID()),
            array(
                '%s'
            )
        );

            if($update !== false){
                $result = true;             
            }else{
                $result = false;            
            }

            return $result;

		}
		catch(Exception $exception)
		{
            return $exception->getMessage();
		}
	}

	public function delete()
	{
		try
		{		
        }
		catch(Exception $exception)
		{
			echo $exception->getMessage();
		}
	}

	public function list(){
		
		GLOBAL $wpdb;

		$ftmdc_field_groups = $wpdb->prefix . $this->tableName;


		$ftmdc_field_groups_list = $wpdb->get_results("SELECT * FROM " . $ftmdc_field_groups . ";");
					
		if( sizeof( $ftmdc_field_groups_list ) > 0 ){
		return $ftmdc_field_groups_list;
		}               
		else
		{
			return nulll;
		}
	}
}