<?php 
 global $wpdb;

 $result = null;
 $output_message = "";
 $output_message_type = null;
 $fieldID = null;
 $field =  new FTMDSC_FIELD();
 

 if( isset( $_REQUEST["fieldID"] ) ){
    $fieldID = intval( $_REQUEST["fieldID"] );

    if( $fieldID <= 0 ){
        $output_message = "No Field ID provided, please go back to the Fields List";
        $output_message_type = "error";
    }
 }

 if( $fieldID > 0 ){    
 
    $field->setFieldID($fieldID);
    $field_data_loaded = $field->read();
    if( is_null( $field_data_loaded ) || ($field_data_loaded == false) ){
        $output_message = "The Field ID was provided, but no data was loaded, please contact support";
        $output_message_type = "error";
    }
}

 //POSTBACK
 if( sizeof( $_POST ) > 0 ){ 

    if ( isset( $_POST["field_name"] ) && strlen( $_POST['field_name'] ) > 0 
      && isset( $_POST['field_type'] ) && strlen( $_POST['field_type'] ) > 0
      && isset( $_POST['field_group_id'] ) && strlen( $_POST['field_group_id'] ) > 0 ){

        $field->setFieldName( $_POST["field_name"] );
        $field->setFieldGroupID( $_POST["field_group_id"] );
        $field->setFieldType( $_POST["field_type"] );
        $field->setFieldDefaultvalue( $_POST["field_default_value"] ); 
        $field->setFieldRestrictions( isset( $_POST['field_restrictions'] )?$_POST[ 'field_restrictions']:'' );

        $update_result = $field->update();

        if($update_result == true){            
            $output_message_type = "success";
            $output_message = "The Field was succesfully updated!";
        }
        else
        {
            $output_message_type = "error";
            $output_message = "There was an error updating the Field, please contact support";
        }
    }
    else
    {
        $output_message_type = "error";
        $output_message = "Invalid field(s) input value, please check the data before submitting.";
    }
}

?>



<?php render_admin_message( $output_message_type, $output_message );?>


<div id="ftmdc-wrapper">
    <div class="ftmdc-top">        
        <div style="text-align:left;">
            <h1>Edit a Dynamic Field</h1>    
            <a href="admin.php?page=ftm-dating-center-dynamic-fields" class="btn btn-success">Back to Fields List</a>
        </div>         
    </div>    
    <br/>
    <div>       
        <form id="field_edit_form" method="post" novalidate action="" name="field_edit_form">
            <div class="row">
                <div class="form_field form-group">
                    <label for="field_name">Field Name:</label>
                    <input id="field_name" name="field_name" type="text" value="<?php echo $field->getFieldName(); ?>" />
                </div>                                          
            </div>
            <div class="row">
            <div class="form_field form-group">
                    <?php $field_type = $field->getFieldType(); ?>
                    <label for="field_type">Field Type:</label>
                    <select id="field_type" name="field_type">
                        <option <?php echo ( ( $field_type == "text"? "selected":"" ) ); ?> value="text">Text</option>
                        <option <?php echo ( ( $field_type == "media"? "selected":"" ) ); ?> value="media">Media Gallery</option>
                        <option <?php echo ( ( $field_type == "WYSIWYG"? "selected":"" ) ); ?> value="WYSIWYG">WYSIWIG Editor</option>
                        <option <?php echo ( ( $field_type == "boolean"? "selected":"" ) ); ?> value="boolean">Yes/No</option>
                        <option <?php echo ( ( $field_type == "number"? "selected":"" ) ); ?> value="number">Number</option>
                    </select>
                </div> 
            </div>
            <div class="row">
                <div class="form_field form-group">
                    <label for="field_default_value">Default Value:</label>
                    <input id="field_default_value" name="field_default_value" type="text" value="<?php echo $field->getFieldDefaultValue(); ?>" />
                </div>                                          
            </div>
            <div class="row">
                <div class="form_field form-group">
                    <label for="field_group_id">Field Group:</label>
                    <select id="field_group_id" name="field_group_id" type="text">
                        <?php 
                          $groups = list_all_field_groups();
                          
                          if( !is_null($groups) ){
                            foreach($groups as $group){
                                if( $group->fieldGroupName == "General" ){
                                    echo '<option value="' . $group->fieldGroupID . '" selected>'. $group->fieldGroupName . '</option>';
                                }                                
                                else
                                {
                                    echo '<option value="' . $group->fieldGroupID . '" >'. $group->fieldGroupName . '</option>';
                                }
                            }
                         }
                        ?>
                    </select>
                </div>      
            </div>
            <div class="row">
                <div class="form_field form-group buttons">
                    <button class="btn btn-success" type="submit" form="field_edit_form">Edit Field</button>
                </div> 
            </div>     
        </form> 
    </div>
</div>
