<?php

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) exit;

/**
 * Class Ftm_Dating_Sites_Center_Settings
 *
 * This class contains all of the plugin settings.
 * Here you can configure the whole plugin data.
 *
 * @package		FTMDSC
 * @subpackage	Classes/Ftm_Dating_Sites_Center_Settings
 * @author		FTMedia
 * @since		1.0.0
 */
class Ftm_Dating_Sites_Center_Settings{

	/**
	 * The plugin name
	 *
	 * @var		string
	 * @since   1.0.0
	 */
	private $plugin_name;

	/**
	 * The plugin capabilities
	 *
	 * @var		array
	 * @since	1.0.0
	 */
	private $capabilities;

	/**
	 * Our Ftm_Dating_Sites_Center_Settings constructor 
	 * to run the plugin logic.
	 *
	 * @since 1.0.0
	 */
	function __construct(){

		$this->plugin_name = FTMDSC_NAME;
		$this->capabilities = array(
			'default' => 'manage_options',
		);
	}

	/**
	 * ######################
	 * ###
	 * #### CALLABLE FUNCTIONS
	 * ###
	 * ######################
	 */

	/**
	 * Return the plugin name
	 *
	 * @access	public
	 * @since	1.0.0
	 * @return	string The plugin name
	 */
	public function get_plugin_name(){
		return apply_filters( 'FTMDSC/settings/get_plugin_name', $this->plugin_name );
	}

	/**
	 * Return the specified plugin capability
	 *
	 * @access	public
	 * @since	1.0.0
	 * @return	string The chosen capability
	 */
	public function get_capability( $identifier = 'default' ) {

		$capability = $this->capabilities[ 'default' ];
		if( ! empty( $identifier ) && isset( $this->capabilities[ $identifier ] ) ){
			$capability = $this->capabilities[ $identifier ];
		}

		return apply_filters( 'FTMDSC/settings/get_capability', $capability, $identifier, $this->capabilities );
	}

}
