/*------------------------ 
Backend related javascript
------------------------*/

jQuery(document).ready(function($){
    //WP MEDIA UPLOAD CONSOLE
    $('#upload-btn').click(function(e) {
        e.preventDefault();
        var image = wp.media({ 
            title: 'Upload Image',
            // mutiple: true if you want to upload multiple files at once
            multiple: false
        }).open()
        .on('select', function(e){
            // This will return the selected image from the Media Uploader, the result is an object
            var uploaded_image = image.state().get('selection').first();
            // We convert uploaded_image to a JSON object to make accessing it easier
            // Output to the console uploaded_image
            //console.log(uploaded_image);
            var image_url = uploaded_image.toJSON().url;
            // Let's assign the url value to the input field
            $('#image_url').val(image_url);
        });
    });

    $('.upload_image_button').click(function(e) { //FOR DYNAMIC FIELDS
        e.preventDefault();
        var trigger =  $(this);
        var image = wp.media({ 
            title: 'Upload Image',
            // mutiple: true if you want to upload multiple files at once
            multiple: false
        }).open()
        .on('select', function(e){
            // This will return the selected image from the Media Uploader, the result is an object
            var uploaded_image = image.state().get('selection').first();
            // We convert uploaded_image to a JSON object to make accessing it easier
            // Output to the console uploaded_image
            //console.log(uploaded_image);
            var image_url = uploaded_image.toJSON().url;
            // Let's assign the url value to the input field
            $('#'+ $(trigger).attr('data-upload-field')).val(image_url);
        });
    });


    //Site Memberships Add button
    $('#btn_membership_add').click(function(e){        
        var membership_name = "";
        var membership_price = "";
        var membership_features = "";
        var memberships_list_field = $('#site_memberships_list');
        var proper_action = "insert";

        if($('#site_membership_name').length > 0){

            var form = document.getElementById("site_edit_form");
            var pristine = new Pristine(form,{
                errorClass: 'has-danger',
                successClass: 'has-success',
                errorTextParent: 'form-group',
                errorTextTag: 'div',
                errorTextClass: 'text-help'
            },false);

            pristine.addValidator(document.getElementById('site_membership_name'), function(value, el) {
                var validation_result = true;

                if (value.length == 0){
                   validation_result = false;
                }                            

                $('#site_memberships_list_container > .membership_item').each(function(){
                    item_values = $(this).attr("data-text");                    
                    if(item_values != ""){
                        jsonValue =  JSON.parse(item_values);
                        if(jsonValue.membership_name == value && validation_result == true){
                            if( confirm("Would you like to update the existing values for the "+ jsonValue.membership_name +" Membership?") ){                                
                                validation_result = true;
                                proper_action = "update";
                            }
                            else
                            {
                                validation_result = false;
                            }                            
                        }
                    }
                });

                return validation_result;
             }, "The Membership Name is required or already exist on the list", 2, false);

            var valid = pristine.validate();
             
            if(valid == false){
                pristine.getErrors();
                e.preventDefault();
                return;
            }

            membership_name = $('#site_membership_name').val();
            membership_price = $('#site_membership_price').val();
            membership_features = tinymce.editors['site_membership_features'].getContent();
    
            newJsonNode = {membership_name : membership_name , membership_price : membership_price , membership_features : membership_features };
        
            if( proper_action == "update" ){ 
                memberships_list_field.val( JSON.stringify( update_json_data( memberships_list_field.val(), newJsonNode ) ) );
            }
            else
            {
                memberships_list_field.val( JSON.stringify( add_data_to_json( memberships_list_field.val(), newJsonNode ) ) );
            }            
            
            jsonToHtml( memberships_list_field.val() );

            //Clean the fields
            $('#site_membership_name').val("");
            $('#site_membership_price').val("");
            tinymce.editors['site_membership_features'].setContent('');


        }
        else{
            //console.log('values not found');
        }

        
    });

    function add_data_to_json(initialData, newNode){
        var jsonObj;
        if(initialData != ""){
            jsonObj = JSON.parse(initialData);
            jsonObj.memberships.push(newNode);
        }
        else
        {
            jsonObj = JSON.parse( '{ "memberships" : [] }' );
            jsonObj.memberships.push(newNode);
        }

        return jsonObj;
    }

    function update_json_data(initialData, newNode){
        var currentJson = JSON.parse(initialData);

        for (var i = 0; i < currentJson.memberships.length; i++) {
            if (currentJson.memberships[i].membership_name === newNode.membership_name) {           
                currentJson.memberships[i].membership_price = newNode.membership_price;
                currentJson.memberships[i].membership_features = newNode.membership_features;
                break;
            }
        }

        return currentJson;
    }

    function jsonToHtml(jsonData = null){

        if (typeof jsonData == null) {
            return;
        }

        jsonData = JSON.parse(jsonData);
        //clean the container first
        var site_memberships_list_container = $('#site_memberships_list_container');
        site_memberships_list_container.html("");

        if(jsonData.memberships.length > 0){
            $.each(jsonData.memberships, function(i, val) {                
                var parent_container = '<div class="membership_item" data-text=\''+ JSON.stringify( val)  +'\'>';
                var membership_name = '<div class="membership_name">' + val.membership_name + '</div>';
                var membership_price = '<div class="membership_price">' + val.membership_price + '</div>';
                var membership_features = '<div class="membership_features">' + val.membership_features + '</div>';
                var membership_actions = '';
                
                membership_actions = '<div class="membership_actions">';
                membership_actions += '<a class="edit" onclick="edit_site_membership_item( this );"><i class="fa fa-edit"></i></a>';
                membership_actions += '<a class="delete" onclick="remove_site_membership_item( this );"><i class="fa fa-trash"></i></a>';
                membership_actions += '</div>';
                
                parent_container +=  membership_name + membership_price + membership_features + membership_actions + '</div>';
                site_memberships_list_container.append(parent_container);
            });
        }        
    }

    //Run when page is loaded and ready (page load)
    if($('#site_membership_name').length > 0){
        var memberships_list_field = $('#site_memberships_list');
        jsonToHtml( memberships_list_field.val() );
    }

    $(".sortable_list" ).sortable({
        update: function(event, ui){
            set_list_values_output('site_memberships_list_container', 'site_memberships_list');
        }
    });

    if($('#sites_home_list').length > 0){
        $('#sites_home_list').DataTable({
            columnDefs: [
                {
                    targets: [0,1,2,3],
                    className: 'dt-body-center'
                }
            ]
        });
    }

    if($('#site_add_form').length > 0){
        var form = document.getElementById("site_add_form");
        var pristineObj = new Pristine(form,{
            errorClass: 'has-danger',
            successClass: 'has-success',
            errorTextParent: 'form-group',
            errorTextTag: 'div',
            errorTextClass: 'text-help'
        },false);

        form.addEventListener('submit', function (e) {            
            var valid = pristineObj.validate();
            pristineObj.getErrors();

            if(valid == false){
                e.preventDefault();            
            }
        });
    }

    if($('#site_edit_form').length > 0){
        var form = document.getElementById("site_edit_form");
        var pristine = new Pristine(form,{
            errorClass: 'has-danger',
            successClass: 'has-success',
            errorTextParent: 'form-group',
            errorTextTag: 'div',
            errorTextClass: 'text-help'
        },false);        

        form.addEventListener('submit', function (e) {
            var valid = pristine.validate();

            pristineObj.getErrors();

            if(valid == false){
                e.preventDefault();            
            }
        });
    }
    
    if($('#field_add_form').length > 0){
        var form = document.getElementById("field_add_form");
        var pristineObj = new Pristine(form,{
            errorClass: 'has-danger',
            successClass: 'has-success',
            errorTextParent: 'form-group',
            errorTextTag: 'div',
            errorTextClass: 'text-help'
        },false);

        form.addEventListener('submit', function (e) {            
            var valid = pristineObj.validate();
            pristineObj.getErrors();

            if(valid == false){
                e.preventDefault();            
            }
        });
    }
    
});

function remove_site_membership_item( handler ){
    jQuery(handler).parent().parent().detach();
    set_list_values_output('site_memberships_list_container', 'site_memberships_list');
}

function edit_site_membership_item( handler ){
    var membership_item = jQuery(handler).parent().parent();


    jQuery('#site_membership_name').val( membership_item.find(".membership_name").html() );
    jQuery('#site_membership_price').val( membership_item.find(".membership_price").html() );
    tinymce.editors['site_membership_features'].setContent( membership_item.find(".membership_features").html() );
}

function set_list_values_output(container, source){
    var values;

    values = "";
    jQuery('#' + container + ' .membership_item').each(function(){
        values += jQuery(this).attr("data-text") + ",";
    });

    values = values.replace(/.$/,"");
    jQuery('#' + source).val( '{ "memberships" : [' + values + '] }' );
}