<?php

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) exit;
/**
 * Class FTMDSC_SITE
 *
 * Thats where we bring the plugin to life
 *
 * @package		FTMDSC
 * @subpackage	Classes/Ftm_Dating_Center_Sites
 * @author		FTMedia
 * @since		1.0.0
 */

class FTMDSC_SITE
{
	private $siteID;
	private $siteName;
	private $siteAffiliateUrl;
	private $siteLogo;
    private $siteMemberships;
	private $siteTotalMembers;
	private $siteActiveMembers;
	private $siteFreeTrial;
	private $siteFields = null;
	private $tableName = "ftmdc_site";

	public function __construct()
	{
	}

	public function setSiteID($siteID)
	{
		$this->siteID = $siteID;
	}

	public function getSiteID()
	{
		return $this->siteID;
	}

	public function setSiteName($siteName)
	{
		$this->siteName = $siteName;
	}

	public function getSiteName()
	{
		return $this->siteName;
	}

	public function setSiteAffiliateUrl($siteAffiliateUrl)
	{
		$this->siteAffiliateUrl = $siteAffiliateUrl;
	}

	public function getSiteAffiliateUrl()
	{
		return $this->siteAffiliateUrl;
	}

	public function setSiteLogo($siteLogo)
	{
		$this->siteLogo = $siteLogo;
	}

	public function getSiteLogo()
	{
		return $this->siteLogo;
	}

	public function setSiteTotalMembers($siteTotalMembers)
	{
		$this->siteTotalMembers = $siteTotalMembers;
	}

    public function getSiteMemberships()
	{
		return str_replace( '\\', '', $this->siteMemberships );
	}

	public function setSiteMemberships($siteMemberships)
	{
		$this->siteMemberships = $siteMemberships;
	}

	public function getSiteTotalMembers()
	{
		return $this->siteTotalMembers;
	}

	public function setSiteActiveMembers($siteActiveMembers)
	{
		$this->siteActiveMembers = $siteActiveMembers;
	}

	public function getSiteActiveMembers()
	{
		return $this->siteActiveMembers;
	}

	public function setSiteFreeTrial($siteFreeTrial)
	{
		$this->siteFreeTrial = $siteFreeTrial;
	}

	public function getSiteFreeTrial()
	{
		return $this->siteFreeTrial;
	}

	public function getSiteFields(){
		return $this->siteFields;
	}


	public function read($site_name = null)
	{
		try
		{
			GLOBAL $wpdb;
			$ftmdc_sites = $wpdb->prefix . $this->tableName;
		
			if( ! is_null( $site_name ) ){
				$site_info = $wpdb->get_results("SELECT siteID FROM " . $ftmdc_sites . " WHERE siteName like '" . $site_name . "'" );   
				if( sizeof( $site_info ) > 0 ){					
					$this->setSiteID( $site_info[0]->siteID );
				}      
			}

            if( $this->getSiteID() > 0 ){                                
            			
				$site_info = $wpdb->get_results("SELECT * FROM " . $ftmdc_sites . " WHERE siteid = " . $this->getSiteID() );                     			
                            
                if( sizeof( $site_info ) > 0 ){

					$ftmdc_site_fields = $wpdb->prefix . "ftmdc_site_fields";
					$ftmdc_fields = $wpdb->prefix . "ftmdc_field";
					$site_fields_list = $wpdb->get_results("SELECT sf.*, f.`fieldName`, f.`fieldRestrictions`, f.`fieldType` FROM ".$ftmdc_site_fields." as sf INNER JOIN ".$ftmdc_fields." as f ON sf.`fieldID` = f.`fieldID` WHERE sf.`siteID` = " . $this->getSiteID() );


                    $this->setSiteName( $site_info[0]->siteName );
                    $this->setSiteAffiliateUrl( $site_info[0]->siteAffiliateUrl );
                    $this->setSiteLogo( $site_info[0]->siteLogo );
                    $this->setSiteMemberships( $site_info[0]->siteMemberships );
                    $this->setSiteTotalMembers( $site_info[0]->siteTotalMembers );
                    $this->setSiteActiveMembers( $site_info[0]->siteActiveMembers );
					$this->siteFields = $site_fields_list;

                    if( $site_info[0]->siteFreeTrial == "1" ){
                        $this->setSiteFreeTrial( true );
                    }
                    else
                    {
                        $this->setSiteFreeTrial( false );
                    }
                    return true;
                }               
                else
                {
                    return false;
                } 
            }  
            else
            {
                return null;
            }          
		}
		catch(Exception $exception)
		{
			return $exception->getMessage();
		}
	}

	public function update()
	{
		try
		{
            global $wpdb;
            $ftmdc_sites = $wpdb->prefix . $this->tableName;

            $update = $wpdb->update($ftmdc_sites,
            array(
                'siteName' 		   => $this->getSiteName(),
                'siteAffiliateUrl' => $this->getSiteAffiliateUrl(),
                'siteLogo'         => $this->getSiteLogo(),
                'siteMemberships'  => $this->getSiteMemberships(),
                'siteTotalMembers' => $this->getSiteTotalMembers(),
                'siteActiveMembers'=> $this->getSiteActiveMembers(),
                'siteFreeTrial'    => $this->getSiteFreeTrial()
            ),
            array ('siteID' =>  $this->getSiteID()),
            array(
                '%s',
                '%s',
                '%s',
                '%s',
                '%s',
                '%s',
                '%s'
            )
        );

            if($update !== false){
                $result = true;
            }else{
                $result = false;            
            }

            return $result;

		}
		catch(Exception $exception)
		{
            return $exception->getMessage();
		}
	}

	public function delete()
	{
		global $wpdb;
        $ftmdc_sites = $wpdb->prefix . $this->tableName;
        $ftmdc_site_fields = $wpdb->prefix . "ftmdc_site_fields";
        $result = false;

		try
		{	
            
            $delete_result = $wpdb->delete(
                $ftmdc_site_fields, 
                ['siteID' => $this->getSiteID()],  	
                ['%d'], 						
            );

            if($delete_result !== false){
                if( $delete_result > 0 ){
                    $result = true;
                }                
            }else{
                $result = false;            
            }            

            if( $result ){
                $delete_result = $wpdb->delete(
                    $ftmdc_sites, 
                    ['siteID' => $this->getSiteID()],  	
                    ['%d'], 						
                );
    
                if($delete_result !== false){
                    $result = true;
                }else{
                    $result = false;            
                }  
            }             

            return $result;            
        }
		catch(Exception $exception)
		{
			echo $exception->getMessage();
		}
	}

	public function save_field($fieldID, $fieldValue){
		GLOBAL $wpdb;
		$result = null;

		$ftmdc_site_fields = $wpdb->prefix . "ftmdc_site_fields";

		$site_field_info = $wpdb->get_results("SELECT * FROM " . $ftmdc_site_fields . " WHERE siteID = " . $this->getSiteID() . " AND  fieldID = " . $fieldID );         
                            
		if( sizeof( $site_field_info ) > 0 ){ // The value must be updated
			try
			{	
				$update = $wpdb->update($ftmdc_site_fields,
				array(
					'siteID'         => ( $this->getSiteID() ),
					'fieldID'        => ( $fieldID ),
					'sfValue' 		 => ( $fieldValue )
				),
				array (
					'siteID'  =>  $this->getSiteID(),
					'fieldID' =>  $fieldID ),
				array(
					'%d',
					'%d',
					'%s'
				)
				);
	
				if( $update >= 0 ){
					$result = true;
				}else{
					$result = false;            
				}	
			}
			catch(Exception $exception)
			{
				return $exception->getMessage();
			}
		}
		else // The value must be inserted
		{
			try{
				$insert_check = $wpdb->insert($ftmdc_site_fields,
					array(
						'siteID'         => ( $this->getSiteID() ),
						'fieldID'        => ( $fieldID ),
						'sfValue' 		 => ( $fieldValue )
					),
					array(
						'%d',
						'%d',
						'%s'
					)
				);
	
	
				if($insert_check){
					$result = true;                    
				}
				else
				{
					$result = false;
				}
			}
			catch(Exception $exception)
			{
				return $exception->getMessage();
			}
		}

		return $result;
	}

	
}