<?php
/**
 * Dating Sites Center
 *
 * @package       FTMDSC
 * @author        FTMedia
 * @version       1.0.4.6
 *
 * @wordpress-plugin
 * Plugin Name:   Dating Sites Center
 * Plugin URI:    https://www.ftmedia.com
 * Description:   Dating Sites Information Center
 * Version:       1.0.4.6
 * Author:        FTMedia
 * Author URI:    https://www.ftmedia.com
 * Text Domain:   ftm-dating-sites-center
 * Domain Path:   /languages
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) exit;
// Plugin name
define( 'FTMDSC_NAME',			'Dating Sites Center' );

// Plugin version
define( 'FTMDSC_VERSION',		'1.0.4.6' );

// Plugin DB version
define( 'FTMDSC_DB_VERSION',	'1.0.0' );

// Plugin Root File
define( 'FTMDSC_PLUGIN_FILE',	__FILE__ );

// Plugin base
define( 'FTMDSC_PLUGIN_BASE',	plugin_basename( FTMDSC_PLUGIN_FILE ) );

// Plugin Folder Path
define( 'FTMDSC_PLUGIN_DIR',	plugin_dir_path( FTMDSC_PLUGIN_FILE ) );

// Plugin Folder URL
define( 'FTMDSC_PLUGIN_URL',	plugin_dir_url( FTMDSC_PLUGIN_FILE ) );

/**
 * Load the main class for the core functionality
 */
require_once FTMDSC_PLUGIN_DIR . 'core/class-ftm-dating-sites-center.php';

/**
 * The main function to load the only instance
 * of our master class.
 *
 * @author  FTMedia
 * @since   1.0.0
 * @return  object|Ftm_Dating_Sites_Center
 */
function FTMDSC() {
	return Ftm_Dating_Sites_Center::instance();
}

FTMDSC();


//PLUGIN UTILITY METHODS
function read_sql_file($filename){
    try {
        $main_sql_data_file = FTMDSC_PLUGIN_DIR . '/sql_files/' . $filename;
        $sql_file = fopen($main_sql_data_file, "r");
        $main_sql_data_query = fread($sql_file, filesize($main_sql_data_file));
        fclose($sql_file);

        return $main_sql_data_query;
    }
    catch (Exception $e){
        return ("Error: " . $e->getMessage());
    }
}

function render_admin_message( $output_message_type, $output_message ){
    if( !is_null( $output_message_type ) ){
        switch ( $output_message_type ) {
            case "success" : 
                printf( '<div class="notice notice-success is-dismissible"><p>Success: %s</p></div>', esc_html( $output_message ) );
                break;
            case "warning" : 
                printf( '<div class="notice notice-warning is-dismissible"><p>Warning: %s</p></div>', esc_html( $output_message ) );
                break;
            case "error" : 
                printf( '<div class="notice notice-error is-dismissible"><p>Error: %s</p></div>', esc_html( $output_message ) );
                break;
        }
    }
}

function get_current_total_sites(){

    $sitesCount = -1;

    GLOBAL $wpdb;

    $ftmdc_sites = $wpdb->prefix . "ftmdc_site";

    $site_info = $wpdb->get_results("SELECT COUNT(*) AS sitesCount FROM " . $ftmdc_sites . ";" );   

    if( sizeof( $site_info ) > 0 ){
        $sitesCount = $site_info[0]->sitesCount;        
    }              

    return $sitesCount;
}

function get_current_total_fields(){

    $fieldsCount = -1;

    GLOBAL $wpdb;

    $ftmdc_fields = $wpdb->prefix . "ftmdc_field";

    $fields_info = $wpdb->get_results("SELECT COUNT(*) AS fieldsCount FROM " . $ftmdc_fields . ";" );   

    if( sizeof( $fields_info ) > 0 ){
        $fieldsCount = $fields_info[0]->fieldsCount;        
    }              

    return $fieldsCount;
}

function get_all_sites(){
    GLOBAL $wpdb;

    $ftmdc_sites = $wpdb->prefix . "ftmdc_site";

    $sites_list = $wpdb->get_results("SELECT * FROM " . $ftmdc_sites . ";");         
                
    if( sizeof( $sites_list ) > 0 ){
       return $sites_list;
    }               
    else
    {
        return nulll;
    }
}

function list_all_field_groups(){
    $fg = new FTMDSC_FIELD_GROUP();
    return $fg->list();
}

function list_all_fields($list_type = null){
    $f = new FTMDSC_FIELD();

    if( $list_type ){
        return $f->list($list_type);
    }
    else
    {
        return $f->list();
    }
    
}

function render_custom_field($fieldType, $fieldname, $oldValue=""){
    //Remove spaces for naming
    $fieldname_id = strtolower( str_replace( " ", "_", $fieldname ) );

    if(strtolower($fieldType) == "text"){
        $html = '';
        $html .= '<div class="row">';
        $html .= '<div class="form_field">';
        $html .= '<label for="'.$fieldname_id.'">'.$fieldname.':</label>';
        //$html .= '<input id="'.$fieldname_id.'" name="'.$fieldname_id.'" type="text" value="'.  $oldValue . '"  required data-pristine-required-message="The '.$fieldname.' Required"/>';
        $html .= '<input id="'.$fieldname_id.'" name="'.$fieldname_id.'" type="text" value="'.  $oldValue . '"/>';
        $html .= '</div>';
        $html .= '</div>';
        echo $html;
        
    }elseif(strtolower($fieldType) == "number"){
        $html = '';
        $html .= '<div class="row">';
        $html .= '<div class="form_field">';
        $html .= '<label for="'.$fieldname_id.'">'.$fieldname.':</label>';
        $html .= '<input id="'.$fieldname_id.'" name="'.$fieldname_id.'" type="number" value="'.  $oldValue . '"  data-pristine-required-message="The '.$fieldname.' must be a number"/>';
        $html .= '</div>';
        $html .= '</div>';
        echo $html;
        
    }elseif (strtolower($fieldType) == "media"){
        $control_id = rand();
        $html = '';
        $html .= '<div class="row">';
        $html .= '<div class="form_field">';
        $html .= '<label for="">'.$fieldname.':</label>';
        $html .= '<div>';
        $html .= '<input id="'. $fieldname_id .'" type="text" size="70" class="upload_image" name="' . $fieldname_id . '" value="' . $oldValue .'" />';
        $html .= '<input id="upload_'. $control_id .'_image_button" data-upload-field="'.$fieldname_id.'" class="upload_image_button" type="button" value="Upload Image" />';
        $html .= '</div>';
        $html .= '</div>'; 
        $html .= '</div>';
        
        echo $html;

    }elseif (strtolower($fieldType) == "wysiwyg"){
        $html = '';
        $html .= '<div class="row">';
        $html .= '<div class="form_field">';
        $html .= '<label for="'.$fieldname_id.'">'.$fieldname.':</label>';        
        echo $html;
        $content = $oldValue;//$content = get_option($oldValue);
        wp_editor( stripslashes($content), $fieldname_id, array( 'theme_advanced_buttons1' => 'bold, italic, ul, pH, pH_min', "media_buttons" => true, "textarea_rows" => 8, "tabindex" => 4 ) ); 
        $html =  '</div>';
        $html .= '</div>';
        echo $html;
    }elseif (strtolower($fieldType) == "boolean"){

        $check_value = "";
        if( $oldValue == "on" ){
            $check_value = "checked";
        }

        $html = '';
        $html .= '<div class="row">';
        $html .= '<div class="form_field">';
        $html .= '<label for="'.$fieldname_id.'">'.$fieldname.':</label>';
        $html .= '<input id="'.$fieldname_id.'" name="'.$fieldname_id.'" type="checkbox" '.$check_value.' />';
        $html .= '</div>';
        $html .= '</div>';
        echo $html;               
    }

}

function read_theme_render_file($theme_name, $type = 'group'){
    $theme_name = strtolower($theme_name);

    try {
        //attempt to get it from the plugin directory        
        $path = FTMDSC_PLUGIN_DIR . 'table_themes/';
        $raw_data = read_theme_render_file_from_path($theme_name, $path);
        if ($raw_data)
            return $raw_data;
        return "Error: file doesn't exists or is not readable in path: " . $path;
    }
    catch (Exception $e){
        return ("Error: " . $e->getMessage());
    }
}

function read_theme_render_file_from_path($theme_name, $path) {
    $main_theme_data_file = $path . $theme_name . '/' .$theme_name . '.php' ;
    if (file_exists($main_theme_data_file) && is_readable($main_theme_data_file)) {
        $theme_file = fopen($main_theme_data_file, "r");
        $theme_raw_contents = fread($theme_file, filesize($main_theme_data_file));
        fclose($theme_file);

        return $theme_raw_contents;
    }
    return null;
}

function theme_data_clean_empty_tags($script){
    $fields_object = new FTMDSC_FIELD();
    $all_tags = $fields_object->list();
    $matches = [];

    foreach ( $all_tags as $tag ){
        $found_common_strings = preg_match_all( '['.$tag->fieldname.']', $script, $matches );

        if(false != $found_common_strings) {
            if ($found_common_strings > 0) {
                $option_field_name = "[" . $tag->fieldname . "]";
                $script = str_replace($option_field_name, "", $script);
            }
        }
    }

    return $script;
}

function render_table($sitesGroup, $theme_name, $params = []) {
    if ( !is_array( $sitesGroup ) && count( $sitesGroup ) == 0 ) {
        return 'The sites list must be provided';
    }

    $themeData = '';

    $themeData = read_theme_render_file( $theme_name, $type );

    $script = fill_sites_data($sitesGroup, $themeData, [], false, 'group', $theme_name);

    if (strlen($script)>0) {

        if (stripos($script, '<?php') !== false) {
            //PHP RENDER FILE
            $script = str_replace("<?php", "", $script);
            $script = str_replace("?>", "", $script); // <?php
            try {
                $script = eval($script);
            } catch(Throwable $e) {
                error_log( "FTMEDIA:ERROR- Failed to evaluate template: " . $script);
                error_log($e->getMessage());
                return '<div>Error processing table!</div><!-- '.$script.' -->';
            }
        }
    }

    $script = theme_data_clean_empty_tags( $script );    

    return $script;
}

function fill_sites_data($sitesGroup, $themeData, $params = [], $process_single_site = false, $type = 'group', $theme_name) {

    $has_php_code = stripos($themeData, '<?php') !== false;
    $pattern_begin = '[SITES-REPEATER]';
    $pattern_end = '[/SITES-REPEATER]';

    // Replaces the default values in the template with the values passed on the shortcode
    foreach ($params as $placeholder => $value) {
        $themeData = preg_replace('/\['.$placeholder.'\|([^\]]+)\]/', $value, $themeData);
    }
    // If placeholders with default are still remaining, replace them with the default value
    $themeData = preg_replace('/\[[0-9a-zA-Z_ -]+\|([^\]]+)\]/', '$1', $themeData);

    $sites_html_replacement =  strstr(strstr($themeData, $pattern_begin), $pattern_end, true) . $pattern_end;
    $sites_repeat_base_html = str_replace($pattern_begin,"", strstr(strstr($themeData, $pattern_begin), $pattern_end, true));

    if (strlen($sites_repeat_base_html)) {
        $process_single_site = false;
    }

    $sites_data = process_group_data_to_array($sitesGroup, $has_php_code, $theme_name);

    if (count($sites_data) === 0)
        return '';

    $theme_root_url = FTMDSC_PLUGIN_URL . 'table_themes/' . $theme_name;
    $optionName = "[THEME_ROOT_URL]";
    $themeData = str_replace($optionName, $theme_root_url, $themeData);


    if ($process_single_site) {
        $site_data = array_shift($sites_data);
        $site_data = array_merge($params, $site_data);
        foreach ($site_data as $field_name => $value) {
            $optionName = "[" . $field_name . "]";
            $themeData = str_replace($optionName, $value, $themeData);
        }
    } else {
        foreach ($sites_data as $site_id => $site_data) {
            $site_entry = $sites_repeat_base_html;
            $site_data = array_merge($params, $site_data);
            foreach ($site_data as $field_name => $value) {
                $optionName = "[" . $field_name . "]";
                $site_entry = str_replace($optionName, $value, $site_entry);
            }
            $sites_repeat_result_html .= $site_entry;
        }
        
        $themeData = str_replace($sites_html_replacement,$sites_repeat_result_html, $themeData);
    }

    $themeData = str_replace('\"','"',$themeData); 
    return $themeData;
}

function process_group_data_to_array($sites_group, $has_php_code, $theme_name) {    
    $sites_data = [];

    //check if it's array and it's not empty
    if( !is_array( $sites_group ) ){
        return $sites_data;
    }
    elseif( sizeof( $sites_group ) <= 0 ){
        return $sites_data;
    }

    $site_count = 0;
    foreach ($sites_group as $site_name) {        
        $site = new FTMDSC_SITE();
        if( $site->read( trim( $site_name ) ) ){
            $site_count++;
            $siteID = $site->siteId;
            $site_data = process_site_data_to_array($site, $site_count, $has_php_code, $theme_name);
            //$sites_data[$siteID] = $site_data;
            $sites_data[$site_count] = $site_data;
        }        
    }
    return $sites_data;
}

function process_site_data_to_array($site, $site_count_position = 1, $has_php_code = true, $theme_name) {
    $site_data = [];

    // Site name and coun
    $site_id = $site->getSiteID();
    $site_name = $site->getSiteName();
    //Basic Site Fields    
    $site_data['SITE_NAME'] = $site_name;
    $site_data['COUNT'] = $site_count_position;      
    if( $site->getSiteMemberships() != "" ){
        $site_data["HAS_MEMBERSHIPS"] = "true";
        $site_data["SITE_MEMBERSHIPS"] = render_memberships_items( $site->getSiteMemberships() );  
    }
    else
    {
        $site_data["HAS_MEMBERSHIPS"] = "false";
        $site_data["SITE_MEMBERSHIPS"] = "";  
    }
    
    $site_data["SITE_LOGO"] = $site->getSiteLogo();
    $site_data["AFFILIATE_URL"] = $site->getSiteAffiliateUrl();
    $site_data["TOTAL_MEMBERS"] = $site->getSiteTotalmembers();
    $site_data["ACTIVE_MEMBERS"] = $site->getSiteActiveMembers();
    if( $site->getSiteFreeTrial() == "true" ){
        $site_data["FREE_TRIAL"] = "yes";
    }
    else
    {
        $site_data["FREE_TRIAL"] = "no";
    }					    

    // Process the rest of fields
    $site_options = $site->getSiteFields();
    if ($site_options) {
        foreach ($site_options as $soption) {
            switch($soption->fieldType) {               
                default:
                    $optionValue = $soption->sfValue;
                    break;
            }

            if ($has_php_code) {
                //$optionValue = htmlspecialchars($optionValue, ENT_QUOTES|ENT_HTML5);
            }
            $site_data[ strtoupper( str_replace( " ", "_", $soption->fieldName ) ) ] = $optionValue;
        }
    }    		
    
    return $site_data;
}

function render_memberships_items( $memberships_json ){
    $content = ""; 
    if( $memberships_json != "" ){
        $site_memberships = json_decode( $memberships_json, true );        
        if( is_array( $site_memberships["memberships"] ) ){
            foreach( $site_memberships["memberships"] as $membership ){
                $content .= '<li class="membership">'. $membership["membership_name"] .'</li>';
            }    
        }
    }        

    return $content;
}