<?php

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) exit;
if ( ! class_exists( 'Ftm_Dating_Sites_Center' ) ) :

	/**
	 * Main Ftm_Dating_Sites_Center Class.
	 *
	 * @package		FTMDSC
	 * @subpackage	Classes/Ftm_Dating_Sites_Center
	 * @since		1.0.0
	 * @author		FTMedia
	 */
	final class Ftm_Dating_Sites_Center {

		/**
		 * The real instance
		 *
		 * @access	private
		 * @since	1.0.0
		 * @var		object|Ftm_Dating_Sites_Center
		 */
		private static $instance;

		/**
		 * FTMDSC helpers object.
		 *
		 * @access	public
		 * @since	1.0.0
		 * @var		object|Ftm_Dating_Sites_Center_Helpers
		 */
		public $helpers;

		/**
		 * FTMDSC settings object.
		 *
		 * @access	public
		 * @since	1.0.0
		 * @var		object|Ftm_Dating_Sites_Center_Settings
		 */
		public $settings;

		/**
		 * Throw error on object clone.
		 *
		 * Cloning instances of the class is forbidden.
		 *
		 * @access	public
		 * @since	1.0.0
		 * @return	void
		 */
		public function __clone() {
			_doing_it_wrong( __FUNCTION__, __( 'You are not allowed to clone this class.', 'ftm-dating-sites-center' ), '1.0.0' );
		}

		/**
		 * Disable unserializing of the class.
		 *
		 * @access	public
		 * @since	1.0.0
		 * @return	void
		 */
		public function __wakeup() {
			_doing_it_wrong( __FUNCTION__, __( 'You are not allowed to unserialize this class.', 'ftm-dating-sites-center' ), '1.0.0' );
		}

		/**
		 * Main Ftm_Dating_Sites_Center Instance.
		 *
		 * Insures that only one instance of Ftm_Dating_Sites_Center exists in memory at any one
		 * time. Also prevents needing to define globals all over the place.
		 *
		 * @access		public
		 * @since		1.0.0
		 * @static
		 * @return		object|Ftm_Dating_Sites_Center	The one true Ftm_Dating_Sites_Center
		 */
		public static function instance() {
			if ( ! isset( self::$instance ) && ! ( self::$instance instanceof Ftm_Dating_Sites_Center ) ) {
				self::$instance					= new Ftm_Dating_Sites_Center;
				self::$instance->base_hooks();
				self::$instance->includes();
				self::$instance->helpers		= new Ftm_Dating_Sites_Center_Helpers();
				self::$instance->settings		= new Ftm_Dating_Sites_Center_Settings();

				//Fire the plugin logic
				new Ftm_Dating_Sites_Center_Run();

				/**
				 * Fire a custom action to allow dependencies
				 * after the successful plugin setup
				 */
				do_action( 'FTMDSC/plugin_loaded' );
			}

			return self::$instance;
		}

		/**
		 * Include required files.
		 *
		 * @access  private
		 * @since   1.0.0
		 * @return  void
		 */
		private function includes() {
			require_once FTMDSC_PLUGIN_DIR . 'core/includes/classes/class-ftm-dating-sites-center-helpers.php';
			require_once FTMDSC_PLUGIN_DIR . 'core/includes/classes/class-ftm-dating-sites-center-settings.php';

			require_once FTMDSC_PLUGIN_DIR . 'core/includes/classes/class-ftm-dating-sites-center-run.php';
		}

		/**
		 * Add base hooks for the core functionality
		 *
		 * @access  private
		 * @since   1.0.0
		 * @return  void
		 */
		private function base_hooks() {
			add_action( 'plugins_loaded', array( self::$instance, 'load_textdomain' ) );
		}

		/**
		 * Loads the plugin language files.
		 *
		 * @access  public
		 * @since   1.0.0
		 * @return  void
		 */
		public function load_textdomain() {
			load_plugin_textdomain( 'ftm-dating-sites-center', FALSE, dirname( plugin_basename( FTMDSC_PLUGIN_FILE ) ) . '/languages/' );
		}

	}

endif; // End if class_exists check.