<?php

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) exit;

/**
 * Class Ftm_Dating_Sites_Center_Run
 *
 * Thats where we bring the plugin to life
 *
 * @package		FTMDSC
 * @subpackage	Classes/Ftm_Dating_Sites_Center_Run
 * @author		FTMedia
 * @since		1.0.0
 */
class Ftm_Dating_Sites_Center_Run{

	/**
	 * Our Ftm_Dating_Sites_Center_Run constructor 
	 * to run the plugin logic.
	 *
	 * @since 1.0.0
	 */
	function __construct(){
		$this->add_hooks();
	}

	/**
	 * ######################
	 * ###
	 * #### WORDPRESS HOOKS
	 * ###
	 * ######################
	 */

	/**
	 * Registers all WordPress and plugin related hooks
	 *
	 * @access	private
	 * @since	1.0.0
	 * @return	void
	 */
	private function add_hooks(){
	
		add_action( 'plugin_action_links_' . FTMDSC_PLUGIN_BASE, array( $this, 'add_plugin_action_link' ), 20 );
		add_shortcode( 'my_shortcode_tag', array( $this, 'add_shortcode_callback' ) );
		add_action( 'admin_enqueue_scripts', array( $this, 'enqueue_backend_scripts_and_styles' ), 20 );
		add_action( 'admin_menu', array( $this, 'register_custom_admin_menu_pages' ), 20 );
		add_action( 'plugins_loaded', array( $this, 'add_wp_webhooks_integrations' ), 9 );
		register_activation_hook( FTMDSC_PLUGIN_FILE, array( $this, 'activation_hook_callback' ) );
	
	}

	/**
	 * ######################
	 * ###
	 * #### WORDPRESS HOOK CALLBACKS
	 * ###
	 * ######################
	 */

	/**
	* Adds action links to the plugin list table
	*
	* @access	public
	* @since	1.0.0
	*
	* @param	array	$links An array of plugin action links.
	*
	* @return	array	An array of plugin action links.
	*/
	public function add_plugin_action_link( $links ) {

		$links['our_shop'] = sprintf( '<a href="%s" title="Custom Link" style="font-weight:700;">%s</a>', 'https://test.test', __( 'Custom Link', 'ftm-dating-sites-center' ) );

		return $links;
	}

	/**
	 * Add the shortcode callback for [my_shortcode_tag]
	 *
	 * @access	public
	 * @since	1.0.0
	 *
	 * @param	array	$attr		Additional attributes you have added within the shortcode tag.
	 * @param	string	$content	The content you added between an opening and closing shortcode tag.
	 *
	 * @return	string	The customized content by the shortcode.
	 */
	public function add_shortcode_callback( $attr = array(), $content = '' ) {

		$content .= ' this content is added by the add_shortcode_callback() function';

		return $content;
	}

	/**
	 * Enqueue the backend related scripts and styles for this plugin.
	 * All of the added scripts andstyles will be available on every page within the backend.
	 *
	 * @access	public
	 * @since	1.0.0
	 *
	 * @return	void
	 */
	public function enqueue_backend_scripts_and_styles() {
		wp_enqueue_style( 'ftmdsc-backend-styles', FTMDSC_PLUGIN_URL . 'core/includes/assets/css/backend-styles.css', array(), FTMDSC_VERSION, 'all' );
		wp_enqueue_script( 'ftmdsc-backend-scripts', FTMDSC_PLUGIN_URL . 'core/includes/assets/js/backend-scripts.js', array(), FTMDSC_VERSION, false );
		wp_localize_script( 'ftmdsc-backend-scripts', 'ftmdsc', array(
			'plugin_name'   	=> __( FTMDSC_NAME, 'ftm-dating-sites-center' ),
		));
	}

	/**
	 * Add custom menu pages
	 *
	 * @access	public
	 * @since	1.0.0
	 *
	 * @return	void
	 */
	public function register_custom_admin_menu_pages(){

		add_menu_page( 'Custom Page Title', 'Custom Menu Title', FTMDSC()->settings->get_capability( 'default' ), 'custom-menu-slug', array( $this, 'custom_admin_menu_page_callback' ), 'dashicons-networking', 5 );

	}

	/**
	 * Add custom menu page content for the following
	 * menu item: custom-menu-slug
	 *
	 * @access	public
	 * @since	1.0.0
	 *
	 * @return	void
	 */
	public function custom_admin_menu_page_callback(){

		?>
		<p>This is the content area of your custom menu page</p>
		<?php

	}

	/**
	 * ####################
	 * ### WP Webhooks 
	 * ####################
	 */

	/*
	 * Register dynamically all integrations
	 * The integrations are available within core/includes/integrations.
	 * A new folder is considered a new integration.
	 *
	 * @access	public
	 * @since	1.0.0
	 *
	 * @return	void
	 */
	public function add_wp_webhooks_integrations(){

		// Abort if WP Webhooks is not active
		if( ! function_exists('WPWHPRO') ){
			return;
		}

		$custom_integrations = array();
		$folder = FTMDSC_PLUGIN_DIR . 'core' . DIRECTORY_SEPARATOR . 'includes' . DIRECTORY_SEPARATOR . 'integrations';

		try {
			$custom_integrations = WPWHPRO()->helpers->get_folders( $folder );
		} catch ( Exception $e ) {
			WPWHPRO()->helpers->log_issue( $e->getTraceAsString() );
		}

		if( ! empty( $custom_integrations ) ){
			foreach( $custom_integrations as $integration ){
				$file_path = $folder . DIRECTORY_SEPARATOR . $integration . DIRECTORY_SEPARATOR . $integration . '.php';
				WPWHPRO()->integrations->register_integration( array(
					'slug' => $integration,
					'path' => $file_path,
				) );
			}
		}
	}

	/**
	 * ####################
	 * ### Activation/Deactivation hooks
	 * ####################
	 */
	 
	/*
	 * This function is called on activation of the plugin
	 *
	 * @access	public
	 * @since	1.0.0
	 *
	 * @return	void
	 */
	public function activation_hook_callback(){

		//Your code
		
	}

}
