<?php
/**
 * Dating Sites Center
 *
 * @package       FTMDSC
 * @author        FTMedia
 * @version       1.0.0
 *
 * @wordpress-plugin
 * Plugin Name:   Dating Sites Center
 * Plugin URI:    https://www.ftmedia.com
 * Description:   Dating Sites Information Center
 * Version:       1.0.0
 * Author:        FTMedia
 * Author URI:    https://www.ftmedia.com
 * Text Domain:   ftm-dating-sites-center
 * Domain Path:   /languages
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) exit;
// Plugin name
define( 'FTMDSC_NAME',			'Dating Sites Center' );

// Plugin version
define( 'FTMDSC_VERSION',		'1.0.0' );

// Plugin Root File
define( 'FTMDSC_PLUGIN_FILE',	__FILE__ );

// Plugin base
define( 'FTMDSC_PLUGIN_BASE',	plugin_basename( FTMDSC_PLUGIN_FILE ) );

// Plugin Folder Path
define( 'FTMDSC_PLUGIN_DIR',	plugin_dir_path( FTMDSC_PLUGIN_FILE ) );

// Plugin Folder URL
define( 'FTMDSC_PLUGIN_URL',	plugin_dir_url( FTMDSC_PLUGIN_FILE ) );

/**
 * Load the main class for the core functionality
 */
require_once FTMDSC_PLUGIN_DIR . 'core/class-ftm-dating-sites-center.php';

/**
 * The main function to load the only instance
 * of our master class.
 *
 * @author  FTMedia
 * @since   1.0.0
 * @return  object|Ftm_Dating_Sites_Center
 */
function FTMDSC() {
	return Ftm_Dating_Sites_Center::instance();
}

FTMDSC();
