<?php

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) exit;
/**
 * Class FTMDSC_SITE
 *
 * Thats where we bring the plugin to life
 *
 * @package		FTMDSC
 * @subpackage	Classes/Ftm_Dating_Sites_Center_Run
 * @author		FTMedia
 * @since		1.0.0
 */

class FTMDSC_SITE
{
	private $siteID;
	private $siteName;
	private $siteAffiliateUrl;
	private $siteLogo;
    private $siteMemberships;
	private $siteTotalMembers;
	private $siteActiveMembers;
	private $siteFreeTrial;

	public function __construct()
	{
	}

	public function setSiteID($siteID)
	{
		$this->siteID = $siteID;
	}

	public function getSiteID()
	{
		return $this->siteID;
	}

	public function setSiteName($siteName)
	{
		$this->siteName = $siteName;
	}

	public function getSiteName()
	{
		return $this->siteName;
	}

	public function setSiteAffiliateUrl($siteAffiliateUrl)
	{
		$this->siteAffiliateUrl = $siteAffiliateUrl;
	}

	public function getSiteAffiliateUrl()
	{
		return $this->siteAffiliateUrl;
	}

	public function setSiteLogo($siteLogo)
	{
		$this->siteLogo = $siteLogo;
	}

	public function getSiteLogo()
	{
		return $this->siteLogo;
	}

	public function setSiteTotalMembers($siteTotalMembers)
	{
		$this->siteTotalMembers = $siteTotalMembers;
	}

    public function getSiteMemberships()
	{
		return str_replace( '\\', '', $this->siteMemberships );
	}

	public function setSiteMemberships($siteMemberships)
	{
		$this->siteMemberships = $siteMemberships;
	}

	public function getSiteTotalMembers()
	{
		return $this->siteTotalMembers;
	}

	public function setSiteActiveMembers($siteActiveMembers)
	{
		$this->siteActiveMembers = $siteActiveMembers;
	}

	public function getSiteActiveMembers()
	{
		return $this->siteActiveMembers;
	}

	public function setSiteFreeTrial($siteFreeTrial)
	{
		$this->siteFreeTrial = $siteFreeTrial;
	}

	public function getSiteFreeTrial()
	{
		return $this->siteFreeTrial;
	}


	public function read()
	{
		try
		{
            $siteID = $this->getSiteID();

            if( $siteID > 0 ){
                GLOBAL $wpdb;

                $ftmdc_sites = $wpdb->prefix . "ftmdc_site";
            
                $site_info = $wpdb->get_results("SELECT * FROM " . $ftmdc_sites . " WHERE siteid = " . $siteID );         
                            
                if( sizeof( $site_info ) > 0 ){
                    $this->setSiteName( $site_info[0]->siteName );
                    $this->setSiteAffiliateUrl( $site_info[0]->siteAffiliateUrl );
                    $this->setSiteLogo( $site_info[0]->siteLogo );
                    $this->setSiteMemberships( $site_info[0]->siteMemberships );
                    $this->setSiteTotalMembers( $site_info[0]->siteTotalMembers );
                    $this->setSiteActiveMembers( $site_info[0]->siteActiveMembers );
                    if( $site_info[0]->siteFreeTrial == "1" ){
                        $this->setSiteFreeTrial( true );
                    }
                    else
                    {
                        $this->setSiteFreeTrial( false );
                    }
                    return true;
                }               
                else
                {
                    return false;
                } 
            }  
            else
            {
                return null;
            }          
		}
		catch(Exception $exception)
		{
			return $exception->getMessage();
		}
	}

	public function update()
	{
		try
		{
            global $wpdb;
            $ftmdc_sites = $wpdb->prefix . "ftmdc_site";

            $update = $wpdb->update($ftmdc_sites,
            array(
                'siteName' 		   => $this->getSiteName(),
                'siteAffiliateUrl' => $this->getSiteAffiliateUrl(),
                'siteLogo'         => $this->getSiteLogo(),
                'siteMemberships'  => $this->getSiteMemberships(),
                'siteTotalMembers' => $this->getSiteTotalMembers(),
                'siteActiveMembers'=> $this->getSiteActiveMembers(),
                'siteFreeTrial'    => $this->getSiteFreeTrial()
            ),
            array ('siteID' =>  $this->getSiteID()),
            array(
                '%s',
                '%s',
                '%s',
                '%s',
                '%d',
                '%d',
                '%s'
            )
        );

            if($update !== false){
                $result = true;
                /*
                if(update_site_details($wpdb,$siteID, $wizard_options, $siteName) === true){
                    $result = true;
                    $siteInfo  = mim_geo_target_sites_info($siteID);
                    do_action("mim_geo_target_update_site", $siteInfo);
                }
                else
                {
                    $result = false;
                }*/
            }else{
                $result = false;            
            }

            return $result;

		}
		catch(Exception $exception)
		{
            return $exception->getMessage();
		}
	}

	public function delete()
	{
		try
		{		
        }
		catch(Exception $exception)
		{
			echo $exception->getMessage();
		}
	}
}