<?php
/**
 * Dating Sites Center
 *
 * @package       FTMDSC
 * @author        FTMedia
 * @version       1.0.0
 *
 * @wordpress-plugin
 * Plugin Name:   Dating Sites Center
 * Plugin URI:    https://www.ftmedia.com
 * Description:   Dating Sites Information Center
 * Version:       1.0.0
 * Author:        FTMedia
 * Author URI:    https://www.ftmedia.com
 * Text Domain:   ftm-dating-sites-center
 * Domain Path:   /languages
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) exit;
// Plugin name
define( 'FTMDSC_NAME',			'Dating Sites Center' );

// Plugin version
define( 'FTMDSC_VERSION',		'1.0.0' );

// Plugin DB version
define( 'FTMDSC_DB_VERSION',	'1.0.0' );

// Plugin Root File
define( 'FTMDSC_PLUGIN_FILE',	__FILE__ );

// Plugin base
define( 'FTMDSC_PLUGIN_BASE',	plugin_basename( FTMDSC_PLUGIN_FILE ) );

// Plugin Folder Path
define( 'FTMDSC_PLUGIN_DIR',	plugin_dir_path( FTMDSC_PLUGIN_FILE ) );

// Plugin Folder URL
define( 'FTMDSC_PLUGIN_URL',	plugin_dir_url( FTMDSC_PLUGIN_FILE ) );

/**
 * Load the main class for the core functionality
 */
require_once FTMDSC_PLUGIN_DIR . 'core/class-ftm-dating-sites-center.php';

/**
 * The main function to load the only instance
 * of our master class.
 *
 * @author  FTMedia
 * @since   1.0.0
 * @return  object|Ftm_Dating_Sites_Center
 */
function FTMDSC() {
	return Ftm_Dating_Sites_Center::instance();
}

FTMDSC();


//PLUGIN UTILITY METHODS
function read_sql_file($filename){
    try {
        $main_sql_data_file = FTMDSC_PLUGIN_DIR . '/sql_files/' . $filename;
        $sql_file = fopen($main_sql_data_file, "r");
        $main_sql_data_query = fread($sql_file, filesize($main_sql_data_file));
        fclose($sql_file);

        return $main_sql_data_query;
    }
    catch (Exception $e){
        return ("Error: " . $e->getMessage());
    }
}


function render_admin_message( $output_message_type, $output_message ){
    if( !is_null( $output_message_type ) ){
        switch ( $output_message_type ) {
            case "success" : 
                printf( '<div class="notice notice-success is-dismissible"><p>Success: %s</p></div>', esc_html( $output_message ) );
                break;
            case "warning" : 
                printf( '<div class="notice notice-warning is-dismissible"><p>Warning: %s</p></div>', esc_html( $output_message ) );
                break;
            case "error" : 
                printf( '<div class="notice notice-error is-dismissible"><p>Error: %s</p></div>', esc_html( $output_message ) );
                break;
        }
    }
}

function get_current_total_sites(){

    $sitesCount = -1;

    GLOBAL $wpdb;

    $ftmdc_sites = $wpdb->prefix . "ftmdc_site";

    $site_info = $wpdb->get_results("SELECT COUNT(*) AS sitesCount FROM " . $ftmdc_sites . ";" );   

    if( sizeof( $site_info ) > 0 ){
        $sitesCount = $site_info[0]->sitesCount;        
    }              

    return $sitesCount;
}

function get_all_sites(){
    GLOBAL $wpdb;

    $ftmdc_sites = $wpdb->prefix . "ftmdc_site";

    $sites_list = $wpdb->get_results("SELECT * FROM " . $ftmdc_sites . ";");         
                
    if( sizeof( $sites_list ) > 0 ){
       return $sites_list;
    }               
    else
    {
        return nulll;
    }
}