<?php 
 global $wpdb;

 $output_message = "";
 $output_message_type = null;
 $siteID = 0;
 $siteName = null;
 $site = new FTMDSC_SITE();
 $active_tab = "home";

 if( isset( $_REQUEST["siteID"] ) ){
    $siteID = intval( $_REQUEST["siteID"] );

    if( $siteID <= 0 ){
        $output_message = "No Site ID provided, please go back to the Sites List";
        $output_message_type = "error";
    }
 }

 if( isset( $_REQUEST["activeTab"] ) ){
    $active_tab = $_REQUEST["activeTab"];
 }

 if( $siteID > 0 ){    
    $site->setSiteID($siteID);
    $site_data_loaded = $site->read();
    if( is_null( $site_data_loaded ) || ($site_data_loaded == false) ){
        $output_message = "The Site ID was provided, but no data was loaded, please contact support";
        $output_message_type = "error";
    }
}

 //POSTBACK
 if( sizeof( $_POST ) > 0 ){     

    if ( isset( $_POST["site_name"] ) && strlen( $_POST['site_name'] ) > 0 
      && isset( $_POST['affiliate_url'] ) && strlen( $_POST['affiliate_url'] ) > 0
      && isset( $_POST['image_url'] ) && strlen( $_POST['image_url'] ) > 0 ){        

        $free_trial = 0;
        
        if( isset( $_POST['free_trial'] ) ){
            if( $_POST['free_trial'] == "on" ){
                $free_trial = 1;
            }
        }


        $site->setSitename( $_POST["site_name"] );
        $site->setSiteAffiliateUrl( $_POST["affiliate_url"] );
        $site->setSiteLogo( isset( $_POST['image_url'] )?$_POST[ 'image_url']:'' );
        $site->setSiteTotalMembers( isset( $_POST['total_members'] )?$_POST['total_members']:'' );
        $site->setSiteActiveMembers( isset( $_POST['active_members'] )?$_POST['active_members']:'' );
        $site->setSiteFreeTrial( $free_trial );
        $site->setSiteMemberships( $_POST["site_memberships_list"] );
        $update_result = $site->update();

        if($update_result == true){            
            $output_message_type = "success";
            $output_message = "The Site was succesfully updated!";
        }
        else
        {
            $output_message_type = "error";
            $output_message = "There was an error updating the site, please contact support";
        }
    }
    else
    {
        $output_message_type = "error";
        $output_message = "Invalid field(s) input value, please check the data before submitting.";
    }
}

//REGULAR LOAD 


?>



<?php render_admin_message( $output_message_type, $output_message );?>

<?php  if( is_null( $site_data_loaded ) || ($site_data_loaded == false) ){ exit(); } ?>

<div id="ftmdc-wrapper">
    <div class="ftmdc-top">
        <h1>Edit FTmedia's Dating Center Site</h1>
        <div style="text-align:right;">
            <button class="btn btn-success" type="submit" form="site_edit_form">Update Site</button>
        </div>
    </div>    
    <br/>
    <div>       
        <form id="site_edit_form" method="post" action="" name="site_edit_form">
            <div id="tabs" class="c-tabs">
                <div class="c-tabs-nav">
                    <a href="#" class="c-tabs-nav__link <?php echo ( $active_tab == "home"? "is-active":"" ); ?>">
                        <i class="fa fa-home"></i>
                        <span>Basic Site Info</span>
                    </a>
                    <a href="#" class="c-tabs-nav__link <?php echo ( $active_tab == "memberships"? "is-active":"" ); ?>">
                        <i class="fa fa-book"></i>
                        <span>Site Memberships</span>
                    </a>               
                </div>
                <div class="c-tab <?php echo ( $active_tab == "home"? "is-active":"" ); ?>">                
                    <div class="c-tab__content">
                        <h2>Site's Basic Information</h2>
                        <br>                        
                        <div class="row">
                            <div class="form_field">
                                <label for="site_name">Site Name:</label>
                                <input id="site_name" name="site_name" type="text" value="<?php echo $site->getSiteName(); ?>"  required data-pristine-required-message="The Site Name Required"/>
                            </div> 
                        </div>
                        <div class="row">
                            <div class="form_field">
                                <label for="affiliate_url">Affiliate URL:</label>
                                <input id="affiliate_url" name="affiliate_url" type="text" value="<?php echo $site->getSiteAffiliateUrl(); ?>"  required data-pristine-required-message="The Affiliate URL is Required"/>
                            </div> 
                        </div>
                        <div class="row">
                            <div class="form_field">
                                <label for="">Site Logo:</label>
                                <div>
                                    <input type="text" name="image_url" id="image_url" class="regular-text" value="<?php echo $site->getSiteLogo(); ?>"  required data-pristine-required-message="The Site Logo Required">
                                    <input type="button" name="upload-btn" id="upload-btn" class="button-secondary" value="Select Image">
                                </div>                                
                            </div> 
                        </div>
                        <div class="row">
                            <div class="form_field">
                                <label for="total_members">Total members:</label>
                                <input id="total_members" name="total_members" type="text" value="<?php echo $site->getSiteTotalMembers(); ?>"/>
                            </div> 
                        </div>
                        <div class="row">
                            <div class="form_field">
                                <label for="active_members">Active members:</label>
                                <input id="active_members" name="active_members" type="text" value="<?php echo $site->getSiteActiveMembers(); ?>" />
                            </div> 
                        </div>
                        <div class="row">
                            <div class="form_field">
                                <label for="free_trial">Has Free Trial:</label>
                                <input id="free_trial" name="free_trial" type="checkbox" <?php echo ( ( $site->getSiteFreeTrial()? "checked" : "" ) );  ?> />
                            </div> 
                        </div>
                    </div>                               
                </div>
                <div class="c-tab <?php echo ( $active_tab == "memberships"? "is-active":"" ); ?>">
                    <div class="c-tab__content">
                        <h2>Site Memberships</h2>
                        <p>On the left panel you can find the controls to add features to a site, on the right panel is the sortable features list.</p>
                        <hr>
                        <div class="site_memberships_wrapper">
                            <div class="left_panel">
                                <div class="row">
                                    <div class="form_field form-group">
                                        <label for="site_membership_name">Membership Name:</label>
                                        <input id="site_membership_name" name="site_membership_name" type="text" value=""/>
                                    </div> 
                                    <div class="form_field">
                                        <label for="site_membership_price">Membership Price:</label>
                                        <input id="site_membership_price" name="site_membership_price" type="text" value=""/>
                                    </div> 
                                    <div class="form_field">
                                        <label for="site_membership_features">Membership Features:</label>
                                        <?php wp_editor( '', 'site_membership_features', array( 'theme_advanced_buttons1' => 'bold, italic, ul, pH, pH_min', "media_buttons" => true, "textarea_rows" => 8, "tabindex" => 4 ) ); ?>
                                    </div>
                                    <div class="form_field">
                                        <button id="btn_membership_add" name="btn_membership_add" class="btn btn-success" type="button">Add Membership -></button>
                                    </div>  
                                </div>
                            </div>
                            <div class="right_panel">
                                <div id="site_memberships_list_container" class="sortable_list">
                                    
                                </div>
                                <input id="site_memberships_list" name="site_memberships_list" type="hidden" value='<?php echo $site->getSiteMemberships(); ?>'/>
                            </div>
                        </div>
                    </div>
                </div>          
            </div>
        </form> 
    </div>
</div>

<script>
  var myTabs = tabs({
    el: '#tabs',
    tabNavigationLinks: '.c-tabs-nav__link',
    tabContentContainers: '.c-tab'
  });

  myTabs.init();
</script>