# WordPress Plugin Installation Guide

## 📦 U.S. State Gambling Laws Widget - WordPress Plugin

This guide explains how to install and use the gambling laws widget as a complete WordPress plugin.

## 🚀 Installation Methods

### Method 1: Direct Upload (Recommended)

1. **Download Plugin Files**
   - Copy all files from this directory to create the plugin package
   - Ensure all files maintain their directory structure

2. **Create Plugin Directory**
   ```
   wp-content/plugins/gambling-laws-widget/
   ├── gambling-laws-widget.php (main plugin file)
   ├── admin/
   │   ├── admin-page.php
   │   └── settings-page.php
   ├── assets/
   │   ├── css/
   │   │   ├── frontend.css
   │   │   └── admin.css
   │   └── js/
   │       ├── frontend.js
   │       └── admin.js
   ├── templates/
   │   └── widget.php
   ├── readme.txt
   └── languages/ (for future translations)
   ```

3. **Upload to WordPress**
   - Upload the entire `gambling-laws-widget` folder to `/wp-content/plugins/`
   - Or zip the folder and upload via WordPress admin → Plugins → Add New → Upload Plugin

4. **Activate Plugin**
   - Go to WordPress admin → Plugins
   - Find "U.S. State Gambling Laws Widget"
   - Click "Activate"

### Method 2: FTP Upload

1. **Connect via FTP**
   - Use FTP client (FileZilla, WinSCP, etc.)
   - Navigate to `/wp-content/plugins/`

2. **Upload Plugin**
   - Upload the `gambling-laws-widget` folder
   - Ensure file permissions are set correctly (644 for files, 755 for folders)

3. **Activate in WordPress**
   - Go to WordPress admin → Plugins → Activate

## ⚙️ Initial Setup

### 1. Plugin Activation
Upon activation, the plugin will:
- Create database table `wp_gambling_laws`
- Insert default gambling laws data for all 50 states + DC
- Add admin menu items

### 2. Access Admin Interface
- Go to WordPress admin
- Look for "Gambling Laws" in the main menu (with location icon)
- Two submenu items available:
  - **Manage States** - Edit gambling laws for each state
  - **Settings** - Customize widget appearance

### 3. Review Default Data
- Go to Gambling Laws → Manage States
- Select any state to review/edit gambling law information
- All states come pre-populated with current 2025 data

## 📋 Usage Instructions

### Display Widget with Shortcodes

**Primary Shortcode:**
```
[gambling_laws_widget]
```

**Alternative Shortcode:**
```
[gambling_laws]
```

**Usage Examples:**
- **In Posts/Pages**: Add shortcode directly in content editor
- **In Widgets**: Use a "Text" or "Custom HTML" widget
- **In Theme Files**: Use `do_shortcode('[gambling_laws_widget]')`
- **Page Builders**: Add via shortcode elements

### Customization Options

1. **Go to Settings**
   - Gambling Laws → Settings

2. **Available Options:**
   - Widget title and subtitle
   - Color scheme (Default, Dark, Light, Custom)
   - Show/hide status icons
   - Show/hide last updated info
   - Custom CSS for advanced styling

### Managing State Data

1. **Edit Individual States**
   - Gambling Laws → Manage States
   - Select state from dropdown
   - Update any gambling law status
   - Add/edit tax and licensing notes

2. **Valid Status Options:**
   - **Sports Betting/Casino/Poker**: Legal, Illegal, Coming Soon
   - **Retail Casinos**: Legal, Illegal, Tribal Only
   - **DFS**: Legal, Illegal, Unregulated
   - **Minimum Age**: 18 or 21

3. **Bulk Operations**
   - Export all data (JSON format)
   - Import data from JSON file
   - Reset to default data

## 🎨 Styling & Themes

### Default Styling
- Professional gambling industry color scheme
- Blue/gold theme with clean typography
- Fully responsive design
- Works with any WordPress theme

### Custom Styling
1. **Via Settings Page**
   - Go to Gambling Laws → Settings
   - Select "Custom CSS" color scheme
   - Add your custom CSS rules

2. **Via Theme**
   - Add CSS to your theme's style.css
   - All widget elements use `.gambling-laws-widget-wp` prefix

### CSS Classes Reference
```css
.gambling-laws-widget-wp          /* Main widget container */
.glw-header-section               /* Header with title */
.glw-selector-section             /* State dropdown area */
.glw-results-section              /* Results display area */
.glw-status-badge                 /* Status indicator badges */
.glw-legal                        /* Legal status styling */
.glw-illegal                      /* Illegal status styling */
.glw-coming-soon                  /* Coming soon styling */
.glw-tribal-only                  /* Tribal only styling */
```

## 🔧 Advanced Features

### Database Management
- Table: `wp_gambling_laws`
- Automatic data migration on plugin updates
- Backup functionality via export

### Developer Hooks
```php
// Before widget display
do_action('glw_before_widget_display', $widget_id);

// After widget display  
do_action('glw_after_widget_display', $widget_id);

// When state data is updated
do_action('glw_state_data_updated', $state_key, $state_data);
```

### AJAX Endpoints
- `get_gambling_laws` - Fetch all state data
- `save_gambling_laws` - Update state information
- `export_gambling_laws` - Export data
- `import_gambling_laws` - Import data

## 🔒 Security Features

- WordPress nonce verification
- Data sanitization and validation
- Capability checks (`manage_options`)
- SQL injection prevention
- XSS protection

## 📱 Mobile Compatibility

- Fully responsive design
- Touch-friendly interface
- Optimized for all screen sizes
- Fast loading on mobile networks

## 🆘 Troubleshooting

### Common Issues

1. **Widget Not Displaying**
   - Check if plugin is activated
   - Verify shortcode spelling
   - Clear any caching plugins

2. **Styling Issues**
   - Check for theme conflicts
   - Clear browser cache
   - Review custom CSS

3. **Data Not Loading**
   - Check database permissions
   - Verify AJAX endpoints
   - Check for JavaScript errors

4. **Admin Interface Issues**
   - Ensure user has `manage_options` capability
   - Check for plugin conflicts
   - Review PHP error logs

### Support Resources

1. **Plugin Information**
   - Go to Gambling Laws → Settings
   - View system information table
   - Check plugin version and database status

2. **Reset Plugin**
   - Go to Gambling Laws → Settings
   - Use "Reset All Data to Defaults" button
   - This will restore original gambling laws data

3. **Export Data First**
   - Always export data before major changes
   - Use Gambling Laws → Manage States → Export

## 🎯 Best Practices

### Content Management
- Review and update data monthly
- Check for new state legislation
- Verify tax rate changes
- Update "notes" with latest information

### Performance
- Use caching plugins compatible with AJAX
- Optimize images in notes/descriptions
- Monitor database size with large sites

### SEO Considerations
- Add relevant keywords to state notes
- Use descriptive widget titles
- Include last updated dates
- Consider creating dedicated state pages

## 📈 Analytics & Tracking

### Google Analytics
- Track state selections as events
- Monitor widget engagement
- Set up goal conversions

### Implementation Example:
```javascript
// Track state selections
jQuery(document).on('change', '.glw-state-dropdown', function() {
    var stateName = jQuery(this).find('option:selected').text();
    gtag('event', 'state_selected', {
        'event_category': 'gambling_laws_widget',
        'event_label': stateName
    });
});
```

---

## 📞 Support & Updates

For support, updates, and additional documentation:
- **Website**: GamblingSite.com
- **Documentation**: Full developer docs available
- **Updates**: Automatic via WordPress admin
- **Support**: Contact support team for assistance

The gambling laws widget is now fully functional as a WordPress plugin with comprehensive admin management and easy integration capabilities!