document.addEventListener('DOMContentLoaded', function () {
  const form = document.getElementById('gsoc-form');
  const format = document.getElementById('odds-format');
  const oddsInput = document.getElementById('odds-input');
  const stakeInput = document.getElementById('stake');

  const results = document.getElementById('gsoc-results');
  const converted = document.getElementById('converted-odds');
  const implied = document.getElementById('implied-prob');
  const payout = document.getElementById('payout');
  const profit = document.getElementById('profit');

  form.addEventListener('submit', function (e) {
    e.preventDefault();

    const odds = oddsInput.value.trim();
    const stake = parseFloat(stakeInput.value);
    const selectedFormat = format.value;
    let decimalOdds;

    if (!odds || isNaN(stake)) return;

    if (selectedFormat === 'american') {
      const o = parseFloat(odds);
      decimalOdds = o > 0 ? (o / 100 + 1) : (100 / Math.abs(o) + 1);
    } else if (selectedFormat === 'decimal') {
      decimalOdds = parseFloat(odds);
    } else if (selectedFormat === 'fractional') {
      const [num, denom] = odds.split('/').map(Number);
      decimalOdds = (num / denom) + 1;
    }

    if (!decimalOdds || decimalOdds <= 1) return;

    const impliedProb = (1 / decimalOdds * 100).toFixed(2);
    const totalPayout = (stake * decimalOdds).toFixed(2);
    const totalProfit = (stake * (decimalOdds - 1)).toFixed(2);

    converted.textContent = `Decimal: ${decimalOdds.toFixed(2)} | American: ${decimalOddsToAmerican(decimalOdds)} | Fractional: ${decimalToFraction(decimalOdds - 1)}`;
    implied.textContent = impliedProb + '%';
    payout.textContent = '$' + totalPayout;
    profit.textContent = '$' + totalProfit;
    results.style.display = 'block';
  });

  function decimalOddsToAmerican(d) {
    return d >= 2 ? '+' + ((d - 1) * 100).toFixed(0) : '-' + (100 / (d - 1)).toFixed(0);
  }

  function decimalToFraction(d) {
    const gcd = (a, b) => b ? gcd(b, a % b) : a;
    const precision = 1000;
    const numerator = Math.round(d * precision);
    const denominator = precision;
    const divisor = gcd(numerator, denominator);
    return `${numerator / divisor}/${denominator / divisor}`;
  }
});
