<?php
/**
 * Plugin Name: GamblingSite Betting Odds Calculator
 * Description: A simple betting odds converter and profit calculator.
 * Version: 1.0
 * Author: GamblingSite.com
 */

defined('ABSPATH') || exit;

// Enqueue assets
function gsoc_enqueue_assets() {
    wp_enqueue_style('gsoc-style', plugin_dir_url(__FILE__) . 'assets/style.css');
    wp_enqueue_script('gsoc-script', plugin_dir_url(__FILE__) . 'assets/script.js', [], false, true);
}
add_action('wp_enqueue_scripts', 'gsoc_enqueue_assets');

// Shortcode with CTA options
function gsoc_display_calculator($atts) {
    $atts = shortcode_atts([
        'show_cta' => 'true',
        'cta_text' => 'Bet Now with FanDuel 🎯',
        'cta_url' => 'https://www.fanduel.com/?promo=your-affiliate-link',
        'cta_logo' => plugin_dir_url(__FILE__) . 'assets/fanduel-logo.png'
    ], $atts);

    ob_start();
    include plugin_dir_path(__FILE__) . 'templates/calculator-form.php';
    if ($atts['show_cta'] === 'true') {
        echo '<div class="gsoc-cta">';
        echo '<p>Want to place your bet with a trusted sportsbook?</p>';
        echo '<a href="' . esc_url($atts['cta_url']) . '" target="_blank" rel="nofollow noopener noreferrer" class="gsoc-cta-btn">';
        echo '<img src="' . esc_url($atts['cta_logo']) . '" alt="FanDuel logo" />';
        echo esc_html($atts['cta_text']);
        echo '</a></div>';
    }
    return ob_get_clean();
}
add_shortcode('odds_calculator', 'gsoc_display_calculator');
