/**
 * Site Blocks Admin JavaScript
 * Handles media uploader for certified badge
 */

jQuery(document).ready(function($) {
    'use strict';

    var mediaFrame;

    // Upload badge button click
    $('#grt-upload-badge').on('click', function(e) {
        e.preventDefault();

        // If frame already exists, open it
        if (mediaFrame) {
            mediaFrame.open();
            return;
        }

        // Create new media frame
        mediaFrame = wp.media({
            title: 'Select Certification Badge',
            button: {
                text: 'Use This Badge'
            },
            library: {
                type: 'image'
            },
            multiple: false
        });

        // When image is selected
        mediaFrame.on('select', function() {
            var attachment = mediaFrame.state().get('selection').first().toJSON();

            // Set hidden input value
            $('#grt_certified_badge').val(attachment.id);

            // Show preview
            var previewUrl = attachment.sizes && attachment.sizes.thumbnail
                ? attachment.sizes.thumbnail.url
                : attachment.url;

            $('#grt-badge-preview').html(
                '<img src="' + previewUrl + '" style="max-width: 150px; max-height: 80px;" />'
            );

            // Show remove button
            $('#grt-remove-badge').show();
        });

        // Open the frame
        mediaFrame.open();
    });

    // Remove badge button click
    $('#grt-remove-badge').on('click', function(e) {
        e.preventDefault();

        // Clear hidden input
        $('#grt_certified_badge').val('');

        // Clear preview
        $('#grt-badge-preview').html('');

        // Hide remove button
        $(this).hide();
    });

    // =============================================
    // Location-Based Disclaimers
    // =============================================

    var disclaimerIndex = $('#grt-disclaimers-list .grt-disclaimer-item').length;

    // Add disclaimer button click
    $('#grt-add-disclaimer').on('click', function(e) {
        e.preventDefault();

        var template = $('#grt-disclaimer-template').html();
        var uniqueId = Date.now().toString(36) + Math.random().toString(36).substr(2, 5);

        // Replace placeholders in template
        var newDisclaimer = template
            .replace(/{{INDEX}}/g, disclaimerIndex)
            .replace(/{{NUMBER}}/g, disclaimerIndex + 1)
            .replace(/{{UNIQUE_ID}}/g, uniqueId);

        $('#grt-disclaimers-list').append(newDisclaimer);
        disclaimerIndex++;

        updateDisclaimerNumbers();
    });

    // Remove disclaimer button click (delegated)
    $('#grt-disclaimers-list').on('click', '.grt-remove-disclaimer', function(e) {
        e.preventDefault();

        $(this).closest('.grt-disclaimer-item').remove();
        updateDisclaimerNumbers();
    });

    // Select All states for a disclaimer (delegated)
    $('#grt-disclaimers-list').on('click', '.grt-disclaimer-select-all', function(e) {
        e.preventDefault();

        $(this).closest('.grt-disclaimer-states-field')
            .find('.grt-disclaimer-states-grid input[type="checkbox"]')
            .prop('checked', true);
    });

    // Deselect All states for a disclaimer (delegated)
    $('#grt-disclaimers-list').on('click', '.grt-disclaimer-deselect-all', function(e) {
        e.preventDefault();

        $(this).closest('.grt-disclaimer-states-field')
            .find('.grt-disclaimer-states-grid input[type="checkbox"]')
            .prop('checked', false);
    });

    // Update disclaimer numbers after add/remove
    function updateDisclaimerNumbers() {
        $('#grt-disclaimers-list .grt-disclaimer-item').each(function(index) {
            $(this).find('.disclaimer-number').text(index + 1);
        });
    }
});
