# Geo-Ranking Tables WordPress Plugin

A WordPress plugin that creates geo-targeted ranking tables for gambling sites with dynamic filtering based on user location.

## Features

### Site Blocks
- Custom post type for managing gambling sites
- Store site name, description, star rating, and accepted states
- Additional fields for affiliate links, bonus information, and licensing
- Easy-to-use admin interface with state selection

### Table Blocks (Gutenberg Integration)
- Custom Gutenberg block for displaying ranking tables
- Select which site blocks to include in each table
- Configure maximum number of sites to display
- Show/hide ratings, bonuses, and license information
- Fallback options when no sites are available

### Geo-Filtering Logic
- Automatic IP-based location detection
- Filter sites based on user's state/location
- Support for multiple geo-location APIs
- Caching for improved performance
- Fallback location for development/testing

## Installation

1. Upload the `geo-ranking-tables` folder to your `/wp-content/plugins/` directory
2. Activate the plugin through the 'Plugins' menu in WordPress
3. Go to 'Geo Rankings' in your admin menu to configure settings

## Usage

### Creating Site Blocks

1. Go to **Geo Rankings > Site Blocks** in your WordPress admin
2. Click **Add New Site Block**
3. Fill in the site details:
   - Site Name
   - Description
   - Star Rating (0-5 stars)
   - Affiliate Link
   - Bonus Information
   - License Information
4. Select the states where this site accepts players
5. Publish the site block

### Adding Ranking Tables to Pages

1. Edit any post or page in the Gutenberg editor
2. Add a new block and search for "Geo Ranking Table"
3. Configure the block settings:
   - **Table Name**: Custom title for your ranking table
   - **Max Sites to Display**: Limit how many sites show (1-20)
   - **Site Selection**: Choose which site blocks to include
   - **Display Options**: Toggle ratings, bonuses, and licenses
4. Save/publish your page

### Example Scenario

1. Create 10 site blocks with different accepted states
2. Add a "Top Sports Betting Sites" table block to a page
3. Select all 10 site blocks in the block settings
4. Set max display to 5 sites
5. When users visit:
   - New Jersey user sees 3 sites (only sites accepting NJ)
   - Nevada user sees 5 sites (sites accepting NV, limited to max 5)
   - Utah user sees fallback message (no sites accept UT)

## Settings

Access plugin settings at **Geo Rankings > Settings**:

- **IP Geolocation API Key**: Optional API key for enhanced location detection
- **Enable Fallback Tables**: Show fallback when no sites available
- **Location Cache Duration**: How long to cache location data (300-86400 seconds)

## API Services

The plugin uses multiple IP geolocation services:

1. **IP-API.com** (Free, no API key required)
2. **IPInfo.io** (Free tier available)
3. **IPGeolocation.io** (Free tier with API key)

For best accuracy, obtain a free API key from IPGeolocation.io and add it in settings.

## Customization

### CSS Customization

The plugin includes comprehensive CSS classes for customization:

```css
.grt-ranking-table-wrapper { /* Main container */ }
.grt-table-header { /* Header with title and location */ }
.grt-site-row { /* Individual site row */ }
.grt-site-name { /* Site name styling */ }
.grt-stars { /* Star rating container */ }
.grt-visit-site-btn { /* Call-to-action button */ }
```

### JavaScript Hooks

Refresh all tables programmatically:
```javascript
window.grtRefreshTables();
```

### PHP Hooks

Filter location detection:
```php
add_filter('grt_detected_location', function($location) {
    // Modify location data
    return $location;
});
```

## Database Tables

The plugin creates two custom tables:

- `wp_grt_sites`: Stores site block data
- `wp_grt_table_blocks`: Stores table block configurations

## Requirements

- WordPress 5.0+
- PHP 7.4+
- Gutenberg block editor
- Modern browser with JavaScript enabled

## Security

- All user inputs are sanitized and validated
- CSRF protection with WordPress nonces
- Capability checks for admin functions
- Safe SQL queries using WordPress database API

## Performance

- Location data is cached to reduce API calls
- Optimized database queries
- Conditional script loading (only on pages with blocks)
- Efficient IP detection with fallback methods

## Troubleshooting

### Location Detection Issues
- Check if your server allows outbound HTTP requests
- Verify API key is correct (if using IPGeolocation.io)
- Test with different IP addresses
- Check browser console for JavaScript errors

### Sites Not Showing
- Ensure site blocks are published
- Check state selection in site blocks
- Verify block configuration
- Clear any caching plugins

### Block Not Appearing
- Ensure Gutenberg is enabled
- Check for JavaScript errors in browser console
- Try disabling other plugins temporarily
- Clear browser cache

## Support

For support and feature requests, please contact the plugin developer.

## Changelog

### Version 1.0.0
- Initial release
- Site blocks custom post type
- Gutenberg table blocks
- Geo-filtering functionality
- Admin interface
- Multi-API location detection