/**
 * Site Blocks Admin JavaScript
 * Handles media uploader for certified badge
 */

jQuery(document).ready(function($) {
    'use strict';

    var mediaFrame;

    // Upload badge button click
    $('#grt-upload-badge').on('click', function(e) {
        e.preventDefault();

        // If frame already exists, open it
        if (mediaFrame) {
            mediaFrame.open();
            return;
        }

        // Create new media frame
        mediaFrame = wp.media({
            title: 'Select Certification Badge',
            button: {
                text: 'Use This Badge'
            },
            library: {
                type: 'image'
            },
            multiple: false
        });

        // When image is selected
        mediaFrame.on('select', function() {
            var attachment = mediaFrame.state().get('selection').first().toJSON();

            // Set hidden input value
            $('#grt_certified_badge').val(attachment.id);

            // Show preview
            var previewUrl = attachment.sizes && attachment.sizes.thumbnail
                ? attachment.sizes.thumbnail.url
                : attachment.url;

            $('#grt-badge-preview').html(
                '<img src="' + previewUrl + '" style="max-width: 150px; max-height: 80px;" />'
            );

            // Show remove button
            $('#grt-remove-badge').show();
        });

        // Open the frame
        mediaFrame.open();
    });

    // Remove badge button click
    $('#grt-remove-badge').on('click', function(e) {
        e.preventDefault();

        // Clear hidden input
        $('#grt_certified_badge').val('');

        // Clear preview
        $('#grt-badge-preview').html('');

        // Hide remove button
        $(this).hide();
    });
});
